/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.rdflist;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RDFListComponent
extends AbstractPropertyValuesComponent
implements Disposable {
    private ResourceSelectionAction addAction = new ResourceSelectionAction("Add existing value...", OWLIcons.getAddIcon("RDFIndividual")){

        public void resourceSelected(RDFResource rDFResource) {
            RDFListComponent.this.addItem((Frame)rDFResource);
        }

        public Collection getSelectableResources() {
            AbstractCollection abstractCollection;
            OWLModel oWLModel = RDFListComponent.this.getOWLModel();
            if (RDFListComponent.this.getSubject() instanceof OWLNamedClass) {
                abstractCollection = oWLModel.getUserDefinedOWLNamedClasses();
            } else if (RDFListComponent.this.getSubject() instanceof RDFSNamedClass) {
                abstractCollection = oWLModel.getUserDefinedRDFSNamedClasses();
            } else if (RDFListComponent.this.getSubject() instanceof OWLProperty) {
                abstractCollection = oWLModel.getVisibleUserDefinedOWLProperties();
            } else {
                Collection collection = RDFListComponent.this.getListClass().getUnionRangeClasses(RDFListComponent.this.getFirstProperty());
                if (collection.size() > 0) {
                    abstractCollection = new HashSet();
                    for (Cls cls : collection) {
                        abstractCollection.addAll(cls.getInstances());
                    }
                } else {
                    abstractCollection = new ArrayList(oWLModel.getOWLIndividuals());
                }
            }
            return abstractCollection;
        }

        public RDFResource pickResource() {
            if (RDFListComponent.this.getSubject() instanceof RDFSClass) {
                String string = "Select a class to add";
                return ProtegeUI.getSelectionDialogFactory().selectClass((Component)RDFListComponent.this, RDFListComponent.this.getOWLModel(), string);
            }
            if (RDFListComponent.this.getSubject() instanceof OWLProperty) {
                String string = "Select a property to add";
                Collection collection = this.getSelectableResources();
                return ProtegeUI.getSelectionDialogFactory().selectProperty(RDFListComponent.this, RDFListComponent.this.getSubject().getOWLModel(), collection, string);
            }
            OWLModel oWLModel = RDFListComponent.this.getOWLModel();
            oWLModel.getRDFUntypedResourcesClass().setVisible(true);
            Collection collection = RDFListComponent.this.getListClass().getUnionRangeClasses(RDFListComponent.this.getFirstProperty());
            RDFResource rDFResource = ProtegeUI.getSelectionDialogFactory().selectResourceByType(RDFListComponent.this, oWLModel, collection);
            oWLModel.getRDFUntypedResourcesClass().setVisible(false);
            return rDFResource;
        }
    };
    private Action createAction = new AbstractAction("Create new value...", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent actionEvent) {
            RDFListComponent.this.handleCreateAction();
        }
    };
    private Action deleteAction = new AbstractAction("Delete selected values", OWLIcons.getDeleteIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent actionEvent) {
            RDFListComponent.this.handleDelete();
        }
    };
    private JList list;
    private DefaultListModel listModel;
    private Action moveDownAction = new AbstractAction("Move selected value down", OWLIcons.getDownIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            int n = RDFListComponent.this.list.getSelectedIndex();
            RDFListComponent.this.swapValues(n, n + 1);
        }

        public void onSelectionChange() {
            int n;
            boolean bl = false;
            Collection collection = RDFListComponent.this.getSelection();
            if (collection.size() == 1 && (n = RDFListComponent.this.list.getSelectedIndex()) < RDFListComponent.this.list.getModel().getSize() - 1) {
                bl = true;
            }
        }
    };
    private Action moveUpAction = new AbstractAction("Move selected value up", OWLIcons.getUpIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            int n = RDFListComponent.this.list.getSelectedIndex();
            RDFListComponent.this.swapValues(n, n - 1);
        }

        public void onSelectionChange() {
            int n;
            boolean bl = false;
            Collection collection = RDFListComponent.this.getSelection();
            if (collection.size() == 1 && (n = RDFListComponent.this.list.getSelectedIndex()) > 0) {
                bl = true;
            }
        }
    };
    private List registeredTo = new ArrayList();
    private Action removeAction = new AbstractAction("Remove selected value", OWLIcons.getRemoveIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent actionEvent) {
            int n = RDFListComponent.this.list.getSelectedIndex();
            RDFListComponent.this.removeListValue(RDFListComponent.this.getSubject(), RDFListComponent.this.getPredicate(), RDFListComponent.this.getListResource(), n);
        }

        public void onSelectionChange() {
        }
    };
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void browserTextChanged(RDFResource rDFResource) {
            RDFListComponent.this.repaint();
        }

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            RDFListComponent.this.unregisterPropertyValueListener();
            RDFListComponent.this.registerPropertyValueListener();
            RDFListComponent.this.refill();
        }
    };
    private Action viewAction = new AbstractAction("View selected values", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            Collection collection = RDFListComponent.this.getSelection();
            for (Object e : collection) {
                if (!(e instanceof RDFResource)) continue;
                RDFListComponent.this.getOWLModel().getProject().show((Instance)((RDFResource)e));
            }
        }
    };

    public RDFListComponent(RDFProperty rDFProperty) {
        this(rDFProperty, null);
    }

    public RDFListComponent(RDFProperty rDFProperty, String string) {
        this(rDFProperty, string, false);
    }

    public RDFListComponent(RDFProperty rDFProperty, String string, boolean bl) {
        super(rDFProperty, string, bl);
        this.addAction.setEnabled(false);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new ResourceRenderer());
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RDFListComponent.this.updateActions();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    RDFListComponent.this.viewAction.actionPerformed(null);
                }
            }
        });
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent(string == null ? this.getLabel() : string, new JScrollPane(this.list));
        oWLLabeledComponent.addHeaderButton(this.createAction);
        oWLLabeledComponent.addHeaderButton(this.addAction);
        oWLLabeledComponent.addHeaderButton(this.moveUpAction);
        oWLLabeledComponent.addHeaderButton(this.moveDownAction);
        oWLLabeledComponent.addHeaderButton(this.removeAction);
        oWLLabeledComponent.addHeaderButton(this.deleteAction);
        this.add((Component)((Object)oWLLabeledComponent));
    }

    private void addItem(Frame frame) {
        if (this.getListResource() == null) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getSubject().getProtegeType();
            Cls cls = (Cls)rDFSNamedClass.getUnionRangeClasses(this.getPredicate()).iterator().next();
            Instance instance = cls.createDirectInstance(null);
            this.getSubject().setPropertyValue(this.getPredicate(), instance);
        }
        this.appendListValue(this.getListResource(), (Instance)frame);
    }

    public void appendListValue(RDFResource rDFResource, Instance instance) {
        if (this.getFirst(rDFResource) == null) {
            rDFResource.setPropertyValue(this.getFirstProperty(), instance);
        } else if (this.getRest(rDFResource) == null || this.getNil().equals(this.getRest(rDFResource))) {
            RDFResource rDFResource2 = rDFResource.getProtegeType().createInstance(null);
            rDFResource2.setPropertyValue(this.getFirstProperty(), instance);
            rDFResource.setPropertyValue(this.getRestProperty(), rDFResource2);
        } else {
            this.appendListValue(this.getRest(rDFResource), instance);
        }
    }

    public void dispose() {
        this.unregisterPropertyValueListener();
    }

    protected Instance getFirst(Instance instance) {
        RDFProperty rDFProperty = this.getFirstProperty();
        Object object = instance.getDirectOwnSlotValue((Slot)rDFProperty);
        if (object instanceof Instance) {
            return (Instance)object;
        }
        return null;
    }

    protected RDFProperty getFirstProperty() {
        return this.getOWLModel().getRDFFirstProperty();
    }

    protected RDFSNamedClass getListClass() {
        Collection collection = ((RDFSNamedClass)this.getSubjectType()).getUnionRangeClasses(this.getPredicate());
        return (RDFSNamedClass)collection.iterator().next();
    }

    private RDFResource getListElement(int n) {
        RDFResource rDFResource = this.getListResource();
        for (int i = 0; i < n; ++i) {
            rDFResource = (RDFResource)rDFResource.getPropertyValue(this.getRestProperty());
        }
        return rDFResource;
    }

    public RDFResource getListResource() {
        return (RDFResource)this.getSubject().getPropertyValue(this.getPredicate());
    }

    protected RDFResource getNil() {
        return this.getOWLModel().getRDFNil();
    }

    protected RDFResource getRest(RDFResource rDFResource) {
        return (RDFResource)rDFResource.getPropertyValue(this.getRestProperty());
    }

    protected RDFProperty getRestProperty() {
        return this.getOWLModel().getRDFRestProperty();
    }

    public int getRowCount() {
        return this.list.getModel().getSize();
    }

    public Collection getSelection() {
        return Arrays.asList(this.list.getSelectedValues());
    }

    protected void handleCreateAction() {
        RDFSNamedClass rDFSNamedClass = this.getListClass();
        RDFProperty rDFProperty = this.getOWLModel().getRDFProperty(RDFNames.Slot.FIRST);
        Collection collection = rDFSNamedClass.getUnionRangeClasses(rDFProperty);
        RDFSNamedClass rDFSNamedClass2 = ProtegeUI.getSelectionDialogFactory().selectClass((Component)this, this.getOWLModel(), collection, "Select type of new list element");
        if (rDFSNamedClass2 != null) {
            RDFSClass rDFSClass;
            RDFResource rDFResource = rDFSNamedClass2.createInstance(null);
            if (rDFResource instanceof RDFSClass && (rDFSClass = (RDFSClass)rDFResource).getSuperclassCount() == 0) {
                rDFSClass.addSuperclass(this.getOWLModel().getOWLThingClass());
            }
            this.getOWLModel().getProject().show((Instance)rDFResource);
            this.addItem((Frame)rDFResource);
        }
    }

    private void handleDelete() {
        HashSet hashSet = new HashSet(this.getSelection());
        for (Instance instance : hashSet) {
            instance.delete();
        }
    }

    public boolean isAddEnabled() {
        RDFResource rDFResource = this.getListResource();
        if (rDFResource == null) {
            return true;
        }
        return this.getOWLModel().getTripleStoreModel().isActiveTriple(this.getSubject(), this.getPredicate(), rDFResource);
    }

    public boolean isCreateEnabled() {
        return this.isAddEnabled();
    }

    public boolean isDeleteEnabled() {
        if (this.isRemoveEnabled()) {
            int[] nArray = this.list.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                RDFResource rDFResource;
                int n = nArray[i];
                Object e = this.listModel.get(n);
                if (!(e instanceof RDFResource) || (rDFResource = (RDFResource)e).isEditable()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isMoveDownEnabled() {
        int[] nArray;
        if (this.isRemoveEnabled() && (nArray = this.list.getSelectedIndices()).length == 1) {
            return nArray[0] < this.getRowCount() - 1;
        }
        return false;
    }

    public boolean isMoveUpEnabled() {
        int[] nArray;
        if (this.isRemoveEnabled() && (nArray = this.list.getSelectedIndices()).length == 1) {
            return nArray[0] > 0;
        }
        return false;
    }

    public boolean isRemoveEnabled() {
        RDFResource rDFResource = this.getListResource();
        if (rDFResource != null && this.getOWLModel().getTripleStoreModel().isEditableTriple(this.getSubject(), this.getPredicate(), rDFResource)) {
            int[] nArray = this.list.getSelectedIndices();
            return nArray.length > 0;
        }
        return false;
    }

    private void refill() {
        this.listModel.removeAllElements();
        RDFResource rDFResource = this.getListResource();
        while (rDFResource != null && !rDFResource.equals(this.getNil())) {
            Instance instance = this.getFirst(rDFResource);
            if (instance != null) {
                this.listModel.addElement(instance);
            }
            rDFResource = this.getRest(rDFResource);
        }
    }

    private void registerPropertyValueListener() {
        RDFResource rDFResource = this.getListResource();
        RDFResource rDFResource2 = this.getNil();
        while (rDFResource != null && !rDFResource2.equals(rDFResource)) {
            rDFResource.addPropertyValueListener(this.valueListener);
            this.registeredTo.add(rDFResource);
            rDFResource = this.getRest(rDFResource);
        }
    }

    private void removeListValue(RDFResource rDFResource, RDFProperty rDFProperty, RDFResource rDFResource2, int n) {
        if (n == 0) {
            RDFResource rDFResource3 = this.getRest(rDFResource2);
            rDFResource2.setPropertyValue(this.getRestProperty(), null);
            rDFResource.setPropertyValue(rDFProperty, rDFResource3);
            rDFResource2.delete();
        } else {
            RDFResource rDFResource4 = null;
            while (n > 0) {
                --n;
                rDFResource4 = rDFResource2;
                rDFResource2 = this.getRest(rDFResource2);
            }
            RDFResource rDFResource5 = this.getRest(rDFResource2);
            rDFResource2.setPropertyValue(this.getRestProperty(), null);
            rDFResource4.setPropertyValue(this.getRestProperty(), rDFResource5);
            rDFResource2.delete();
        }
    }

    public void setSelectedRow(int n) {
        this.list.setSelectedIndex(n);
    }

    public void setSubject(RDFResource rDFResource) {
        this.unregisterPropertyValueListener();
        super.setSubject(rDFResource);
        this.registerPropertyValueListener();
        this.updateActions();
    }

    private void swapValues(int n, int n2) {
        RDFResource rDFResource = this.getListElement(n);
        RDFResource rDFResource2 = this.getListElement(n2);
        Object object = rDFResource.getDirectOwnSlotValue(this.getFirstProperty());
        Object object2 = rDFResource2.getDirectOwnSlotValue(this.getFirstProperty());
        rDFResource.setDirectOwnSlotValue(this.getFirstProperty(), object2);
        rDFResource2.setDirectOwnSlotValue(this.getFirstProperty(), object);
        this.list.setSelectedIndex(n2);
    }

    private void updateActions() {
        boolean bl = !this.isReadOnly();
        this.addAction.setEnabled(bl && this.isAddEnabled());
        this.createAction.setEnabled(bl && this.isCreateEnabled());
        this.deleteAction.setEnabled(bl && this.isDeleteEnabled());
        this.moveDownAction.setEnabled(bl && this.isMoveDownEnabled());
        this.moveUpAction.setEnabled(bl && this.isMoveUpEnabled());
        this.removeAction.setEnabled(bl && this.isRemoveEnabled());
    }

    private void unregisterPropertyValueListener() {
        for (RDFResource rDFResource : this.registeredTo) {
            rDFResource.removePropertyValueListener(this.valueListener);
        }
        this.registeredTo.clear();
    }

    public void valuesChanged() {
        this.unregisterPropertyValueListener();
        this.registerPropertyValueListener();
        this.refill();
        this.updateActions();
    }
}

