/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.multiresource;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.FrameWithBrowserTextComparator;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.individuals.OWLGetOwnSlotValuesBrowserTextJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiResourceListModel
extends AbstractListModel
implements Disposable {
    private static final long serialVersionUID = -7197293909519481988L;
    private RDFProperty predicate;
    private RDFResource subject;
    private List<FrameWithBrowserText> values = new ArrayList<FrameWithBrowserText>();
    private FrameListener frameListener;

    public MultiResourceListModel(RDFProperty rDFProperty) {
        this.predicate = rDFProperty;
        this.frameListener = this.getFrameListener();
        this.addListener();
    }

    private void addListener() {
        if (this.predicate != null) {
            this.predicate.getKnowledgeBase().addFrameListener(this.getFrameListener());
        }
    }

    private void removeListener() {
        if (this.predicate != null) {
            this.predicate.getKnowledgeBase().removeFrameListener(this.getFrameListener());
        }
    }

    private FrameListener getFrameListener() {
        if (this.frameListener == null) {
            this.frameListener = new FrameAdapter(){

                public void browserTextChanged(FrameEvent frameEvent) {
                    Frame frame = frameEvent.getFrame();
                    for (FrameWithBrowserText frameWithBrowserText : MultiResourceListModel.this.values) {
                        Frame frame2 = frameWithBrowserText.getFrame();
                        if (frame2 == null || !frame2.equals(frame)) continue;
                        MultiResourceListModel.this.updateValues();
                    }
                }
            };
        }
        return this.frameListener;
    }

    @Override
    public Object getElementAt(int n) {
        return this.values.get(n);
    }

    public RDFProperty getPredicate() {
        return this.predicate;
    }

    public RDFResource getResourceAt(int n) {
        FrameWithBrowserText frameWithBrowserText = (FrameWithBrowserText)this.getElementAt(n);
        return (RDFResource)frameWithBrowserText.getFrame();
    }

    public int getRowOf(Object object) {
        if (object instanceof RDFResource) {
            return this.values.indexOf(new FrameWithBrowserText((Frame)((RDFResource)object)));
        }
        if (object instanceof FrameWithBrowserText) {
            return this.values.indexOf(object);
        }
        return -1;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public boolean isEditable(int n) {
        TripleStoreModel tripleStoreModel = this.subject.getOWLModel().getTripleStoreModel();
        RDFResource rDFResource = this.getResourceAt(n);
        return tripleStoreModel.isEditableTriple(this.subject, this.predicate, rDFResource);
    }

    public boolean isRDFResource(int n) {
        return ((FrameWithBrowserText)this.getElementAt(n)).getFrame() instanceof RDFResource;
    }

    public void setSubject(RDFResource rDFResource) {
        this.subject = rDFResource;
        this.updateValues();
    }

    public void updateValues() {
        this.fireIntervalRemoved(this, 0, this.values.size());
        this.values = this.getValues();
        this.fireIntervalAdded(this, 0, this.values.size());
    }

    private List<FrameWithBrowserText> getValues() {
        if (this.subject != null && this.useCacheHeuristics() && this.subject.getProject().isMultiUserClient() && this.isCached()) {
            return this.getValuesFromCache();
        }
        OWLGetOwnSlotValuesBrowserTextJob oWLGetOwnSlotValuesBrowserTextJob = new OWLGetOwnSlotValuesBrowserTextJob(this.subject.getOWLModel(), (Frame)this.subject, this.predicate, false);
        Collection collection = oWLGetOwnSlotValuesBrowserTextJob.execute();
        return new ArrayList<FrameWithBrowserText>(collection);
    }

    private boolean isCached() {
        if (!RemoteClientFrameStore.isCacheComplete((Frame)this.subject) || !RemoteClientFrameStore.isCached((Frame)this.subject, (Slot)this.predicate, null, (boolean)false)) {
            return false;
        }
        Collection collection = this.subject.getPropertyValues(this.predicate);
        if (collection == null || collection.isEmpty()) {
            return true;
        }
        for (Object e : collection) {
            boolean bl;
            if (!(e instanceof Frame) || (bl = RemoteClientFrameStore.isCacheComplete((Frame)((Frame)e)))) continue;
            return false;
        }
        return true;
    }

    private List<FrameWithBrowserText> getValuesFromCache() {
        ArrayList<FrameWithBrowserText> arrayList = new ArrayList<FrameWithBrowserText>();
        Collection collection = this.getLocalValues();
        for (Object e : collection) {
            if (e instanceof Frame) {
                Frame frame = (Frame)e;
                arrayList.add(new FrameWithBrowserText(frame, frame.getBrowserText(), ((Instance)frame).getDirectTypes()));
                continue;
            }
            arrayList.add(new FrameWithBrowserText(null, e.toString(), null));
        }
        Collections.sort(arrayList, new FrameWithBrowserTextComparator());
        return arrayList;
    }

    private Collection getLocalValues() {
        ArrayList arrayList = new ArrayList(this.subject.getPropertyValues(this.predicate, true));
        arrayList.addAll(this.subject.getHasValuesOnTypes(this.predicate));
        return arrayList;
    }

    private boolean useCacheHeuristics() {
        return ApplicationProperties.getBooleanProperty((String)"owl.ui.use.cache.heuristics", (boolean)true);
    }

    public void dispose() {
        try {
            this.removeListener();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Could not remove KB listener from multi resource widget for: " + this.predicate, exception);
        }
    }
}

