/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.multiresource;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.TripleSelectable;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.components.multiresource.MultiResourceListModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;

public class MultiResourceList
extends SelectableList
implements TripleSelectable,
Disposable {
    private MultiResourceListModel listModel;
    private boolean symmetric;

    public MultiResourceList(RDFProperty rDFProperty, boolean bl) {
        this.symmetric = bl;
        this.listModel = new MultiResourceListModel(rDFProperty);
        this.setModel(this.listModel);
        this.setCellRenderer(this.createRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MultiResourceList.this.handleDoubleClick();
                }
            }
        });
        this.addMouseListener((MouseListener)new PopupMenuMouseListener((JComponent)((Object)this)){

            protected JPopupMenu getPopupMenu() {
                return MultiResourceList.this.createPopupMenu();
            }

            protected void setSelection(JComponent jComponent, int n, int n2) {
                for (int i = 0; i < MultiResourceList.this.listModel.getSize(); ++i) {
                    if (!MultiResourceList.this.getCellBounds(i, i).contains(n, n2)) continue;
                    MultiResourceList.this.setSelectedIndex(i);
                    return;
                }
                MultiResourceList.this.clearSelection();
            }
        });
    }

    protected ListCellRenderer createRenderer() {
        return new ResourceRenderer(false){

            public void load(Object object) {
                if (object instanceof FrameWithBrowserText) {
                    int n;
                    FrameWithBrowserText frameWithBrowserText = (FrameWithBrowserText)object;
                    if (frameWithBrowserText.getFrame() == null) {
                        String string = frameWithBrowserText.getBrowserText();
                        super.load(string != null ? string : "");
                        return;
                    }
                    this.setMainText(frameWithBrowserText.getBrowserText());
                    this.setMainIcon(frameWithBrowserText.getFrame().getIcon());
                    if (!MultiResourceList.this.listModel.getPredicate().getOWLModel().getProject().isMultiUserClient() && (n = MultiResourceList.this.listModel.getRowOf(object)) >= 0 && !MultiResourceList.this.listModel.isEditable(n)) {
                        this.setGrayedText(true);
                    }
                } else {
                    super.load(object);
                }
            }
        };
    }

    protected JPopupMenu createPopupMenu() {
        Object object;
        int[] nArray = this.getSelectedIndices();
        if (nArray.length == 1 && (object = this.listModel.getElementAt(nArray[0])) instanceof RDFResource) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            RDFResource rDFResource = (RDFResource)object;
            ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)this), rDFResource);
            if (jPopupMenu.getComponentCount() > 0) {
                return jPopupMenu;
            }
        }
        return null;
    }

    public MultiResourceListModel getListModel() {
        return this.listModel;
    }

    public List getPrototypeTriples() {
        RDFResource rDFResource = this.listModel.getSubject();
        RDFProperty rDFProperty = this.listModel.getPredicate();
        return Collections.singletonList(new DefaultTriple(rDFResource, rDFProperty, null));
    }

    public List getSelectedTriples() {
        RDFResource rDFResource = this.listModel.getSubject();
        RDFProperty rDFProperty = this.listModel.getPredicate();
        ArrayList<DefaultTriple> arrayList = new ArrayList<DefaultTriple>();
        for (Object e : this.getSelection()) {
            arrayList.add(new DefaultTriple(rDFResource, rDFProperty, e));
        }
        return arrayList;
    }

    protected void handleCreate() {
        RDFResource rDFResource = this.listModel.getSubject();
        RDFProperty rDFProperty = this.listModel.getPredicate();
        OWLModel oWLModel = rDFProperty.getOWLModel();
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)rDFResource.getRDFType();
        ArrayList<RDFSNamedClass> arrayList = new ArrayList<RDFSNamedClass>(rDFSNamedClass.getUnionRangeClasses(rDFProperty));
        if (OWLUtil.containsAnonymousClass(arrayList) || arrayList.isEmpty()) {
            arrayList.clear();
            arrayList.add(oWLModel.getOWLThingClass());
        } else if (OWLUI.isExternalResourcesSupported(oWLModel)) {
            arrayList.add(oWLModel.getRDFUntypedResourcesClass());
        }
        if (OWLUI.isExternalResourcesSupported(oWLModel)) {
            oWLModel.getRDFUntypedResourcesClass().setVisible(true);
        }
        RDFSNamedClass rDFSNamedClass2 = ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this), oWLModel, arrayList, "Select type of new resource");
        oWLModel.getRDFUntypedResourcesClass().setVisible(false);
        if (rDFSNamedClass2 != null) {
            RDFSClass rDFSClass;
            RDFResource rDFResource2 = rDFSNamedClass2.createInstance(null);
            if (rDFResource2 instanceof RDFUntypedResource) {
                rDFResource2 = OWLUtil.assignUniqueURI((RDFUntypedResource)rDFResource2);
            } else if (rDFResource2 instanceof RDFSClass && (rDFSClass = (RDFSClass)rDFResource2).getSuperclassCount() == 0) {
                rDFSClass.addSuperclass(oWLModel.getOWLThingClass());
            }
            rDFResource.addPropertyValue(rDFProperty, rDFResource2);
            if (this.symmetric) {
                rDFResource2.addPropertyValue(rDFProperty, rDFResource);
            }
            oWLModel.getProject().show((Instance)rDFResource2);
        }
    }

    private void handleDoubleClick() {
        int[] nArray;
        Project project = this.listModel.getPredicate().getOWLModel().getProject();
        for (int n : nArray = this.getSelectedIndices()) {
            RDFResource rDFResource = this.listModel.getResourceAt(n);
            if (!(rDFResource instanceof RDFResource)) continue;
            project.show((Instance)rDFResource);
        }
    }

    protected void handleRemove() {
        int[] nArray = this.getSelectedIndices();
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        for (int e : nArray) {
            hashSet.add(this.listModel.getResourceAt(e));
        }
        RDFProperty rDFProperty = this.listModel.getPredicate();
        RDFResource rDFResource = this.listModel.getSubject();
        for (Object e : hashSet) {
            RDFResource rDFResource2;
            rDFResource.removePropertyValue(rDFProperty, e);
            if (!this.symmetric || !(e instanceof RDFResource) || !(rDFResource2 = (RDFResource)e).getPropertyValues(rDFProperty).contains(rDFResource)) continue;
            rDFResource2.removePropertyValue(rDFProperty, rDFResource);
        }
    }

    public boolean isRemoveEnabled() {
        int[] nArray = this.getSelectedIndices();
        if (nArray.length > 0) {
            for (int n : nArray) {
                if (this.isRemoveEnabled(n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isRemoveEnabled(int n) {
        return this.listModel.isEditable(n);
    }

    public void setSelectedTriples(Collection collection) {
        this.getSelectionModel().clearSelection();
        for (Triple triple : collection) {
            int n = this.listModel.getRowOf(triple.getObject());
            if (n < 0) continue;
            this.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public void dispose() {
        this.listModel.dispose();
    }
}

