/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.literaltable;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.AddResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.AddablePropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.literaltable.LiteralTable;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditorManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LiteralTableComponent
extends AddablePropertyValuesComponent {
    private Action addAction = new AbstractAction("Add new value", OWLIcons.getAddIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            LiteralTableComponent.this.handleAddAction();
        }
    };
    private Action deleteAction = new AbstractAction("Delete selected value", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            LiteralTableComponent.this.handleDeleteAction();
        }
    };
    private LiteralTable table;
    private Action viewAction = new AbstractAction("View/edit selected value...", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            LiteralTableComponent.this.handleViewAction();
        }
    };

    public LiteralTableComponent(RDFProperty rDFProperty) {
        this(rDFProperty, null);
    }

    public LiteralTableComponent(RDFProperty rDFProperty, String string) {
        super(rDFProperty, string, false);
    }

    public LiteralTableComponent(RDFProperty rDFProperty, String string, boolean bl) {
        super(rDFProperty, string, bl);
        this.table = new LiteralTable(rDFProperty);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LiteralTableComponent.this.updateActionsState();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    LiteralTableComponent.this.handleDoubleClick();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(Color.white);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent(string == null ? this.getLabel() : string, jScrollPane);
        oWLLabeledComponent.addHeaderButton(this.viewAction);
        oWLLabeledComponent.addHeaderButton(this.addAction);
        if (!(rDFProperty instanceof OWLProperty) && rDFProperty.getRange() == null) {
            oWLLabeledComponent.addHeaderButton(new AddResourceAction(this, false));
        }
        oWLLabeledComponent.addHeaderButton(this.deleteAction);
        this.add((Component)((Object)oWLLabeledComponent));
        this.updateActionsState();
    }

    private Object createDefaultValue() {
        Object object;
        Object object2;
        RDFProperty rDFProperty = this.getPredicate();
        Iterator iterator = PropertyValueEditorManager.listEditors();
        while (iterator.hasNext()) {
            object2 = (PropertyValueEditor)iterator.next();
            if (!object2.canEdit(this.getSubject(), rDFProperty, null) || (object = object2.createDefaultValue(this.getSubject(), rDFProperty)) == null) continue;
            return object;
        }
        object2 = rDFProperty.getRange();
        if (object2 instanceof RDFSDatatype) {
            return ((RDFSDatatype)object2).getDefaultValue();
        }
        if (object2 instanceof OWLDataRange) {
            object = (OWLDataRange)object2;
            RDFList rDFList = object.getOneOf();
            Object var6_6 = null;
            if (rDFList != null) {
                RDFResource rDFResource = this.getSubject();
                RDFProperty rDFProperty2 = this.getPredicate();
                Iterator iterator2 = rDFList.getValues().iterator();
                while (iterator2.hasNext() && var6_6 == null) {
                    Object e = iterator2.next();
                    if (rDFResource.hasPropertyValue(rDFProperty2, e)) continue;
                    var6_6 = e;
                }
                if (var6_6 == null) {
                    ProtegeUI.getModalDialogFactory().showMessageDialog(this.getOWLModel(), "You have already assigned all allowed values");
                }
            }
            return var6_6;
        }
        if (rDFProperty instanceof OWLObjectProperty) {
            return null;
        }
        return "";
    }

    private void handleAddAction() {
        Object object = this.createDefaultValue();
        if (object != null && !this.getObjects().contains(object)) {
            this.getSubject().addPropertyValue(this.getPredicate(), object);
            this.table.setSelectedRow(object);
            if (object instanceof DefaultRDFSLiteral && ((DefaultRDFSLiteral)object).getDatatype().equals(this.getOWLModel().getXSDstring())) {
                this.table.editCell(object);
                return;
            }
            if (!object.equals("")) {
                Iterator iterator = PropertyValueEditorManager.listEditors();
                while (iterator.hasNext()) {
                    PropertyValueEditor propertyValueEditor = (PropertyValueEditor)iterator.next();
                    if (!propertyValueEditor.canEdit(this.getSubject(), this.getPredicate(), null)) continue;
                    Object object2 = propertyValueEditor.editValue(this, this.getSubject(), this.getPredicate(), object);
                    if (object2 != null) {
                        this.getSubject().removePropertyValue(this.getPredicate(), object);
                        this.getSubject().addPropertyValue(this.getPredicate(), object2);
                        this.table.setSelectedRow(object2);
                    }
                    return;
                }
            }
            this.table.editCell(object);
        }
    }

    private void handleDeleteAction() {
        List list = this.getOWLModel().asRDFSLiterals(this.getObjects());
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.table.getTableModel().getRowCount()) continue;
            Object object = this.table.getTableModel().getObject(n);
            list.remove(object);
        }
        this.getSubject().setPropertyValues(this.getPredicate(), list);
    }

    protected void handleDoubleClick() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 1 && this.viewAction.isEnabled() && !this.table.getTableModel().isCellEditable(nArray[0], 0)) {
            this.handleViewAction();
        }
    }

    protected void handleViewAction() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length > 0) {
            this.table.stopEditing();
            Object object = this.table.getTableModel().getObject(nArray[0]);
            if (object instanceof RDFResource) {
                RDFResource rDFResource = (RDFResource)object;
                rDFResource.getProject().show((Instance)rDFResource);
            } else {
                Object object2;
                PropertyValueEditor propertyValueEditor = this.getEditor(object);
                if (propertyValueEditor != null && (object2 = propertyValueEditor.editValue(null, this.getSubject(), this.getPredicate(), object)) != null) {
                    Object object3;
                    if (object instanceof RDFSLiteral && (object3 = ((RDFSLiteral)object).getPlainValue()) != null) {
                        object = object3;
                    }
                    this.getSubject().removePropertyValue(this.getPredicate(), object);
                    this.getSubject().addPropertyValue(this.getPredicate(), object2);
                    this.table.setSelectedRow(object2);
                }
            }
        }
    }

    public void setSubject(RDFResource rDFResource) {
        super.setSubject(rDFResource);
        this.table.setSubject(rDFResource);
    }

    private void updateActionsState() {
        int[] nArray = this.table.getSelectedRows();
        boolean bl = !this.isReadOnly() && this.table.getTableModel().isDeleteEnabled(nArray);
        this.deleteAction.setEnabled(bl);
        if (this.isReadOnly()) {
            this.viewAction.setEnabled(false);
        } else {
            boolean bl2 = false;
            if (nArray.length == 1) {
                Object object = this.table.getTableModel().getObject(nArray[0]);
                if (object instanceof RDFResource) {
                    bl2 = true;
                } else if (this.getSubject().getAllValuesFromOnTypes(this.getPredicate()) instanceof OWLDataRange) {
                    bl2 = false;
                } else {
                    PropertyValueEditor propertyValueEditor = this.getEditor(object);
                    if (propertyValueEditor != null) {
                        TripleStoreModel tripleStoreModel = this.getOWLModel().getTripleStoreModel();
                        bl2 = tripleStoreModel.isActiveTriple(this.getSubject(), this.getPredicate(), object);
                    }
                }
            }
            this.viewAction.setEnabled(bl2);
        }
        this.addAction.setEnabled(!this.isReadOnly());
    }

    public void valuesChanged() {
        this.table.getTableModel().updateValues();
    }
}

