/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.literaltable;

import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import edu.stanford.smi.protegex.owl.ui.components.literaltable.LiteralTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LiteralTable
extends JTable {
    private JComboBox dataRangeComboBox;
    private JComboBox datatypeComboBox;
    private DefaultCellEditor defaultEditor;
    private JComboBox langComboBox;
    private LiteralTableModel tableModel;
    private JTextField textField;

    public LiteralTable(RDFProperty rDFProperty) {
        this.tableModel = new LiteralTableModel(rDFProperty);
        this.setModel(this.tableModel);
        this.setColumnWidth(0, 200);
        this.setColumnWidth(1, 100);
        this.textField = new JTextField();
        OWLUI.addCopyPastePopup(this.textField);
        this.defaultEditor = new DefaultCellEditor(this.textField);
        this.setDefaultEditor(Object.class, this.defaultEditor);
        this.dataRangeComboBox = new JComboBox();
        OWLModel oWLModel = rDFProperty.getOWLModel();
        this.datatypeComboBox = ComponentUtil.createDatatypeComboBox(oWLModel);
        this.langComboBox = ComponentUtil.createLanguageComboBox(oWLModel, null);
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object instanceof RDFSDatatype) {
                    object = ((RDFSDatatype)object).getLocalName();
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        TableColumn tableColumn2 = this.getColumnModel().getColumn(0);
        tableColumn2.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        this.updateCellEditor();
    }

    public void editCell(Object object) {
        int n = this.tableModel.getRow(object);
        this.editCell(n);
    }

    public void editCell(int n) {
        if (n >= 0 && n < this.tableModel.getRowCount()) {
            this.getSelectionModel().setSelectionInterval(n, n);
            this.scrollRectToVisible(this.getCellRect(n, 0, true));
            this.editCellAt(n, 0);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LiteralTable.this.textField.requestFocus();
                }
            });
        }
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        RDFResource rDFResource;
        RDFResource rDFResource2;
        if (n2 == 0 && (rDFResource2 = (rDFResource = this.tableModel.getSubject()).getAllValuesFromOnTypes(this.tableModel.getPredicate())) instanceof OWLDataRange) {
            OWLDataRange oWLDataRange = (OWLDataRange)rDFResource2;
            Object[] objectArray = oWLDataRange.getOneOfValues().toArray();
            this.dataRangeComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
            return new DefaultCellEditor(this.dataRangeComboBox);
        }
        return super.getCellEditor(n, n2);
    }

    public LiteralTableModel getTableModel() {
        return this.tableModel;
    }

    private void setColumnWidth(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
    }

    public void setSelectedRow(Object object) {
        int n = this.tableModel.getRow(object);
        if (n >= 0) {
            this.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    public void setSubject(RDFResource rDFResource) {
        this.stopEditing();
        this.tableModel.setSubject(rDFResource);
        this.updateCellEditor();
    }

    public void stopEditing() {
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.getCellEditor().stopCellEditing();
        this.defaultEditor.stopCellEditing();
    }

    private void updateCellEditor() {
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        if (this.tableModel.isStringProperty()) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.langComboBox));
        } else {
            tableColumn.setCellEditor(new DefaultCellEditor(this.datatypeComboBox));
        }
    }
}

