/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AddTodoAction;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTable;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableModel;
import edu.stanford.smi.protegex.owl.ui.components.triples.AbstractTriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.AddResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.CreateValueAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.DeleteTripleAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;

public class AnnotationsComponent
extends AbstractTriplesComponent {
    private static final long serialVersionUID = -8853232024353780133L;
    private Action deleteRowAction;
    private Action createValueAction;
    private Action todoAction;
    private Action addResourceAction;

    public AnnotationsComponent(RDFProperty rDFProperty) {
        this(rDFProperty, false);
    }

    public AnnotationsComponent(RDFProperty rDFProperty, boolean bl) {
        super(rDFProperty, "Annotations", OWLIcons.getImageIcon("AnnotationsTable"), bl);
    }

    protected void addButtons(LabeledComponent labeledComponent) {
        this.createValueAction = new CreateValueAction(this.getTable(), "Create new annotation value", OWLIcons.getCreateIcon("Annotation")){
            private static final long serialVersionUID = 2018303283100762805L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationsComponent.this.getTableModel().setAllowReadOnlyEdit(true);
                try {
                    super.actionPerformed(actionEvent);
                }
                finally {
                    AnnotationsComponent.this.getTableModel().setAllowReadOnlyEdit(false);
                }
            }

            public Collection getSelectableResources() {
                TriplesTableModel triplesTableModel = this.table.getTableModel();
                OWLModel oWLModel = triplesTableModel.getOWLModel();
                ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
                Collection<RDFProperty> collection = oWLModel.getOWLAnnotationProperties();
                Collection collection2 = oWLModel.getOWLOntologyProperties();
                RDFResource rDFResource = triplesTableModel.getSubject();
                for (RDFProperty rDFProperty : collection) {
                    if (collection2.contains(rDFProperty)) {
                        if (!(rDFResource instanceof OWLOntology)) continue;
                        arrayList.add(rDFProperty);
                        continue;
                    }
                    RDFSClass rDFSClass = rDFResource.getProtegeType();
                    Collection collection3 = rDFSClass.getUnionDomainProperties(true);
                    if (!collection3.contains(rDFProperty)) continue;
                    boolean bl = rDFResource.getPropertyValues(rDFProperty, true).isEmpty();
                    if (rDFProperty.isFunctional() && !bl) continue;
                    arrayList.add(rDFProperty);
                }
                return arrayList;
            }
        };
        labeledComponent.addHeaderButton(this.createValueAction);
        this.todoAction = new AddTodoAction((AnnotationsTable)this.getTable());
        labeledComponent.addHeaderButton(this.todoAction);
        this.addResourceAction = new AddResourceAction(this.getTable()){

            protected Collection getAllowedProperties(OWLModel oWLModel) {
                ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
                for (RDFProperty rDFProperty : oWLModel.getOWLAnnotationProperties()) {
                    arrayList.add(rDFProperty);
                }
                return arrayList;
            }
        };
        labeledComponent.addHeaderButton(this.addResourceAction);
        this.deleteRowAction = new DeleteTripleAction(this.getTable(), "Delete selected annotation", OWLIcons.getDeleteIcon("Annotation"));
        this.deleteRowAction.setEnabled(false);
        labeledComponent.addHeaderButton(this.deleteRowAction);
    }

    protected TriplesTable createTable(Project project) {
        return new AnnotationsTable(project, (AnnotationsTableModel)this.getTableModel());
    }

    protected TriplesTableModel createTableModel() {
        return new AnnotationsTableModel();
    }

    protected void updateActions() {
        super.updateActions();
        int n = this.getTable().getSelectedRow();
        TriplesTableModel triplesTableModel = this.getTable().getTableModel();
        boolean bl = false;
        if (n >= 0) {
            bl = triplesTableModel.isDeleteEnabled(n);
        }
        this.deleteRowAction.setEnabled(this.isEnabled() && bl);
    }

    public void setEnabled(boolean bl) {
        this.createValueAction.setEnabled(bl);
        this.addResourceAction.setEnabled(bl);
        this.todoAction.setEnabled(bl);
        this.deleteRowAction.setEnabled(bl);
        this.getTable().setEnabled(bl);
        super.setEnabled(bl);
    }
}

