/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.AddablePropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AddResourceAction
extends ResourceSelectionAction {
    protected AddablePropertyValuesComponent component;
    protected boolean symmetric;

    public AddResourceAction(AddablePropertyValuesComponent addablePropertyValuesComponent, boolean bl) {
        super("Add...", OWLIcons.getAddIcon("RDFIndividual"), true);
        this.component = addablePropertyValuesComponent;
        this.symmetric = bl;
    }

    public Collection getSelectableResources() {
        AbstractCollection abstractCollection;
        RDFResource rDFResource = this.component.getSubject();
        RDFProperty rDFProperty = this.component.getPredicate();
        OWLModel oWLModel = rDFResource.getOWLModel();
        if (this.isClassProperty()) {
            abstractCollection = oWLModel.getUserDefinedRDFSNamedClasses();
        } else {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)rDFResource.getProtegeType();
            Collection collection = rDFSNamedClass.getUnionRangeClasses(rDFProperty);
            if (collection.size() > 0 && !OWLUtil.containsAnonymousClass(collection)) {
                abstractCollection = new HashSet();
                for (Cls cls : collection) {
                    if (!cls.isVisible()) continue;
                    abstractCollection.addAll(cls.getInstances());
                }
            } else {
                abstractCollection = rDFProperty instanceof OWLProperty ? new ArrayList(oWLModel.getOWLIndividuals(true)) : new ArrayList(oWLModel.getRDFIndividuals(true));
            }
        }
        if (OWLUI.isExternalResourcesSupported(oWLModel)) {
            abstractCollection.addAll(oWLModel.getRDFUntypedResourcesClass().getInstances(false));
        }
        abstractCollection.remove(rDFResource);
        abstractCollection.removeAll(rDFResource.getPropertyValues(rDFProperty));
        return AbstractOWLModel.getRDFResources(oWLModel, abstractCollection);
    }

    private boolean isClassProperty() {
        RDFResource rDFResource = this.component.getSubject();
        RDFProperty rDFProperty = this.component.getPredicate();
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)rDFResource.getProtegeType();
        Collection collection = rDFSNamedClass.getUnionRangeClasses(rDFProperty);
        RDFSNamedClass rDFSNamedClass2 = rDFProperty.getOWLModel().getRDFSNamedClassClass();
        if (collection.size() == 1) {
            RDFSClass rDFSClass = (RDFSClass)collection.iterator().next();
            return rDFSClass.equals(rDFSNamedClass2) || rDFSClass.getSuperclasses(true).contains(rDFSNamedClass2);
        }
        return false;
    }

    private boolean isPropertyProperty() {
        RDFResource rDFResource = this.component.getSubject();
        RDFProperty rDFProperty = this.component.getPredicate();
        if (rDFProperty.getValueType() == ValueType.INSTANCE) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)rDFResource.getProtegeType();
            Collection collection = rDFSNamedClass.getUnionRangeClasses(rDFProperty);
            RDFSNamedClass rDFSNamedClass2 = rDFProperty.getOWLModel().getRDFPropertyClass();
            return collection.size() == 1 && ((RDFSClass)collection.iterator().next()).getSuperclasses(true).contains(rDFSNamedClass2);
        }
        return false;
    }

    public Collection pickResources() {
        Collection collection;
        RDFResource rDFResource = this.component.getSubject();
        RDFProperty rDFProperty = this.component.getPredicate();
        OWLModel oWLModel = rDFProperty.getOWLModel();
        if (OWLUI.isExternalResourcesSupported(oWLModel)) {
            oWLModel.getRDFUntypedResourcesClass().setVisible(true);
        }
        if (this.isClassProperty()) {
            String string = "Select classes to add";
            collection = ProtegeUI.getSelectionDialogFactory().selectClasses(this.component, oWLModel, string);
        } else if (this.isPropertyProperty()) {
            String string = "Select properties to add";
            Collection collection2 = oWLModel.getVisibleUserDefinedRDFProperties();
            collection = ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection(this.component, oWLModel, collection2, string);
        } else {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)rDFResource.getRDFType();
            Set<OWLNamedClass> set = rDFSNamedClass.getUnionRangeClasses(rDFProperty);
            if (OWLUtil.containsAnonymousClass(set) || set.isEmpty()) {
                set = Collections.singleton(oWLModel.getOWLThingClass());
            }
            collection = this.selectResourcesByType(oWLModel, set);
        }
        oWLModel.getRDFUntypedResourcesClass().setVisible(false);
        return collection;
    }

    protected Collection selectResourcesByType(OWLModel oWLModel, Collection collection) {
        return ProtegeUI.getSelectionDialogFactory().selectResourcesByType(this.component, oWLModel, collection);
    }

    public void resourceSelected(RDFResource rDFResource) {
        RDFProperty rDFProperty;
        RDFResource rDFResource2 = this.component.getSubject();
        if (rDFResource2.getPropertyValues(rDFProperty = this.component.getPredicate()).contains(rDFResource)) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(rDFResource2.getOWLModel(), "The object " + rDFResource.getBrowserText() + " is already in the list.");
        } else {
            this.component.addObject(rDFResource, this.symmetric);
        }
    }
}

