/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.components.PropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditorManager;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;

public abstract class AbstractPropertyValuesComponent
extends JComponent
implements PropertyValuesComponent {
    private final RDFProperty predicate;
    private RDFResource subject;
    private String label;
    private boolean editable = true;
    private boolean isReadOnly = false;

    protected AbstractPropertyValuesComponent(RDFProperty rDFProperty) {
        this(rDFProperty, null);
    }

    protected AbstractPropertyValuesComponent(RDFProperty rDFProperty, String string) {
        this(rDFProperty, string, false);
    }

    protected AbstractPropertyValuesComponent(RDFProperty rDFProperty, String string, boolean bl) {
        this.predicate = rDFProperty;
        this.setLayout(new BorderLayout());
        this.label = string;
        this.isReadOnly = bl;
    }

    protected PropertyValueEditor getEditor(Object object) {
        RDFResource rDFResource = this.getSubject();
        RDFProperty rDFProperty = this.getPredicate();
        return PropertyValueEditorManager.getEditor(rDFResource, rDFProperty, object);
    }

    protected String getLabel() {
        if (this.label == null) {
            RDFProperty rDFProperty = this.getPredicate();
            String string = rDFProperty.getBrowserText();
            if (this.getOWLModel().getProject().getPrettyPrintSlotWidgetLabels()) {
                string = StringUtilities.symbolToLabel((String)string);
            }
            return string;
        }
        return this.label;
    }

    protected Object getObject() {
        Collection collection = this.getObjects();
        if (collection.isEmpty()) {
            return null;
        }
        return collection.iterator().next();
    }

    public Collection getObjects() {
        return this.getObjects(false);
    }

    public Collection getObjects(boolean bl) {
        RDFResource rDFResource = this.getSubject();
        if (rDFResource != null) {
            return rDFResource.getPropertyValues(this.getPredicate(), bl);
        }
        return Collections.EMPTY_LIST;
    }

    protected OWLModel getOWLModel() {
        return this.predicate.getOWLModel();
    }

    public RDFProperty getPredicate() {
        return this.predicate;
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public RDFSClass getSubjectType() {
        RDFResource rDFResource = this.getSubject();
        if (rDFResource != null) {
            return rDFResource.getRDFType();
        }
        return null;
    }

    protected boolean hasHasValueRestriction() {
        if (this.getSubject() != null && this.getPredicate() != null) {
            return !this.getSubject().getHasValuesOnTypes(this.getPredicate()).isEmpty();
        }
        return false;
    }

    protected boolean hasOnlyEditableValues() {
        return true;
    }

    protected boolean isEnumerationProperty() {
        if (this.subject != null) {
            for (RDFSClass rDFSClass : this.subject.getRDFTypes()) {
                OWLNamedClass oWLNamedClass;
                RDFResource rDFResource;
                if (!(rDFSClass instanceof OWLNamedClass) || !((rDFResource = (oWLNamedClass = (OWLNamedClass)rDFSClass).getAllValuesFrom(this.predicate)) instanceof OWLNamedClass)) continue;
                OWLNamedClass oWLNamedClass2 = (OWLNamedClass)rDFResource;
                Iterator iterator = oWLNamedClass2.getSuperclasses(false).iterator();
                while (iterator.hasNext()) {
                    if (!(iterator.next() instanceof OWLEnumeratedClass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setSubject(RDFResource rDFResource) {
        this.subject = rDFResource;
        this.repaint();
    }

    protected void showResource(RDFResource rDFResource) {
        this.getOWLModel().getProject().show((Instance)rDFResource);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void dispose() {
    }
}

