/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplayFactory;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactParserUtil;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class OWLTextFormatter {
    private static OWLClassDisplay display = OWLClassDisplayFactory.getDefaultDisplay();
    private static String[][] charMap;
    private static Hashtable<String, String> symbolMap;

    public static void updateDisplay(OWLClassDisplay oWLClassDisplay) {
        String[][] stringArrayArray = new String[][]{{"<", oWLClassDisplay.getOWLMaxCardinalitySymbol()}, {"=", oWLClassDisplay.getOWLCardinalitySymbol()}, {">", oWLClassDisplay.getOWLMinCardinalitySymbol()}, {"*", oWLClassDisplay.getOWLAllValuesFromSymbol()}, {"?", oWLClassDisplay.getOWLSomeValuesFromSymbol()}, {"$", oWLClassDisplay.getOWLHasValueSymbol()}, {"!", oWLClassDisplay.getOWLComplementOfSymbol()}, {"&", oWLClassDisplay.getOWLIntersectionOfSymbol()}, {"|", oWLClassDisplay.getOWLUnionOfSymbol()}};
        charMap = stringArrayArray;
        symbolMap.clear();
        symbolMap.put("all", "" + oWLClassDisplay.getOWLAllValuesFromSymbol());
        symbolMap.put("allValuesFrom", "" + oWLClassDisplay.getOWLAllValuesFromSymbol());
        symbolMap.put("forall", "" + oWLClassDisplay.getOWLAllValuesFromSymbol());
        symbolMap.put("only", "" + oWLClassDisplay.getOWLAllValuesFromSymbol());
        symbolMap.put("some", "" + oWLClassDisplay.getOWLSomeValuesFromSymbol());
        symbolMap.put("someValuesFrom", "" + oWLClassDisplay.getOWLSomeValuesFromSymbol());
        symbolMap.put("exists", "" + oWLClassDisplay.getOWLSomeValuesFromSymbol());
        symbolMap.put("has", "" + oWLClassDisplay.getOWLHasValueSymbol());
        symbolMap.put("hasValue", "" + oWLClassDisplay.getOWLHasValueSymbol());
        symbolMap.put("value", "" + oWLClassDisplay.getOWLHasValueSymbol());
        symbolMap.put("and", "" + oWLClassDisplay.getOWLIntersectionOfSymbol());
        symbolMap.put("or", "" + oWLClassDisplay.getOWLUnionOfSymbol());
        symbolMap.put("not", "" + oWLClassDisplay.getOWLComplementOfSymbol());
    }

    public static String getDisplayString(String string) {
        int n = string.length();
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n,(){}[]", true);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (string4.length() == 1) {
                char c = string4.charAt(0);
                for (int i = 0; i < charMap.length; ++i) {
                    String[] stringArray = charMap[i];
                    if (stringArray[0].charAt(0) != c) continue;
                    string4 = "" + stringArray[1];
                    break;
                }
            }
            if ((string3 = symbolMap.get(string4)) != null && (n2 += string4.length()) < n) {
                string2 = string2 + string3;
                continue;
            }
            string2 = string2 + string4;
        }
        return string2;
    }

    public static String getParseableString(String string) {
        return CompactParserUtil.getParseableString(string);
    }

    public static void initKeymap(JTextComponent jTextComponent) {
        jTextComponent.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                for (int i = 0; i < charMap.length; ++i) {
                    String[] stringArray = charMap[i];
                    if (stringArray[0].charAt(0) != c) continue;
                    JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
                    try {
                        jTextComponent.getDocument().insertString(jTextComponent.getCaretPosition(), "" + stringArray[1], null);
                        keyEvent.consume();
                        return;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void updateSyntax(JTextComponent jTextComponent) {
        OWLTextFormatter.updateSyntax(jTextComponent, null);
    }

    public static void updateSyntax(JTextComponent jTextComponent, OWLModel oWLModel) {
        OWLTextFormatter.updateSyntax(jTextComponent, oWLModel, symbolMap);
    }

    public static void updateSyntax(JTextComponent jTextComponent, OWLModel oWLModel, Map map) {
        String string = jTextComponent.getText();
        int n = jTextComponent.getCaretPosition();
        int n2 = string.length();
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n,(){}[]", true);
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = (String)map.get(string3);
            if (string4 != null && (n3 += string3.length()) < n2 && (oWLModel == null || oWLModel.getRDFResource(string3) == null)) {
                if ((string2 = string2 + string4).length() >= n) continue;
                n = n - string3.length() + string4.length();
                continue;
            }
            string2 = string2 + string3;
        }
        if (!string.equals(string2)) {
            jTextComponent.setText(string2);
            jTextComponent.setCaretPosition(n);
        }
    }

    static {
        symbolMap = new Hashtable();
        OWLTextFormatter.updateDisplay(OWLClassDisplayFactory.getDefaultDisplay());
    }

    private static class InsertAction
    extends AbstractAction {
        private char c;
        private JTextComponent textComponent;

        InsertAction(JTextComponent jTextComponent, char c) {
            this.c = c;
            this.textComponent = jTextComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.textComponent.getCaretPosition();
            try {
                this.textComponent.getDocument().insertString(n, "" + this.c, null);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
        }
    }
}

