/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.compact.TokenMgrError;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextFormatter;
import edu.stanford.smi.protegex.owl.ui.code.SymbolPanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class OWLSymbolPanel
extends SymbolPanel {
    private Action allValuesFromAction;
    private Action cardinalityAction;
    private Action complementOfAction;
    private Action enumerationAction;
    private ResourceSelectionAction rdfDatatypeAction;
    private Action falseAction;
    private Action hasValueAction;
    private Action intersectionOfAction;
    private Action maxCardinalityAction;
    private Action minCardinalityAction;
    private Action roundBracketsAction;
    private Action someValuesFromAction;
    private Action trueAction;
    private Action unionOfAction;

    public OWLSymbolPanel(OWLModel oWLModel, boolean bl) {
        this(oWLModel, bl, false);
    }

    public OWLSymbolPanel(OWLModel oWLModel, boolean bl, boolean bl2) {
        super(oWLModel, bl, bl2);
    }

    public void enableActions(Slot slot, Cls cls) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (cls != null && slot != null) {
            String string = cls.getName();
            if (ProfilesManager.isFeatureSupported(this.getOWLModel(), OWLProfiles.Qualified_Cardinality_Restrictions)) {
                string = OWLNames.Cls.ALL_VALUES_FROM_RESTRICTION;
            }
            if (OWLNames.Cls.ALL_VALUES_FROM_RESTRICTION.equals(string) || OWLNames.Cls.SOME_VALUES_FROM_RESTRICTION.equals(string)) {
                if (!(slot instanceof OWLDatatypeProperty)) {
                    bl = true;
                    bl2 = true;
                    bl3 = true;
                }
                bl4 = true;
            } else if (OWLNames.Cls.HAS_VALUE_RESTRICTION.equals(string)) {
                if (slot instanceof OWLDatatypeProperty) {
                    bl3 = true;
                } else {
                    boolean bl5;
                    bl = bl5 = OWLUtil.hasOWLFullProfile(this.getOWLModel());
                    bl3 = bl5;
                    bl4 = bl5;
                    bl2 = true;
                }
            }
        }
        this.enableActions(bl, bl2, bl4, bl3);
    }

    public void enableActions(boolean bl, boolean bl2) {
        super.enableActions(bl, bl2);
        this.enableActions(bl, bl2, true, true);
    }

    public void enableActions(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super.enableActions(bl, bl2);
        OWLModel oWLModel = this.getOWLModel();
        this.allValuesFromAction.setEnabled(bl && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.AllValuesFrom_Restrictions));
        this.cardinalityAction.setEnabled(bl && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.MaxCardinality_Restrictions) && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.MinCardinality_Restrictions));
        this.complementOfAction.setEnabled(bl && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Complement_Classes));
        this.rdfDatatypeAction.setEnabled(bl3);
        this.hasValueAction.setEnabled(bl && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.HasValue_Restrictions));
        this.intersectionOfAction.setEnabled(bl);
        this.maxCardinalityAction.setEnabled(bl && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.MaxCardinality_Restrictions));
        this.minCardinalityAction.setEnabled(bl && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.MinCardinality_Restrictions));
        this.someValuesFromAction.setEnabled(bl && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.SomeValuesFrom_Restrictions));
        this.unionOfAction.setEnabled(bl && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Union_Classes));
        this.roundBracketsAction.setEnabled(bl);
        this.enumerationAction.setEnabled(bl && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Enumerated_Classes));
        this.falseAction.setEnabled(bl4);
        this.trueAction.setEnabled(bl4);
    }

    public String getDisplayErrorMessage(Throwable throwable) {
        String string = null;
        if (throwable instanceof OWLClassParseException) {
            OWLClassParseException oWLClassParseException = (OWLClassParseException)throwable;
            string = oWLClassParseException.getMessage() != null ? oWLClassParseException.getMessage() + " at " : "Invalid symbol after ";
            String string2 = oWLClassParseException.currentToken;
            String string3 = OWLTextFormatter.getDisplayString(string2 == null ? "" : string2);
            string = string + "\"" + string3 + "\"";
        } else if (throwable instanceof TokenMgrError) {
            TokenMgrError tokenMgrError = (TokenMgrError)throwable;
            string = tokenMgrError.getMessage();
        } else if (throwable instanceof NumberFormatException) {
            string = "Please enter a number \u2265 0";
        } else {
            string = throwable.toString();
            Log.getLogger().log(Level.SEVERE, "Exception caught", throwable);
        }
        return string;
    }

    protected void initMiddleBar(JToolBar jToolBar) {
        this.classAction.activateComboBox(this.addButton(jToolBar, this.classAction));
        this.propertyAction.activateComboBox(this.addButton(jToolBar, this.propertyAction));
        this.individiualAction.activateComboBox(this.addButton(jToolBar, this.individiualAction));
        jToolBar.addSeparator();
        this.rdfDatatypeAction = new ResourceSelectionAction("Insert datatype...", OWLIcons.getImageIcon("RDFSDatatype")){

            public Collection getSelectableResources() {
                ArrayList<RDFSDatatype> arrayList = new ArrayList<RDFSDatatype>(OWLSymbolPanel.this.getOWLModel().getRDFSDatatypes());
                arrayList.remove(OWLSymbolPanel.this.getOWLModel().getRDFXMLLiteralType());
                return arrayList;
            }

            public void resourceSelected(RDFResource rDFResource) {
                OWLSymbolPanel.this.insertIndividual(rDFResource);
            }

            public RDFSDatatype pickResource() {
                return ProtegeUI.getSelectionDialogFactory().selectDatatype(OWLSymbolPanel.this, OWLSymbolPanel.this.getOWLModel());
            }
        };
        JButton jButton = this.addButton(jToolBar, this.rdfDatatypeAction);
        this.rdfDatatypeAction.activateComboBox(jButton);
        this.trueAction = this.addAction("true", "True", "true", jToolBar);
        this.falseAction = this.addAction("false", "False", "false", jToolBar);
        jToolBar.addSeparator();
        this.enumerationAction = new AbstractAction("Insert curly brackets for enumerations: { }", OWLIcons.getImageIcon("OWLEnumeratedClass")){

            public void actionPerformed(ActionEvent actionEvent) {
                OWLSymbolPanel.this.getSymbolEditor().insertText("{}", 1);
            }
        };
        this.addButton(jToolBar, this.enumerationAction);
        this.roundBracketsAction = new AbstractAction("Insert round brackets: ( )", OWLIcons.getImageIcon("RoundBrackets")){

            public void actionPerformed(ActionEvent actionEvent) {
                OWLSymbolPanel.this.getSymbolEditor().insertText("()", 1);
            }
        };
        this.addButton(jToolBar, this.roundBracketsAction);
    }

    protected void initTopBar(JToolBar jToolBar) {
        OWLClassDisplay oWLClassDisplay = this.getOWLModel().getOWLClassDisplay();
        this.allValuesFromAction = this.addAction("allValuesFrom", "OWLAllValuesFrom", "" + oWLClassDisplay.getOWLAllValuesFromSymbol() + " ", jToolBar);
        this.someValuesFromAction = this.addAction("someValuesFrom", "OWLSomeValuesFrom", "" + oWLClassDisplay.getOWLSomeValuesFromSymbol() + " ", jToolBar);
        this.hasValueAction = this.addAction("hasValue", "OWLHasValue", " " + oWLClassDisplay.getOWLHasValueSymbol() + " ", jToolBar);
        jToolBar.addSeparator();
        this.cardinalityAction = this.addAction("cardinality", "OWLCardinality", " " + oWLClassDisplay.getOWLCardinalitySymbol() + " ", jToolBar);
        this.minCardinalityAction = this.addAction("minCardinality", "OWLMinCardinality", " " + oWLClassDisplay.getOWLMinCardinalitySymbol() + " ", jToolBar);
        this.maxCardinalityAction = this.addAction("maxCardinality", "OWLMaxCardinality", " " + oWLClassDisplay.getOWLMaxCardinalitySymbol() + " ", jToolBar);
        jToolBar.addSeparator();
        this.intersectionOfAction = this.addAction("intersectionOf", "OWLIntersectionClass", " " + oWLClassDisplay.getOWLIntersectionOfSymbol() + " ", jToolBar);
        this.unionOfAction = this.addAction("unionOf", "OWLUnionClass", " " + oWLClassDisplay.getOWLUnionOfSymbol() + " ", jToolBar);
        this.complementOfAction = this.addAction("complementOf", "OWLComplementClass", "" + oWLClassDisplay.getOWLComplementOfSymbol(), jToolBar);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.enableActions(bl, bl, bl, bl);
    }
}

