/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLResourceNameMatcher
implements ResourceNameMatcher {
    public static final int SCALABLE_FRAME_COUNT = 1000;

    @Override
    public String getInsertString(RDFResource rDFResource) {
        return rDFResource.getBrowserText();
    }

    @Override
    public Set<RDFResource> getMatchingResources(String string, String string2, OWLModel oWLModel) {
        boolean bl = this.couldBeClass(oWLModel, string);
        boolean bl2 = this.couldBeIndividual(oWLModel, string);
        boolean bl3 = this.couldBeProperty(oWLModel, string);
        boolean bl4 = this.couldBeDatatype(oWLModel, string);
        if (string.startsWith("'")) {
            string = string.substring(1);
        }
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        ArrayList<Class<? extends RDFResource>> arrayList = new ArrayList<Class<? extends RDFResource>>();
        if (bl) {
            OWLResourceNameMatcher.addMatchingRDFSNamedClasses(string, hashSet, oWLModel);
            arrayList.add(RDFSNamedClass.class);
        }
        if (bl2) {
            OWLResourceNameMatcher.addMatchingRDFIndividuals(string, hashSet, oWLModel);
            arrayList.add(RDFIndividual.class);
        }
        if (bl3) {
            OWLResourceNameMatcher.addMatchingRDFProperties(string, hashSet, oWLModel);
            arrayList.add(RDFProperty.class);
        }
        if (bl4) {
            OWLResourceNameMatcher.getMatchingDatatypeNames(string, hashSet, oWLModel);
            arrayList.add(RDFSDatatype.class);
        }
        this.removeFilteredElements(hashSet, arrayList);
        return hashSet;
    }

    protected boolean couldBeClass(OWLModel oWLModel, String string) {
        OWLClassParseException oWLClassParseException = OWLClassParseException.getRecentInstance();
        return oWLClassParseException.nextCouldBeClass || oWLModel.getRDFResource(string) instanceof RDFSNamedClass || string.startsWith("'");
    }

    protected boolean couldBeIndividual(OWLModel oWLModel, String string) {
        OWLClassParseException oWLClassParseException = OWLClassParseException.getRecentInstance();
        return oWLClassParseException.nextCouldBeIndividual || oWLModel.getRDFResource(string) != null || string.startsWith("'");
    }

    protected boolean couldBeProperty(OWLModel oWLModel, String string) {
        OWLClassParseException oWLClassParseException = OWLClassParseException.getRecentInstance();
        return oWLClassParseException.nextCouldBeProperty || oWLModel.getRDFResource(string) instanceof RDFProperty || string.startsWith("'");
    }

    protected boolean couldBeDatatype(OWLModel oWLModel, String string) {
        OWLClassParseException oWLClassParseException = OWLClassParseException.getRecentInstance();
        return oWLClassParseException.nextCouldBeDatatypeName || oWLModel.getRDFResource(string) instanceof RDFSDatatype;
    }

    public static void addMatchingRDFSNamedClasses(String string, Set<RDFResource> set, OWLModel oWLModel) {
        if (string.length() == 0) {
            int n = oWLModel.getRDFSClassCount();
            if (n < 1000) {
                for (RDFSNamedClass rDFSNamedClass : OWLUtil.getSelectableNamedClses(oWLModel)) {
                    if (!rDFSNamedClass.isVisibleFromOWLThing()) continue;
                    set.add(rDFSNamedClass);
                }
            }
        } else {
            ArrayList<Slot> arrayList = new ArrayList<Slot>();
            OWLResourceNameMatcher.addMatchingFrames(oWLModel, set, oWLModel.getRDFSNamedClassClass(), string, arrayList);
            OWLResourceNameMatcher.addMatchingFrames(oWLModel, set, oWLModel.getOWLNamedClassClass(), string, arrayList);
        }
    }

    public static void addMatchingRDFProperties(String string, Set<RDFResource> set, OWLModel oWLModel) {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        OWLResourceNameMatcher.addMatchingFrames(oWLModel, set, oWLModel.getRDFPropertyClass(), string, arrayList);
        OWLResourceNameMatcher.addMatchingFrames(oWLModel, set, oWLModel.getOWLDatatypePropertyClass(), string, arrayList);
        OWLResourceNameMatcher.addMatchingFrames(oWLModel, set, oWLModel.getOWLObjectPropertyClass(), string, arrayList);
    }

    public static void addMatchingRDFIndividuals(String string, Set<RDFResource> set, OWLModel oWLModel) {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        OWLResourceNameMatcher.addMatchingFrames(oWLModel, set, oWLModel.getOWLThingClass(), string, arrayList);
    }

    public static void getMatchingDatatypeNames(String string, Set<RDFResource> set, OWLModel oWLModel) {
        Collection<RDFSDatatype> collection = oWLModel.getRDFSDatatypes();
        for (RDFSDatatype rDFSDatatype : collection) {
            if (rDFSDatatype.isAnonymous() || !rDFSDatatype.getBrowserText().startsWith(string)) continue;
            set.add(rDFSDatatype);
        }
    }

    private static void addMatchingFrames(OWLModel oWLModel, Collection<RDFResource> collection, Cls cls, String string, Collection<Slot> collection2) {
        Slot slot = OWLResourceNameMatcher.getBrowserSlotForType(cls);
        if (!collection2.contains(slot)) {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            if (oWLModel.getNameSlot().equals(slot) && (string2 = NamespaceUtil.getFullName(oWLModel, string)) != null) {
                arrayList.add(string2);
            }
            if ((string2 = oWLModel.getDefaultLanguage()) != null && slot instanceof RDFProperty && ((RDFProperty)slot).isAnnotationProperty()) {
                arrayList.add("~#" + string2 + ' ' + string);
            }
            for (String string3 : arrayList) {
                Collection collection3 = oWLModel.getMatchingFrames(slot, null, false, string3 + "*", 1000);
                for (Frame frame : collection3) {
                    if (!(frame instanceof RDFResource)) continue;
                    collection.add((RDFResource)frame);
                }
            }
            collection2.add(slot);
        }
    }

    @Override
    public boolean isIdChar(char c) {
        return SymbolTextField.isIdChar(c);
    }

    private static Slot getBrowserSlotForType(Cls cls) {
        BrowserSlotPattern browserSlotPattern = cls.getBrowserSlotPattern();
        List list = browserSlotPattern.getSlots();
        if (list.size() == 1) {
            return (Slot)list.get(0);
        }
        return cls.getKnowledgeBase().getSystemFrames().getNameSlot();
    }

    protected void removeFilteredElements(Set<RDFResource> set, List<Class<? extends RDFResource>> list) {
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        for (RDFResource rDFResource : set) {
            boolean bl = true;
            if (!this.isFilteredOutResource(rDFResource)) {
                for (Class<? extends RDFResource> clazz : list) {
                    if (!clazz.isAssignableFrom(rDFResource.getClass()) || !OWLResourceNameMatcher.isVisible((Frame)rDFResource)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            hashSet.add(rDFResource);
        }
        set.removeAll(hashSet);
    }

    protected boolean isFilteredOutResource(RDFResource rDFResource) {
        return rDFResource.isAnonymous() || SWRLFactory.isSWRLFilteredResource(rDFResource);
    }

    protected static boolean isVisible(Frame frame) {
        if (frame instanceof RDFSNamedClass) {
            return frame.isVisible() && (OWLResourceNameMatcher.isSlowProject(frame.getKnowledgeBase()) || ((RDFSNamedClass)frame).isVisibleFromOWLThing());
        }
        return frame.isVisible();
    }

    private static boolean isSlowProject(KnowledgeBase knowledgeBase) {
        return knowledgeBase.getProject().isMultiUserClient();
    }
}

