/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.ui.code.OWLResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceIgnoreCaseComparator;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;

public class ExpansionKeyListener
extends KeyAdapter {
    private JTextComponent textComponent;
    private OWLModel owlModel;
    private OWLResourceNameMatcher resourceNameMatcher = new OWLResourceNameMatcher();

    public ExpansionKeyListener(JTextComponent jTextComponent, OWLModel oWLModel) {
        this.textComponent = jTextComponent;
        this.owlModel = oWLModel;
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            this.owlModel.getOWLClassDisplay().getParser().checkClass(this.owlModel, this.textComponent.getText());
        }
        catch (OWLClassParseException oWLClassParseException) {
            Log.emptyCatchBlock((Throwable)oWLClassParseException);
        }
        if (this.isExpansionEvent(keyEvent)) {
            this.handleExpansion();
            keyEvent.consume();
        }
    }

    protected boolean isExpansionEvent(KeyEvent keyEvent) {
        return keyEvent.getKeyChar() == ' ' && (keyEvent.getModifiers() & 2) != 0;
    }

    private void handleExpansion() {
        String string = this.textComponent.getText();
        Set<RDFResource> set = this.resourceNameMatcher.getMatchingResources(string, "", this.owlModel);
        this.textComponent.removeAll();
        if (!set.isEmpty()) {
            Frame[] frameArray = set.toArray(new Frame[0]);
            Arrays.sort(frameArray, new ResourceIgnoreCaseComparator());
            final JComboBox<Frame> jComboBox = new JComboBox<Frame>(frameArray);
            jComboBox.setBackground(Color.white);
            jComboBox.setRenderer((ListCellRenderer<Frame>)new FrameRenderer());
            jComboBox.setSize(jComboBox.getPreferredSize().width + 20, 0);
            jComboBox.setLocation(this.textComponent.getX(), this.textComponent.getHeight());
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (((long)actionEvent.getModifiers() & 0x10L) != 0L) {
                        ExpansionKeyListener.this.replacetText((RDFResource)jComboBox.getSelectedItem());
                    }
                }
            });
            jComboBox.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        ExpansionKeyListener.this.replacetText((RDFResource)jComboBox.getSelectedItem());
                        jComboBox.setVisible(false);
                        ExpansionKeyListener.this.textComponent.remove(jComboBox);
                    }
                }
            });
            this.textComponent.add(jComboBox);
            jComboBox.showPopup();
            jComboBox.requestFocus();
        }
    }

    protected void replacetText(RDFResource rDFResource) {
        this.textComponent.setText(this.resourceNameMatcher.getInsertString(rDFResource));
        this.textComponent.requestFocusInWindow();
    }
}

