/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsproperties.OldRestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTree;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import edu.stanford.smi.protegex.owl.util.ExpressionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTreeNode
extends DefaultMutableTreeNode
implements Comparable,
Disposable {
    private OWLNamedClass cls;
    private boolean inherited;
    private PropertyRestrictionsTree tree;
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            PropertyTreeNode.this.tree.refillLater();
        }
    };

    public PropertyTreeNode(PropertyRestrictionsTree propertyRestrictionsTree, OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, boolean bl) {
        this.setUserObject(rDFProperty);
        this.inherited = bl;
        this.cls = oWLNamedClass;
        this.tree = propertyRestrictionsTree;
        rDFProperty.addPropertyValueListener(this.valueListener);
    }

    public PropertyTreeNode(PropertyRestrictionsTree propertyRestrictionsTree, OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, boolean bl, List<ExpressionInfo<OWLRestriction>> list) {
        this.setUserObject(rDFProperty);
        this.inherited = bl;
        this.cls = oWLNamedClass;
        this.tree = propertyRestrictionsTree;
        this.addChildNodes(list);
        rDFProperty.addPropertyValueListener(this.valueListener);
    }

    private void addChildNodes() {
        List<ExpressionInfo<OWLRestriction>> list = this.getRestrictions();
        this.addChildNodes(list);
    }

    private void addChildNodes(List<ExpressionInfo<OWLRestriction>> list) {
        for (ExpressionInfo<OWLRestriction> expressionInfo : list) {
            OWLRestriction oWLRestriction = expressionInfo.getExpression();
            OWLNamedClass oWLNamedClass = expressionInfo.getDirectNamedClass();
            if (this.cls.equals(oWLNamedClass)) {
                oWLNamedClass = null;
            }
            OldRestrictionTreeNode oldRestrictionTreeNode = new OldRestrictionTreeNode(this.tree, oWLRestriction, oWLNamedClass);
            this.add(oldRestrictionTreeNode);
        }
    }

    public int compareTo(Object object) {
        PropertyTreeNode propertyTreeNode = (PropertyTreeNode)object;
        if (!this.isInherited()) {
            if (propertyTreeNode.isInherited()) {
                return -1;
            }
        } else {
            if (!propertyTreeNode.isInherited()) {
                return 1;
            }
            if (this.getChildCount() > 0) {
                if (propertyTreeNode.getChildCount() == 0) {
                    return -1;
                }
            } else if (propertyTreeNode.getChildCount() > 0) {
                return 1;
            }
        }
        return this.getRDFProperty().compareTo(propertyTreeNode.getRDFProperty());
    }

    public void dispose() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getRestrictionTreeNode(i).dispose();
        }
        this.getRDFProperty().removePropertyValueListener(this.valueListener);
    }

    private List<ExpressionInfo<OWLRestriction>> getRestrictions() {
        ArrayList<ExpressionInfo<OWLRestriction>> arrayList = new ArrayList<ExpressionInfo<OWLRestriction>>();
        ArrayList<OWLNamedClass> arrayList2 = new ArrayList<OWLNamedClass>();
        arrayList2.add(this.cls);
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
        HashSet hashSet2 = new HashSet();
        boolean bl = true;
        while (!arrayList2.isEmpty()) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)arrayList2.get(0);
            hashSet.add(oWLNamedClass);
            arrayList2.remove(0);
            for (RDFSClass rDFSClass : oWLNamedClass.getSuperclasses(false)) {
                Object object;
                if (rDFSClass instanceof OWLRestriction) {
                    object = new ExpressionInfo<OWLRestriction>((OWLRestriction)rDFSClass, (OWLAnonymousClass)rDFSClass, oWLNamedClass);
                    this.perhapsAddRestriction((ExpressionInfo<OWLRestriction>)object, arrayList, hashSet2);
                    continue;
                }
                if (rDFSClass instanceof OWLIntersectionClass) {
                    object = (OWLIntersectionClass)rDFSClass;
                    for (RDFSClass rDFSClass2 : object.getOperands()) {
                        if (!(rDFSClass2 instanceof OWLRestriction)) continue;
                        ExpressionInfo<OWLRestriction> expressionInfo = new ExpressionInfo<OWLRestriction>((OWLRestriction)rDFSClass2, (OWLAnonymousClass)object, oWLNamedClass);
                        this.perhapsAddRestriction(expressionInfo, arrayList, hashSet2);
                    }
                    continue;
                }
                if (!(rDFSClass instanceof OWLNamedClass) || hashSet.contains(rDFSClass)) continue;
                arrayList2.add((OWLNamedClass)rDFSClass);
            }
            if (!bl) continue;
            Collections.sort(arrayList, new Comparator<ExpressionInfo<OWLRestriction>>(){

                @Override
                public int compare(ExpressionInfo<OWLRestriction> expressionInfo, ExpressionInfo<OWLRestriction> expressionInfo2) {
                    RDFSClass rDFSClass = expressionInfo.getExpression().getProtegeType();
                    RDFSClass rDFSClass2 = expressionInfo2.getExpression().getProtegeType();
                    return rDFSClass.getName().compareTo(rDFSClass2.getName());
                }
            });
            bl = false;
        }
        this.removeOverloadedAllRestrictions(arrayList);
        return arrayList;
    }

    public Icon getIcon() {
        RDFProperty rDFProperty = this.getRDFProperty();
        if (this.isInherited()) {
            return rDFProperty.getInheritedIcon();
        }
        return ProtegeUI.getIcon(rDFProperty);
    }

    public RDFProperty getRDFProperty() {
        return (RDFProperty)this.getUserObject();
    }

    public OWLNamedClass getRestrictedClass() {
        return this.cls;
    }

    public RestrictionTreeNode getRestrictionTreeNode(int n) {
        return (RestrictionTreeNode)this.getChildAt(n);
    }

    public OldRestrictionTreeNode getRestrictionTreeNode(OWLRestriction oWLRestriction) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            OldRestrictionTreeNode oldRestrictionTreeNode = (OldRestrictionTreeNode)this.getChildAt(i);
            if (!oldRestrictionTreeNode.getRestriction().equals(oWLRestriction)) continue;
            return oldRestrictionTreeNode;
        }
        return null;
    }

    public OldRestrictionTreeNode getRestrictionTreeNode(String string) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            OldRestrictionTreeNode oldRestrictionTreeNode;
            TreeNode treeNode = this.getChildAt(i);
            if (!(treeNode instanceof OldRestrictionTreeNode) || !(oldRestrictionTreeNode = (OldRestrictionTreeNode)treeNode).getRestriction().getBrowserText().equals(string)) continue;
            return oldRestrictionTreeNode;
        }
        return null;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasRestrictionOfType(Cls cls) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!cls.equals(this.getRestrictionTreeNode(i).getRestrictionMetaCls())) continue;
            return true;
        }
        return false;
    }

    private void perhapsAddRestriction(ExpressionInfo<OWLRestriction> expressionInfo, List<ExpressionInfo<OWLRestriction>> list, Set set) {
        ExpressionInfo<OWLRestriction> expressionInfo2;
        OWLRestriction oWLRestriction = expressionInfo.getExpression();
        String string = expressionInfo.getExpression().getBrowserText();
        Object object = list.iterator();
        while (object.hasNext()) {
            expressionInfo2 = object.next();
            OWLRestriction oWLRestriction2 = expressionInfo2.getExpression();
            if (!string.equals(oWLRestriction2.getBrowserText())) continue;
            return;
        }
        if (oWLRestriction instanceof OWLSomeValuesFrom && (object = (OWLSomeValuesFrom)oWLRestriction).getSomeValuesFrom() instanceof RDFSNamedClass) {
            expressionInfo2 = (RDFSNamedClass)object.getSomeValuesFrom();
            for (ExpressionInfo expressionInfo3 : list) {
                RDFSNamedClass rDFSNamedClass;
                OWLSomeValuesFrom oWLSomeValuesFrom;
                OWLRestriction oWLRestriction3 = (OWLRestriction)expressionInfo3.getExpression();
                if (!(oWLRestriction3 instanceof OWLSomeValuesFrom) || !((oWLSomeValuesFrom = (OWLSomeValuesFrom)oWLRestriction3).getSomeValuesFrom() instanceof RDFSNamedClass) || !(rDFSNamedClass = (RDFSNamedClass)oWLSomeValuesFrom.getSomeValuesFrom()).getSuperclasses(true).contains(expressionInfo2)) continue;
                return;
            }
        }
        if (this.getRDFProperty().equals(oWLRestriction.getOnProperty())) {
            boolean bl = false;
            if (oWLRestriction instanceof OWLCardinalityBase) {
                expressionInfo2 = (OWLCardinalityBase)oWLRestriction;
                bl = expressionInfo2.isQualified();
            }
            if (bl) {
                list.add(expressionInfo);
            } else if (!set.contains(oWLRestriction.getProtegeType())) {
                if (oWLRestriction instanceof OWLCardinalityBase) {
                    set.add(oWLRestriction.getProtegeType());
                }
                list.add(expressionInfo);
            }
        }
    }

    private void removeOverloadedAllRestrictions(List<ExpressionInfo<OWLRestriction>> list) {
        boolean bl = false;
        do {
            for (int i = 0; i < list.size(); ++i) {
                ExpressionInfo<OWLRestriction> expressionInfo = list.get(i);
                OWLRestriction oWLRestriction = expressionInfo.getExpression();
                if (!(oWLRestriction instanceof OWLAllValuesFrom) || !(((OWLAllValuesFrom)oWLRestriction).getFiller() instanceof RDFSClass)) continue;
                this.removeOverloadedAllRestrictions(list, i);
            }
        } while (bl);
    }

    private boolean removeOverloadedAllRestrictions(List<ExpressionInfo<OWLRestriction>> list, int n) {
        boolean bl = false;
        OWLAllValuesFrom oWLAllValuesFrom = (OWLAllValuesFrom)list.get(n).getExpression();
        RDFSClass rDFSClass = (RDFSClass)oWLAllValuesFrom.getFiller();
        OWLNamedClass oWLNamedClass = oWLAllValuesFrom.getOwner();
        for (int i = n + 1; i < list.size(); ++i) {
            ExpressionInfo<OWLRestriction> expressionInfo = list.get(i);
            OWLRestriction oWLRestriction = expressionInfo.getExpression();
            if (!(oWLRestriction instanceof OWLAllValuesFrom) || !oWLRestriction.getOnProperty().equals(oWLAllValuesFrom.getOnProperty())) continue;
            OWLAllValuesFrom oWLAllValuesFrom2 = (OWLAllValuesFrom)oWLRestriction;
            RDFSClass rDFSClass2 = (RDFSClass)oWLAllValuesFrom2.getFiller();
            OWLNamedClass oWLNamedClass2 = oWLAllValuesFrom2.getOwner();
            if (!(oWLAllValuesFrom2.getFiller() instanceof RDFSClass) || !rDFSClass.isSubclassOf(rDFSClass2) || oWLNamedClass2.equals(oWLNamedClass)) continue;
            list.remove(i);
            bl = true;
        }
        return bl;
    }
}

