/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.OWLRemoveAction;
import edu.stanford.smi.protegex.owl.ui.clsproperties.AddPropertyAction;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTree;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PropertyRestrictionsTreeWidget
extends AbstractPropertyWidget {
    private static final long serialVersionUID = 7648920625842859833L;
    private ResourceSelectionAction addPropertyAction = new AddPropertyAction(this);
    private Action createDatatypePropertyAction = new AbstractAction("Create datatype property", OWLIcons.getCreatePropertyIcon("OWLDatatypeProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyRestrictionsTreeWidget.this.createProperty(PropertyRestrictionsTreeWidget.this.getOWLModel().getOWLDatatypePropertyClass());
        }
    };
    private Action createObjectPropertyAction = new AbstractAction("Create object property", OWLIcons.getCreatePropertyIcon("OWLObjectProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyRestrictionsTreeWidget.this.createProperty(PropertyRestrictionsTreeWidget.this.getOWLModel().getOWLObjectPropertyClass());
        }
    };
    private Action createRDFPropertyAction = new AbstractAction("Create RDF property", OWLIcons.getCreatePropertyIcon("RDFProperty")){

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyRestrictionsTreeWidget.this.createProperty(PropertyRestrictionsTreeWidget.this.getOWLModel().getRDFPropertyClass());
        }
    };
    private static final String HIDE_GLOBAL_CHARACTERISTICS = "HideGlobalCharacteristics";
    private static final String DISPLAY_RESTRICTIONS = "DisplayRestrictions";
    private AllowableAction removeAction;
    public static final String LABEL = "Label";
    private PropertyRestrictionsTree tree;

    private void createProperty(RDFSNamedClass rDFSNamedClass) {
        Object object;
        RDFSClass rDFSClass = (RDFSClass)this.getEditedResource();
        if (rDFSNamedClass.isAbstract()) {
            object = ((RDFSNamedClass)rDFSClass.getProtegeType()).getUnionRangeClasses(this.getRDFProperty());
            rDFSNamedClass = ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this), this.getOWLModel(), (Collection)object);
        }
        if (rDFSNamedClass != null && (object = this.createProperty(rDFSNamedClass, rDFSClass)) != null) {
            this.viewProperty((RDFProperty)object);
        }
    }

    private RDFProperty createProperty(RDFSNamedClass rDFSNamedClass, RDFSClass rDFSClass) {
        RDFProperty rDFProperty = null;
        try {
            this.beginTransaction("Create new " + rDFSNamedClass.getBrowserText());
            String string = rDFSNamedClass.getName();
            int n = string.lastIndexOf(":");
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            String string2 = ((AbstractOWLModel)this.getKnowledgeBase()).createNewResourceName(string);
            rDFProperty = (RDFProperty)rDFSNamedClass.createInstance(string2);
            rDFProperty.setDomainDefined(true);
            rDFProperty.addUnionDomainClass(rDFSClass);
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            OWLUI.handleError(this.getOWLModel(), exception);
        }
        return rDFProperty;
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        return new MyWidgetConfigurationPanel();
    }

    private boolean getHideGlobalCharacteristics() {
        Boolean bl = this.getPropertyList().getBoolean(HIDE_GLOBAL_CHARACTERISTICS);
        return bl == null ? false : bl;
    }

    public boolean getDisplayRestrictions() {
        Boolean bl = this.getPropertyList().getBoolean(DISPLAY_RESTRICTIONS);
        return bl == null ? false : bl;
    }

    public String getLabel() {
        return this.getDisplayRestrictions() ? "Properties and Restrictions" : "Properties";
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Collection getSelection() {
        return this.tree.getSelection();
    }

    public void initialize() {
        final OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        this.tree = new PropertyRestrictionsTree(oWLModel, null);
        this.removeAction = new OWLRemoveAction("Remove this class from the domain of the selected property", OWLIcons.getRemoveIcon("RDFProperty"), (Selectable)this.tree){

            public void onRemove(Collection collection) {
                for (Object e : collection) {
                    if (!(e instanceof RDFProperty)) continue;
                    this.onRemove(e);
                }
            }

            public void onRemove(Object object) {
                RDFProperty rDFProperty = (RDFProperty)object;
                RDFSClass rDFSClass = (RDFSClass)PropertyRestrictionsTreeWidget.this.getEditedResource();
                try {
                    oWLModel.beginTransaction("Remove " + rDFSClass.getBrowserText() + " from the domain of " + rDFProperty.getBrowserText(), rDFProperty.getName());
                    rDFProperty.removeUnionDomainClass(rDFSClass);
                    oWLModel.commitTransaction();
                }
                catch (Exception exception) {
                    oWLModel.rollbackTransaction();
                    OWLUI.handleError(oWLModel, exception);
                }
            }

            public void onSelectionChange() {
                Collection collection = this.getSelection();
                boolean bl = false;
                for (Object e : collection) {
                    if (!(e instanceof RDFProperty)) continue;
                    RDFProperty rDFProperty = (RDFProperty)e;
                    RDFSClass rDFSClass = (RDFSClass)PropertyRestrictionsTreeWidget.this.getEditedResource();
                    if (rDFProperty.isEditable() && rDFProperty.getUnionDomain().contains(rDFSClass)) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    break;
                }
                this.setAllowed(bl);
            }
        };
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.tree));
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent(this.getLabel(), jScrollPane, true, true);
        oWLLabeledComponent.setHeaderIcon(OWLIcons.getPropertiesIcon());
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.CreateRDFProperty)) {
            oWLLabeledComponent.addHeaderButton(this.createRDFPropertyAction);
        }
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Create_DatatypeProperty)) {
            oWLLabeledComponent.addHeaderButton(this.createDatatypePropertyAction);
        }
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Create_ObjectProperty)) {
            oWLLabeledComponent.addHeaderButton(this.createObjectPropertyAction);
        }
        oWLLabeledComponent.addHeaderButton(this.addPropertyAction);
        oWLLabeledComponent.addHeaderButton((Action)this.removeAction);
        oWLLabeledComponent.addHeaderSeparator();
        oWLLabeledComponent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PropertyRestrictionsTreeWidget.this.setHideGlobalCharacteristics(!PropertyRestrictionsTreeWidget.this.getHideGlobalCharacteristics());
                }
            }
        });
        JButton jButton = oWLLabeledComponent.addHeaderButton(this.tree.getCreateRestrictionAction());
        jButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (PropertyRestrictionsTreeWidget.this.tree.getSelectedInstance() != null && SwingUtilities.isRightMouseButton(mouseEvent) && PropertyRestrictionsTreeWidget.this.isEnabled()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    PropertyRestrictionsTreeWidget.this.tree.addCreateRestrictionActions(jPopupMenu);
                    Component component = (Component)mouseEvent.getSource();
                    jPopupMenu.show(component, mouseEvent.getX(), component.getHeight());
                }
            }
        });
        oWLLabeledComponent.addHeaderButton(this.tree.getDeleteRestrictionAction());
        this.tree.init(this.getDisplayRestrictions(), this.getHideGlobalCharacteristics());
        this.add((Component)((Object)oWLLabeledComponent));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals(":DIRECT-TEMPLATE-SLOTS");
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.tree.isEditing()) {
            this.tree.cancelEditing();
        }
    }

    private void setHideGlobalCharacteristics(boolean bl) {
        if (bl != this.getHideGlobalCharacteristics()) {
            if (bl) {
                this.getPropertyList().setBoolean(HIDE_GLOBAL_CHARACTERISTICS, true);
            } else {
                this.getPropertyList().remove(HIDE_GLOBAL_CHARACTERISTICS);
            }
            this.updateTreeDisplayRestrictions();
        }
    }

    public void setDisplayRestrictions(boolean bl) {
        if (bl != this.getDisplayRestrictions()) {
            if (bl) {
                this.getPropertyList().setBoolean(DISPLAY_RESTRICTIONS, true);
            } else {
                this.getPropertyList().remove(DISPLAY_RESTRICTIONS);
            }
            this.updateTreeDisplayRestrictions();
        }
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        if (instance instanceof OWLNamedClass) {
            this.tree.setCls((OWLNamedClass)instance);
            this.tree.openNodesIfPossible();
            boolean bl = instance.equals(this.getOWLModel().getOWLThingClass());
            this.createDatatypePropertyAction.setEnabled(!bl);
            this.createObjectPropertyAction.setEnabled(!bl);
            this.createRDFPropertyAction.setEnabled(!bl);
            this.addPropertyAction.setEnabled(!bl);
            this.tree.getCreateRestrictionAction().setEnabled(!bl);
        } else {
            this.tree.setCls(null);
        }
    }

    private void updateTreeDisplayRestrictions() {
        this.tree.init(this.getDisplayRestrictions(), this.getHideGlobalCharacteristics());
    }

    protected void viewProperty(RDFProperty rDFProperty) {
        rDFProperty.getProject().show((Instance)rDFProperty);
    }

    private class MyWidgetConfigurationPanel
    extends WidgetConfigurationPanel {
        private JCheckBox displayRestrictionsCheckBox;
        private JTextField labelTextField;

        MyWidgetConfigurationPanel() {
            super((SlotWidget)PropertyRestrictionsTreeWidget.this);
        }

        public void addGeneralTab(SlotWidget slotWidget) {
            this.labelTextField = new JTextField(PropertyRestrictionsTreeWidget.this.getLabel());
            this.displayRestrictionsCheckBox = new JCheckBox("Display restrictions behind property name");
            this.displayRestrictionsCheckBox.setSelected(PropertyRestrictionsTreeWidget.this.getDisplayRestrictions());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.displayRestrictionsCheckBox);
            jPanel.add((Component)new LabeledComponent(PropertyRestrictionsTreeWidget.LABEL, (Component)this.labelTextField));
            this.addTab("General", jPanel);
        }

        public void saveContents() {
            PropertyRestrictionsTreeWidget.this.getPropertyList().setString(PropertyRestrictionsTreeWidget.LABEL, this.labelTextField.getText());
            boolean bl = this.displayRestrictionsCheckBox.isSelected();
            PropertyRestrictionsTreeWidget.this.setDisplayRestrictions(bl);
            PropertyRestrictionsTreeWidget.this.updateTreeDisplayRestrictions();
        }
    }
}

