/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class CreatePropertyAction
extends AbstractAction {
    private String baseName;
    private CallBack callBack;
    private RDFSNamedClass type;

    public CreatePropertyAction(RDFSNamedClass rDFSNamedClass, String string, String string2, CallBack callBack) {
        super("Create " + rDFSNamedClass.getName() + "...", OWLIcons.getCreateIcon(string2));
        this.baseName = string;
        this.callBack = callBack;
        this.type = rDFSNamedClass;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLModel oWLModel = this.type.getOWLModel();
        String string = this.type.getOWLModel().createNewResourceName(this.baseName);
        try {
            oWLModel.beginTransaction("Create new " + this.type.getBrowserText(), string);
            RDFProperty rDFProperty = (RDFProperty)this.type.createInstance(string);
            this.callBack.propertyCreated(rDFProperty);
            rDFProperty.getProject().show((Instance)rDFProperty);
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
    }

    public static void addActions(LabeledComponent labeledComponent, OWLModel oWLModel, CallBack callBack) {
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Create_ObjectProperty)) {
            labeledComponent.addHeaderButton((Action)new CreatePropertyAction(oWLModel.getOWLObjectPropertyClass(), "objectProperty", "OWLObjectProperty", callBack));
        }
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Create_DatatypeProperty)) {
            labeledComponent.addHeaderButton((Action)new CreatePropertyAction(oWLModel.getOWLDatatypePropertyClass(), "datatypeProperty", "OWLDatatypeProperty", callBack));
        }
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.RDF) || ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.RDF_but_not_OWL)) {
            labeledComponent.addHeaderButton((Action)new CreatePropertyAction(oWLModel.getRDFPropertyClass(), "property", "RDFProperty", callBack));
        }
    }

    public static interface CallBack {
        public void propertyCreated(RDFProperty var1);
    }
}

