/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc.manchester;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.ParserUtils;
import edu.stanford.smi.protegex.owl.ui.clsdesc.manchester.SuggestionFactory;
import edu.stanford.smi.protegex.owl.ui.clsdesc.manchester.SuggestionList;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SuggestionPopup
extends JWindow {
    private DocumentListener documentListener;
    private MouseListener mouseListener;
    private MouseListener textComponentMouseListener;
    private ComponentListener componentListener;
    private HierarchyListener hierarchyListener;
    private Timer timer;
    private OWLModel model;
    private ImageIcon icon;
    private JPanel iconPanel;
    private Collection suggestions;
    private SuggestionList suggestionList;
    private JTextComponent textComponent;
    private KeyListener keyListener;

    public SuggestionPopup(Window window, OWLModel oWLModel) {
        super(window);
        this.setFocusableWindowState(false);
        this.model = oWLModel;
        this.icon = OWLIcons.getDownIcon();
        this.iconPanel = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                SuggestionPopup.this.icon.paintIcon(SuggestionPopup.this.iconPanel, graphics, 0, 0);
            }
        };
        if (System.getProperty("os.name").indexOf("Mac") != -1) {
            this.iconPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        } else {
            this.iconPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.iconPanel);
        this.suggestionList = new SuggestionList(this);
        this.suggestionList.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SuggestionPopup.this.reset();
            }
        });
        this.setSize(this.icon.getIconWidth(), this.icon.getIconHeight());
        this.timer = new Timer(1500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuggestionPopup.this.timer.stop();
                SuggestionPopup.this.parse();
            }
        });
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SuggestionPopup.this.timer.restart();
                SuggestionPopup.this.reset();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SuggestionPopup.this.timer.restart();
                SuggestionPopup.this.reset();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.hierarchyListener = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (SuggestionPopup.this.isVisible() && !SuggestionPopup.this.textComponent.isShowing()) {
                    SuggestionPopup.this.reset();
                }
            }
        };
        this.mouseListener = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                SuggestionPopup.this.showOptions();
            }
        };
        this.textComponentMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SuggestionPopup.this.isVisible()) {
                    SuggestionPopup.this.reset();
                }
            }
        };
        this.iconPanel.addMouseListener(this.mouseListener);
        this.componentListener = new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                SuggestionPopup.this.reset();
            }
        };
        window.addComponentListener(this.componentListener);
        this.keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (SuggestionPopup.this.isVisible() && keyEvent.getKeyCode() == 27) {
                    SuggestionPopup.this.reset();
                }
            }
        };
    }

    public void setCurrentEditorPane(JTextComponent jTextComponent) {
        this.removeListeners();
        this.textComponent = jTextComponent;
        this.addListeners();
    }

    private void removeListeners() {
        if (this.textComponent != null) {
            this.textComponent.getDocument().removeDocumentListener(this.documentListener);
            this.textComponent.removeKeyListener(this.keyListener);
            this.textComponent.removeHierarchyListener(this.hierarchyListener);
            this.textComponent.removeMouseListener(this.textComponentMouseListener);
        }
    }

    private void addListeners() {
        if (this.textComponent != null) {
            this.textComponent.getDocument().addDocumentListener(this.documentListener);
            this.textComponent.addKeyListener(this.keyListener);
            this.textComponent.addHierarchyListener(this.hierarchyListener);
            this.textComponent.addMouseListener(this.textComponentMouseListener);
        }
    }

    public void paintComponents(Graphics graphics) {
        super.paintComponents(graphics);
        this.icon.paintIcon(this, graphics, 0, 0);
    }

    private void offerSuggestions(OWLClassParseException oWLClassParseException) {
        try {
            String string = oWLClassParseException.currentToken;
            if (string != null && this.model.getRDFResource(string) == null && this.model.isValidResourceName(string, this.model.getOWLThingClass())) {
                this.suggestions = SuggestionFactory.getSuggestions(this.model, oWLClassParseException);
                if (this.suggestions.size() > 0 && !string.equals("")) {
                    int n = this.textComponent.getCaretPosition();
                    Rectangle rectangle = this.textComponent.modelToView(n);
                    Point point = rectangle.getLocation();
                    point.x = 0 - this.icon.getIconWidth() - 1;
                    SwingUtilities.convertPointToScreen(point, this.textComponent);
                    this.setLocation(point);
                    this.setVisible(true);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
        }
    }

    public void reset() {
        this.setVisible(false);
        this.setSize(this.icon.getIconWidth(), this.icon.getIconHeight());
        this.getContentPane().remove(this.suggestionList);
        this.getContentPane().add(this.iconPanel);
    }

    private void parse() {
        if (this.textComponent != null) {
            String string = this.textComponent.getText();
            try {
                this.model.getOWLClassDisplay().getParser().checkClass(this.model, string);
                this.reset();
            }
            catch (OWLClassParseException oWLClassParseException) {
                this.offerSuggestions(oWLClassParseException);
            }
            catch (Error error) {
                if (ParserUtils.isLexError(error)) {
                    Log.emptyCatchBlock((Throwable)error);
                }
                throw error;
            }
        }
    }

    public void updateCurrentEditorPane() {
        if (this.textComponent != null) {
            this.textComponent.setText(this.textComponent.getText());
        }
    }

    private void showOptions() {
        if (this.isVisible() && this.suggestions.size() > 0) {
            this.suggestionList.setListData(this.suggestions.toArray());
            this.getContentPane().remove(this.iconPanel);
            this.getContentPane().add(this.suggestionList);
            this.pack();
        }
    }
}

