/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc.manchester;

import edu.stanford.smi.protegex.owl.ui.clsdesc.manchester.Suggestion;
import edu.stanford.smi.protegex.owl.ui.clsdesc.manchester.SuggestionPopup;
import edu.stanford.smi.protegex.owl.ui.clsdesc.manchester.SuggestionRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JList;

public class SuggestionList
extends JList {
    private MouseListener mouseListener;
    private SuggestionPopup popup;

    public SuggestionList(SuggestionPopup suggestionPopup) {
        this.popup = suggestionPopup;
        this.mouseListener = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SuggestionList.this.performSelectedSuggestion();
                }
            }
        };
        if (System.getProperty("os.name").indexOf("Mac") != -1) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }
        this.addMouseListener(this.mouseListener);
        this.setCellRenderer(new SuggestionRenderer());
    }

    private void performSelectedSuggestion() {
        Suggestion suggestion = (Suggestion)this.getSelectedValue();
        if (suggestion != null) {
            suggestion.performSuggestion();
            this.popup.updateCurrentEditorPane();
            this.popup.reset();
        }
    }
}

