/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;

class RemoveRowAction
extends AbstractOWLTableAction {
    private ClassDescriptionTable table;

    RemoveRowAction(ClassDescriptionTable classDescriptionTable) {
        super("Remove selected class from list", OWLIcons.getRemoveIcon("PrimitiveClass"));
        this.table = classDescriptionTable;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab((Component)((Object)this.table));
        int[] nArray = this.table.getSelectedRows();
        Arrays.sort(nArray);
        OWLNamedClass oWLNamedClass = this.table.getEditedCls();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            OWLTableModel oWLTableModel = (OWLTableModel)this.table.getModel();
            RDFSClass rDFSClass = oWLTableModel.getClass(n);
            if (!oWLTableModel.isCellEditable(n, oWLTableModel.getSymbolColumnIndex()) && !rDFSClass.equals(rDFSClass.getKnowledgeBase().getRootCls())) continue;
            oWLTableModel.deleteRow(n);
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
        if (oWLClassesTab != null) {
            oWLClassesTab.ensureClsSelected(oWLNamedClass, -1);
        }
    }

    public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
        ClassDescriptionTableModel classDescriptionTableModel = (ClassDescriptionTableModel)this.table.getModel();
        return rDFSClass != null && classDescriptionTableModel.isRemoveEnabledFor(rDFSClass);
    }
}

