/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableModel;
import java.util.logging.Level;

public class PropertiesSuperclassesTableModel
extends AbstractOWLTableModel
implements ClassDescriptionTableModel {
    public PropertiesSuperclassesTableModel() {
        super(0);
    }

    public boolean addRow(RDFSClass rDFSClass, int n) {
        this.getEditedCls().addSuperclass(rDFSClass);
        return true;
    }

    protected int getInsertRowIndex(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            return 0;
        }
        return this.getRowCount();
    }

    public RDFProperty getPredicate(int n) {
        return null;
    }

    public boolean isDeleteEnabledFor(RDFSClass rDFSClass) {
        return rDFSClass instanceof OWLAnonymousClass;
    }

    public boolean isRemoveEnabledFor(Cls cls) {
        return cls instanceof RDFSNamedClass && this.getRowCount() > 1 && this.getEditedCls().getNamedSuperclasses().size() > 1;
    }

    protected boolean isSuitable(Cls cls) {
        return cls instanceof RDFSClass && !this.getEditedCls().equals(cls) && this.getEditedCls().isSubclassOf((RDFSClass)cls) && !(cls instanceof OWLRestriction) && (cls instanceof OWLAnonymousClass || cls.isVisible());
    }

    protected void setValueAt(int n, OWLModel oWLModel, String string) throws Exception {
        if (n >= this.getRowCount()) {
            return;
        }
        try {
            DefaultOWLNamedClass defaultOWLNamedClass = (DefaultOWLNamedClass)this.getEditedCls();
            OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
            RDFSClass rDFSClass = oWLClassParser.parseClass(oWLModel, string);
            RDFSClass rDFSClass2 = this.getClass(n);
            String string2 = rDFSClass.getBrowserText();
            if (rDFSClass2 == null) {
                Slot slot = oWLModel.getSlot(":DIRECT-SUPERCLASSES");
                if (defaultOWLNamedClass.hasPropertyValueWithBrowserText(slot, string2)) {
                    this.displaySemanticError("The class " + string2 + " is already a superclass of " + defaultOWLNamedClass.getBrowserText() + ".");
                    if (rDFSClass instanceof OWLAnonymousClass) {
                        rDFSClass.delete();
                    }
                } else {
                    defaultOWLNamedClass.addSuperclass(rDFSClass);
                }
            } else if (rDFSClass2.getBrowserText().equals(string2)) {
                if (rDFSClass instanceof OWLAnonymousClass) {
                    rDFSClass.delete();
                }
            } else {
                defaultOWLNamedClass.addSuperclass(rDFSClass);
                defaultOWLNamedClass.removeSuperclass(rDFSClass2);
                if (!defaultOWLNamedClass.hasNamedSuperclass()) {
                    defaultOWLNamedClass.addSuperclass(oWLModel.getOWLThingClass());
                }
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }
}

