/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableModel;
import java.util.ArrayList;
import java.util.Collection;

public class PropertiesDefinitionTableModel
extends AbstractOWLTableModel
implements ClassDescriptionTableModel {
    public PropertiesDefinitionTableModel() {
        super(0);
    }

    public boolean addRow(RDFSClass rDFSClass, int n) {
        RDFSClass rDFSClass2 = this.getEditedCls().getDefinition();
        if (rDFSClass2 instanceof OWLIntersectionClass) {
            OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)rDFSClass2;
            for (Cls cls : oWLIntersectionClass.getOperands()) {
                if (!cls.getBrowserText().equals(rDFSClass.getBrowserText())) continue;
                return false;
            }
            OWLIntersectionClass oWLIntersectionClass2 = (OWLIntersectionClass)oWLIntersectionClass.createClone();
            oWLIntersectionClass2.addOperand(rDFSClass);
            rDFSClass2.delete();
            this.getEditedCls().addEquivalentClass(oWLIntersectionClass2);
            if (rDFSClass instanceof RDFSNamedClass) {
                this.getEditedCls().addSuperclass(rDFSClass);
            }
        } else {
            if (rDFSClass2.getBrowserText().equals(rDFSClass.getBrowserText())) {
                return false;
            }
            OWLIntersectionClass oWLIntersectionClass = rDFSClass.getOWLModel().createOWLIntersectionClass();
            oWLIntersectionClass.addOperand(rDFSClass2);
            oWLIntersectionClass.addOperand(rDFSClass);
            this.getEditedCls().setDefinition(oWLIntersectionClass);
        }
        return true;
    }

    protected void addRows() {
        for (RDFSClass rDFSClass : this.getDefinitionOperands()) {
            this.insertRow(rDFSClass);
        }
    }

    public void deleteRow(int n) {
        RDFSClass rDFSClass = this.getClass(n);
        if (rDFSClass instanceof OWLAnonymousClass) {
            RDFSClass rDFSClass2 = this.getEditedCls().getDefinition();
            if (rDFSClass2 instanceof OWLIntersectionClass) {
                OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)rDFSClass2;
                ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>(oWLIntersectionClass.getOperands());
                arrayList.remove(rDFSClass);
                if (arrayList.size() > 1) {
                    OWLModel oWLModel = (OWLModel)rDFSClass.getKnowledgeBase();
                    OWLIntersectionClass oWLIntersectionClass2 = oWLModel.createOWLIntersectionClass();
                    for (RDFSClass rDFSClass3 : arrayList) {
                        oWLIntersectionClass2.addOperand(rDFSClass3.createClone());
                    }
                    rDFSClass2.delete();
                    this.getEditedCls().addEquivalentClass(oWLIntersectionClass2);
                } else {
                    RDFSClass rDFSClass4 = (RDFSClass)arrayList.iterator().next();
                    RDFSClass rDFSClass5 = rDFSClass4.createClone();
                    rDFSClass2.delete();
                    this.getEditedCls().addEquivalentClass(rDFSClass5);
                }
            } else {
                rDFSClass2.delete();
            }
        } else {
            super.deleteRow(n);
        }
    }

    private Collection getDefinitionOperands() {
        RDFSClass rDFSClass;
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
        if (this.getEditedCls() != null && (rDFSClass = this.getEditedCls().getDefinition()) != null) {
            if (rDFSClass instanceof OWLIntersectionClass) {
                arrayList.addAll(((OWLIntersectionClass)rDFSClass).getOperands());
            } else {
                arrayList.add(rDFSClass);
            }
        }
        return arrayList;
    }

    protected int getInsertRowIndex(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            return 0;
        }
        return this.getRowCount();
    }

    public RDFProperty getPredicate(int n) {
        return null;
    }

    public boolean isDeleteEnabledFor(RDFSClass rDFSClass) {
        return rDFSClass instanceof OWLAnonymousClass;
    }

    public boolean isRemoveEnabledFor(Cls cls) {
        return cls instanceof RDFSNamedClass && this.getRowCount() > 1 && this.getEditedCls().getNamedSuperclasses().size() > 1;
    }

    protected boolean isSuitable(Cls cls) {
        return cls instanceof RDFSClass && !this.getEditedCls().equals(cls) && this.getDefinitionOperands().contains(cls) && !(cls instanceof OWLRestriction) && (cls instanceof OWLAnonymousClass || cls.isVisible());
    }

    protected void setValueAt(int n, OWLModel oWLModel, String string) throws Exception {
        if (n >= this.getRowCount()) {
            return;
        }
        OWLNamedClass oWLNamedClass = this.getEditedCls();
        OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
        RDFSClass rDFSClass = oWLClassParser.parseClass(oWLModel, string);
        RDFSClass rDFSClass2 = this.getClass(n);
        String string2 = rDFSClass.getBrowserText();
        if (rDFSClass2 == null) {
            if (!this.addRow(rDFSClass, 0)) {
                this.displaySemanticError("The class " + string2 + " is already a superclass of " + oWLNamedClass.getBrowserText() + ".");
                if (rDFSClass instanceof OWLAnonymousClass) {
                    rDFSClass.delete();
                }
            }
        } else if (rDFSClass2.getBrowserText().equals(string2)) {
            if (rDFSClass instanceof OWLAnonymousClass) {
                rDFSClass.delete();
            }
        } else {
            RDFSClass rDFSClass3 = oWLNamedClass.getDefinition();
            if (rDFSClass3 instanceof OWLIntersectionClass) {
                OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)rDFSClass3;
                OWLIntersectionClass oWLIntersectionClass2 = oWLModel.createOWLIntersectionClass();
                for (RDFSClass rDFSClass4 : oWLIntersectionClass.getOperands()) {
                    if (rDFSClass4.equals(rDFSClass2)) {
                        oWLIntersectionClass2.addOperand(rDFSClass);
                        continue;
                    }
                    oWLIntersectionClass2.addOperand(rDFSClass4.createClone());
                }
                if (rDFSClass2 instanceof RDFSNamedClass) {
                    oWLNamedClass.removeSuperclass(rDFSClass2);
                }
                oWLIntersectionClass.delete();
                oWLNamedClass.addEquivalentClass(oWLIntersectionClass2);
                if (rDFSClass instanceof RDFSNamedClass) {
                    oWLNamedClass.addSuperclass(rDFSClass);
                }
                if (oWLNamedClass.getSuperclassCount() == 1) {
                    oWLNamedClass.addSuperclass(oWLModel.getOWLThingClass());
                }
            } else {
                oWLNamedClass.addEquivalentClass(rDFSClass);
                if (rDFSClass2 instanceof OWLAnonymousClass) {
                    rDFSClass2.delete();
                } else {
                    oWLNamedClass.removeSuperclass(rDFSClass2);
                    if (oWLNamedClass.getSuperclassCount() == 1 && rDFSClass instanceof OWLAnonymousClass) {
                        oWLNamedClass.addSuperclass(oWLModel.getOWLThingClass());
                    }
                }
            }
        }
    }
}

