/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class DisjointClassesTableModel
extends AbstractTableModel
implements ClassDescriptionTableModel {
    private OWLNamedClass cls;
    private List rows = new ArrayList();
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            if (rDFProperty.getName().equals(OWLNames.Slot.DISJOINT_WITH)) {
                DisjointClassesTableModel.this.clearRows();
                DisjointClassesTableModel.this.addRows();
            }
        }
    };

    public int addEmptyRow(int n) {
        int n2 = this.getRowCount();
        this.rows.add(null);
        this.fireTableRowsInserted(n2, n2);
        return n2;
    }

    public boolean addRow(RDFSClass rDFSClass, int n) {
        this.addDisjointClass(rDFSClass);
        return true;
    }

    private void addDisjointClass(RDFSClass rDFSClass) {
        OWLModel oWLModel = rDFSClass.getOWLModel();
        if (rDFSClass.equals(oWLModel.getOWLThingClass())) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "You cannot make a class disjoint with owl:Thing.");
            return;
        }
        try {
            OWLNamedClass oWLNamedClass;
            oWLModel.beginTransaction("Add " + rDFSClass.getBrowserText() + " to disjoint classes of " + this.getEditedCls().getBrowserText(), this.getEditedCls().getName());
            this.getEditedCls().addDisjointClass(rDFSClass);
            if (rDFSClass instanceof OWLNamedClass && rDFSClass.isEditable() && !(oWLNamedClass = (OWLNamedClass)rDFSClass).getDisjointClasses().contains(this.getEditedCls())) {
                oWLNamedClass.addDisjointClass(this.getEditedCls());
            }
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
    }

    private void addRows() {
        Collection collection = this.cls.getDisjointClasses();
        for (RDFSClass rDFSClass : collection) {
            this.insertRow(rDFSClass);
        }
    }

    void clearRows() {
        int n = this.getRowCount();
        this.rows.clear();
        if (n > 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    public void deleteRow(int n) {
        RDFSClass rDFSClass = this.getClass(n);
        OWLModel oWLModel = rDFSClass.getOWLModel();
        try {
            OWLNamedClass oWLNamedClass;
            oWLModel.beginTransaction("Delete disjoint class " + rDFSClass.getBrowserText() + " from " + this.getEditedCls().getBrowserText(), this.getEditedCls().getName());
            if (rDFSClass instanceof OWLNamedClass && rDFSClass.isEditable() && (oWLNamedClass = (OWLNamedClass)rDFSClass).getDisjointClasses().contains(this.getEditedCls())) {
                oWLNamedClass.removeDisjointClass(this.getEditedCls());
            }
            this.cls.removeDisjointClass(rDFSClass);
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
        int n2 = this.getClassRow(rDFSClass);
        if (n2 != -1) {
            try {
                this.fireTableRowsDeleted(n2, n2);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Error at removing disjoint class from disjoint table: " + rDFSClass + " Row: " + n2, exception);
            }
        }
    }

    public void displaySemanticError(String string) {
        OWLModel oWLModel = this.cls == null ? null : this.cls.getOWLModel();
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Semantic Error");
    }

    public void dispose() {
        if (this.cls != null) {
            this.removeListeners();
        }
    }

    Cls getCls() {
        return this.cls;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int n) {
        return "Expression";
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public RDFSClass getClass(int n) {
        return (RDFSClass)this.rows.get(n);
    }

    public int getClassRow(RDFSClass rDFSClass) {
        return this.rows.indexOf(rDFSClass);
    }

    public OWLNamedClass getEditedCls() {
        return this.cls;
    }

    public RDFProperty getPredicate(int n) {
        return this.cls.getOWLModel().getOWLDisjointWithProperty();
    }

    public RDFResource getRDFResource(int n) {
        return this.getClass(n);
    }

    public RDFResource getSubject() {
        return this.cls;
    }

    public int getSymbolColumnIndex() {
        return 0;
    }

    public Icon getIcon(RDFResource rDFResource) {
        return ProtegeUI.getIcon(rDFResource);
    }

    int getRow(Cls cls) {
        return this.rows.indexOf(cls);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int n, int n2) {
        if (this.rows.get(n) == null) {
            return "";
        }
        RDFSClass rDFSClass = this.getClass(n);
        return rDFSClass.getBrowserText();
    }

    private void insertRow(RDFSClass rDFSClass) {
        int n = this.rows.size();
        this.rows.add(n, rDFSClass);
        this.fireTableRowsInserted(n, n);
    }

    public boolean isAddEnabledAt(int n) {
        return this.isEditable();
    }

    public boolean isCellEditable(int n, int n2) {
        RDFSClass rDFSClass = this.getClass(n);
        return rDFSClass == null || this.isDeleteEnabledFor(rDFSClass);
    }

    public boolean isDeleteEnabledFor(RDFSClass rDFSClass) {
        if (rDFSClass != null) {
            OWLModel oWLModel = rDFSClass.getOWLModel();
            RDFProperty rDFProperty = oWLModel.getOWLDisjointWithProperty();
            return oWLModel.getTripleStoreModel().isActiveTriple(this.getEditedCls(), rDFProperty, rDFSClass);
        }
        return false;
    }

    public boolean isEditable() {
        return this.getEditedCls().isEditable();
    }

    public boolean isRemoveEnabledFor(Cls cls) {
        for (Cls cls2 : this.getEditedCls().getSuperclasses(false)) {
            if (!(cls2 instanceof OWLNamedClass) || !((OWLNamedClass)cls2).getSubclassesDisjoint() || !cls2.getDirectSubclasses().contains(cls)) continue;
            return false;
        }
        OWLModel oWLModel = this.getEditedCls().getOWLModel();
        return cls instanceof OWLNamedClass && oWLModel.getTripleStoreModel().isActiveTriple(this.getEditedCls(), oWLModel.getOWLDisjointWithProperty(), cls);
    }

    public void removeEmptyRow() {
        int n = this.rows.indexOf(null);
        if (n >= 0) {
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    private void removeListeners() {
        this.cls.removePropertyValueListener(this.valueListener);
    }

    public void setCls(OWLNamedClass oWLNamedClass) {
        this.clearRows();
        if (this.cls != null) {
            this.removeListeners();
        }
        this.cls = oWLNamedClass;
        if (this.cls != null) {
            this.cls.addPropertyValueListener(this.valueListener);
            this.addRows();
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.getRowCount()) {
            return;
        }
        String string = (String)object;
        OWLModel oWLModel = this.cls.getOWLModel();
        try {
            OWLClassParser oWLClassParser = oWLModel.getOWLClassParser();
            RDFSClass rDFSClass = oWLClassParser.parseClass(oWLModel, string);
            RDFSClass rDFSClass2 = this.getClass(n);
            if (rDFSClass2 == null || !object.equals(rDFSClass2)) {
                if (this.cls.getDisjointClasses().contains(rDFSClass)) {
                    this.displaySemanticError("The class " + rDFSClass.getBrowserText() + " is already a disjoint class of " + this.cls.getBrowserText() + ".");
                } else {
                    this.setValueAt(rDFSClass, rDFSClass2);
                }
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }

    private void setValueAt(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
        OWLModel oWLModel = rDFSClass.getOWLModel();
        try {
            oWLModel.beginTransaction("Change disjoint class to " + rDFSClass.getBrowserText(), this.getEditedCls().getName());
            this.addDisjointClass(rDFSClass);
            if (rDFSClass2 != null) {
                this.cls.removeDisjointClass(rDFSClass2);
            }
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
    }
}

