/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.DeleteRowAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public abstract class ClassDescriptionWidget
extends AbstractPropertyWidget {
    private ClassDescriptionTable table;
    private OWLTableAction viewAction = new AbstractOWLTableAction("View/edit class", Icons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            Cls cls = ClassDescriptionWidget.this.table.getSelectedCls();
            if (cls != null) {
                ClassDescriptionWidget.this.showInstance((Instance)cls);
            }
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            return rDFSClass instanceof OWLNamedClass;
        }
    };

    protected abstract ResourceSelectionAction createAddAction(ClassDescriptionTable var1);

    protected abstract Action createCreateAction(ClassDescriptionTable var1);

    protected abstract Icon createHeaderIcon();

    protected abstract List createCustomActions(ClassDescriptionTable var1);

    protected abstract OWLTableModel createTableModel();

    public void dispose() {
        ((OWLTableModel)this.table.getModel()).dispose();
        super.dispose();
    }

    public OWLNamedClass getEditedCls() {
        return this.table.getEditedCls();
    }

    protected OWLLabeledComponent getLabeledComponent() {
        return (OWLLabeledComponent)((Object)this.getComponent(0));
    }

    protected abstract String getLabelText();

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public ClassDescriptionTable getTable() {
        return this.table;
    }

    public void initialize() {
        OWLTableModel oWLTableModel = this.createTableModel();
        OWLModel oWLModel = (OWLModel)this.getProject().getKnowledgeBase();
        this.table = new ClassDescriptionTable(oWLModel, oWLTableModel);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.table));
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent(this.getLabelText(), jScrollPane, true, true);
        Icon icon = this.createHeaderIcon();
        if (icon != null) {
            oWLLabeledComponent.setHeaderIcon(icon);
        }
        WidgetUtilities.addViewButton(oWLLabeledComponent, this.viewAction);
        oWLLabeledComponent.addHeaderButton(this.createCreateAction(this.table));
        ResourceSelectionAction resourceSelectionAction = this.createAddAction(this.table);
        oWLLabeledComponent.addHeaderButton(resourceSelectionAction);
        this.table.registerAction(this.viewAction);
        for (Action action : this.createCustomActions(this.table)) {
            oWLLabeledComponent.addHeaderButton(action);
            if (!(action instanceof OWLTableAction)) continue;
            this.table.registerAction((OWLTableAction)action);
        }
        DeleteRowAction deleteRowAction = new DeleteRowAction(this.table);
        oWLLabeledComponent.addHeaderButton(deleteRowAction);
        this.table.registerAction(deleteRowAction);
        this.table.registerActionSeparator();
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        if (instance instanceof OWLNamedClass) {
            this.table.setCls((OWLNamedClass)instance);
        } else {
            this.table.setCls(null);
        }
    }
}

