/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;

public class ToggleSuperclassExplorerAction
extends AbstractAction {
    private Component component;
    private ExplorerTreePanel explorerTreePanel;
    private Selectable selectable;
    private boolean useInferredSuperclasses;

    public ToggleSuperclassExplorerAction(Selectable selectable, boolean bl) {
        super("Show/Hide superclass explorer", OWLIcons.getImageIcon("SuperclassExplorer"));
        this.component = (Component)selectable;
        this.selectable = selectable;
        this.useInferredSuperclasses = bl;
        selectable.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                if (ToggleSuperclassExplorerAction.this.explorerTreePanel != null) {
                    RDFSClass rDFSClass = ToggleSuperclassExplorerAction.this.getSelectedClass();
                    ToggleSuperclassExplorerAction.this.explorerTreePanel.setRoot(rDFSClass);
                    ToggleSuperclassExplorerAction.this.explorerTreePanel.expandToFillSpace();
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component;
        for (component = this.component; component != null && !(component instanceof HierarchyPanel); component = component.getParent()) {
        }
        if (component != null) {
            HierarchyPanel hierarchyPanel = (HierarchyPanel)component;
            if (hierarchyPanel.getNestedHierarchy() != null) {
                hierarchyPanel.setNestedHierarchy(null);
                this.explorerTreePanel = null;
            } else {
                RDFSClass rDFSClass = this.getSelectedClass();
                String string = this.useInferredSuperclasses ? "Inferred" : "Asserted";
                this.explorerTreePanel = new ExplorerTreePanel(rDFSClass, new ExplorerFilter(){

                    public boolean getUseInferredSuperclasses() {
                        return ToggleSuperclassExplorerAction.this.useInferredSuperclasses;
                    }

                    public boolean isValidChild(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
                        return rDFSClass2 instanceof RDFSNamedClass;
                    }
                }, string + " Superclasses", false);
                hierarchyPanel.setNestedHierarchy(this.explorerTreePanel);
                this.explorerTreePanel.expandToFillSpace();
            }
        }
    }

    private RDFSClass getSelectedClass() {
        RDFSClass rDFSClass = null;
        Collection collection = this.selectable.getSelection();
        if (collection != null && collection.size() > 0) {
            rDFSClass = (RDFSClass)CollectionUtilities.getFirstItem((Collection)collection);
        }
        return rDFSClass;
    }
}

