/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.LogicClassDefinitionWidgetType;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableClassDefinitionWidget;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableType;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplayPlugin;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SwitchClassDefinitionResourceDisplayPlugin
implements ResourceDisplayPlugin {
    private static final Logger log = Log.getLogger(SwitchClassDefinitionResourceDisplayPlugin.class);
    private static final String PROPERTY = "SwitchableClassDefinitionType";
    public static boolean showWarning = true;

    private SwitchableClassDefinitionWidget getSwitchableClassDefinitionWidget(JPanel jPanel) {
        Container container;
        for (container = jPanel.getParent(); container != null && !(container instanceof ResourceDisplay); container = container.getParent()) {
        }
        if (container == null) {
            return null;
        }
        return this.searchForWidget(container);
    }

    private SwitchableClassDefinitionWidget searchForWidget(Component component) {
        if (component instanceof SwitchableClassDefinitionWidget) {
            return (SwitchableClassDefinitionWidget)((Object)component);
        }
        if (component instanceof Container) {
            int n;
            Component[] componentArray = ((Container)component).getComponents();
            for (n = 0; n < componentArray.length; ++n) {
                if (!(componentArray[n] instanceof SwitchableClassDefinitionWidget)) continue;
                return (SwitchableClassDefinitionWidget)((Object)componentArray[n]);
            }
            for (n = 0; n < componentArray.length; ++n) {
                SwitchableClassDefinitionWidget switchableClassDefinitionWidget = this.searchForWidget(componentArray[n]);
                if (switchableClassDefinitionWidget == null) continue;
                return switchableClassDefinitionWidget;
            }
        }
        return null;
    }

    public static String getDefaultClassView() {
        return ApplicationProperties.getString((String)PROPERTY, (String)LogicClassDefinitionWidgetType.class.getName());
    }

    public void initResourceDisplay(RDFResource rDFResource, JPanel jPanel) {
        SwitchableClassDefinitionWidget switchableClassDefinitionWidget;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entering initResourceDisplay - " + rDFResource + ", " + jPanel);
        }
        if (rDFResource instanceof OWLNamedClass && (switchableClassDefinitionWidget = this.getSwitchableClassDefinitionWidget(jPanel)) != null) {
            Serializable serializable;
            OWLProject oWLProject = rDFResource.getOWLModel().getOWLProject();
            String string = oWLProject.getSettingsMap().getString(PROPERTY);
            try {
                if (string != null) {
                    serializable = PluginUtilities.forName((String)string);
                    if (serializable != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("New class = " + string);
                        }
                        SwitchableType switchableType = (SwitchableType)((Class)serializable).newInstance();
                        switchableClassDefinitionWidget.setActiveType(switchableType.getWidgetClassType());
                    }
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("No SwitchableType class found for resource" + rDFResource);
                }
            }
            catch (Exception exception) {
                Log.emptyCatchBlock((Throwable)exception);
            }
            serializable = new SwitchPanel(switchableClassDefinitionWidget);
            ((SwitchPanel)serializable).updateStatus();
            jPanel.add((Component)serializable);
        }
    }

    public static void setClassesView(PropertyList propertyList, String string) {
        propertyList.setString(PROPERTY, string);
    }

    public static void setDefaultClassesView(String string) {
        ApplicationProperties.setString((String)PROPERTY, (String)string);
    }

    private class SwitchPanel
    extends JPanel {
        private Map types2RadioButton = new HashMap();
        private SwitchableClassDefinitionWidget widget;

        SwitchPanel(final SwitchableClassDefinitionWidget switchableClassDefinitionWidget) {
            this.widget = switchableClassDefinitionWidget;
            this.setLayout(new BoxLayout(this, 0));
            ButtonGroup buttonGroup = new ButtonGroup();
            final OWLModel oWLModel = switchableClassDefinitionWidget.getOWLModel();
            Iterator<SwitchableType> iterator = switchableClassDefinitionWidget.listSwitchableTypes();
            while (iterator.hasNext()) {
                final SwitchableType switchableType = iterator.next();
                if (!switchableType.isSuitable(oWLModel)) continue;
                JRadioButton jRadioButton = new JRadioButton(switchableType.getButtonText());
                buttonGroup.add(jRadioButton);
                jRadioButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SwitchPanel.this.switchTo(switchableType);
                        oWLModel.getOWLProject().getSettingsMap().setString(SwitchClassDefinitionResourceDisplayPlugin.PROPERTY, switchableType.getWidgetClassType().getName());
                        switchableClassDefinitionWidget.setInstance(switchableClassDefinitionWidget.getEditedResource());
                    }
                });
                this.add(jRadioButton);
                this.add(Box.createHorizontalStrut(8));
                if (switchableClassDefinitionWidget.getActiveWidgetClass() == switchableType.getWidgetClassType()) {
                    jRadioButton.setSelected(true);
                }
                this.types2RadioButton.put(switchableType, jRadioButton);
            }
        }

        private void switchTo(SwitchableType switchableType) {
            this.widget.setActiveType(switchableType.getWidgetClassType());
        }

        public void updateStatus() {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.widget.getEditedResource();
            block0: for (SwitchableType switchableType : this.types2RadioButton.keySet()) {
                JRadioButton jRadioButton = this.getRadioButton(switchableType);
                if (rDFSNamedClass != null && !switchableType.isSufficientlyExpressive(rDFSNamedClass)) {
                    jRadioButton.setEnabled(false);
                    jRadioButton.setToolTipText("The selected class uses OWL features that cannot be displayed with the " + switchableType.getButtonText() + ".");
                    if (!jRadioButton.isSelected()) continue;
                    SwitchPanel switchPanel = this;
                    Iterator<SwitchableType> iterator = switchPanel.widget.listSwitchableTypes();
                    while (iterator.hasNext()) {
                        SwitchableType switchableType2 = iterator.next();
                        if (switchableType2 == switchableType || !switchableType2.isSufficientlyExpressive(rDFSNamedClass)) continue;
                        JRadioButton jRadioButton2 = this.getRadioButton(switchableType2);
                        jRadioButton2.setSelected(true);
                        this.switchTo(switchableType2);
                        if (!showWarning) continue block0;
                        ProtegeUI.getModalDialogFactory().showMessageDialog(rDFSNamedClass.getOWLModel(), "The class " + rDFSNamedClass.getBrowserText() + " uses OWL features\nthat cannot be displayed with the " + switchableType.getButtonText() + ".\nWe therefore switch to the " + switchableType2.getButtonText() + ".");
                        showWarning = false;
                        continue block0;
                    }
                    continue;
                }
                jRadioButton.setEnabled(true);
                jRadioButton.setToolTipText(null);
            }
        }

        private JRadioButton getRadioButton(SwitchableType switchableType) {
            return (JRadioButton)this.types2RadioButton.get(switchableType);
        }
    }
}

