/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.ClsesTreeTarget;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SuperclassTraverser;
import edu.stanford.smi.protege.util.Traverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.model.Deprecatable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreeRoot;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTreeDragSourceListener;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class OWLSubclassPane
extends SelectableContainer
implements ClassTreePanel {
    private HierarchyManager hierarchyManager;
    public OWLModel owlModel;
    private ClassTree tree;
    private ResourceFinder finder;

    @Deprecated
    public OWLSubclassPane(OWLModel oWLModel, Action action, Cls cls, Action action2) {
        this(oWLModel, action, (RDFSNamedClass)cls);
    }

    public OWLSubclassPane(OWLModel oWLModel, Action action, RDFSNamedClass rDFSNamedClass) {
        this.owlModel = oWLModel;
        this.tree = this.createSelectableTree(action, rDFSNamedClass);
        this.tree.setLargeModel(true);
        this.tree.setSelectionRow(0);
        this.tree.setAutoscrolls(true);
        this.setSelectable(this.tree);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = ComponentFactory.createScrollPane((JComponent)((Object)this.tree));
        this.add("Center", jScrollPane);
        FindInDialogAction findInDialogAction = new FindInDialogAction(new DefaultClassFind(oWLModel, 1), Icons.getFindClsIcon(), this.tree, true);
        this.finder = new ResourceFinder(findInDialogAction);
        this.add("South", this.finder);
        this.setupDragAndDrop();
        this.initializeTreeRenderer();
        this.getTree().addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)((Object)this.tree)){

            public JPopupMenu getPopupMenu() {
                return OWLSubclassPane.this.getPopupMenu();
            }
        });
    }

    protected JPopupMenu createPopupMenu() {
        Cls cls;
        Collection collection = this.getSelection();
        if (collection.size() == 1 && (cls = (Cls)collection.iterator().next()) instanceof RDFSNamedClass) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)this), (RDFResource)cls);
            if (cls instanceof OWLNamedClass && this.hierarchyManager != null) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(new ExistentialAction((Component)((Object)this), this.hierarchyManager, (OWLNamedClass)cls));
            }
            return jPopupMenu;
        }
        return null;
    }

    protected void initializeTreeRenderer() {
        ResourceRenderer resourceRenderer = this.owlModel.getProject().isMultiUserClient() ? this.getRemoteResourceRenderer() : this.getLocalResourceRenderer();
        this.getTree().setCellRenderer((TreeCellRenderer)((Object)resourceRenderer));
    }

    protected ResourceRenderer getLocalResourceRenderer() {
        return new ResourceRenderer(this.owlModel.getSystemFrames().getDirectSuperclassesSlot(), false);
    }

    protected ResourceRenderer getRemoteResourceRenderer() {
        return new ResourceRenderer(this.owlModel.getSystemFrames().getDirectSuperclassesSlot(), false){

            protected void loadClsAfterIcon(Cls cls) {
                this.setMainText(cls.getBrowserText());
                this.appendText(this.getInstanceCountString(cls));
                this.setBackgroundSelectionColor(Colors.getClsSelectionColor());
                if (cls instanceof RDFSClass) {
                    if (cls instanceof Deprecatable && ((Deprecatable)cls).isDeprecated()) {
                        this.addIcon(OWLIcons.getDeprecatedIcon());
                    }
                    this.loadedClass = (RDFSClass)cls;
                } else {
                    this.loadedClass = null;
                }
            }
        };
    }

    protected ClassTree createSelectableTree(Action action, Cls cls) {
        this.owlModel = (OWLModel)cls.getKnowledgeBase();
        ClassTreeRoot classTreeRoot = new ClassTreeRoot(cls, OWLUI.getSortClassTreeOption());
        return new ClassTree(action, classTreeRoot);
    }

    public void extendSelection(Cls cls) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)cls);
    }

    public JComponent getDropComponent() {
        return this.getTree();
    }

    public ResourceFinder getFinder() {
        return this.finder;
    }

    private JPopupMenu getPopupMenu() {
        return this.createPopupMenu();
    }

    public JTree getTree() {
        return this.tree;
    }

    protected Cls pickConcreteCls(Collection collection, String string) {
        OWLNamedClass oWLNamedClass = this.owlModel.getOWLNamedClassClass();
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClassClass();
        RDFSNamedClass rDFSNamedClass2 = oWLNamedClass;
        boolean bl = oWLNamedClass.isVisible();
        boolean bl2 = rDFSNamedClass.isVisible();
        if (OWLUtil.hasRDFProfile(this.owlModel)) {
            rDFSNamedClass2 = rDFSNamedClass;
            rDFSNamedClass.setVisible(true);
            oWLNamedClass.setVisible(true);
        }
        RDFSNamedClass rDFSNamedClass3 = ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this), this.owlModel, Collections.singleton(rDFSNamedClass2), string);
        rDFSNamedClass.setVisible(bl2);
        oWLNamedClass.setVisible(bl);
        return rDFSNamedClass3;
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setHierarchyManager(HierarchyManager hierarchyManager) {
        this.hierarchyManager = hierarchyManager;
    }

    public void setSelectedClass(RDFSClass rDFSClass) {
        this.setSelectedClassDelegate(rDFSClass);
    }

    @Deprecated
    public void setSelectedCls(Cls cls) {
        this.setSelectedClassDelegate(cls);
    }

    protected void setSelectedClassDelegate(Cls cls) {
        if (!this.getSelection().contains(cls) && !cls.isDeleted()) {
            List list = ModelUtilities.getPathToRoot((Cls)cls);
            this.setSelectedObjectPath(this.getTree(), list);
        }
    }

    public void setSelectedClasses(Collection collection) {
        this.setSelectedClassesDelegate(collection);
    }

    protected void setSelectedClassesDelegate(Collection collection) {
        ArrayList<List> arrayList = new ArrayList<List>();
        for (Cls cls : collection) {
            arrayList.add(ModelUtilities.getPathToRoot((Cls)cls));
        }
        ComponentUtilities.setSelectedObjectPaths((JTree)this.getTree(), arrayList);
    }

    @Deprecated
    public void setSelectedClses(Collection collection) {
        this.setSelectedClassesDelegate(collection);
    }

    protected void setSelectedObjectPath(JTree jTree, Collection collection) {
        TreePath treePath = ComponentUtilities.getTreePath((JTree)jTree, (Collection)collection);
        if (treePath != null) {
            WaitCursor waitCursor = new WaitCursor((Component)jTree);
            jTree.scrollPathToVisible(treePath);
            jTree.setSelectionPath(treePath);
            waitCursor.hide();
            jTree.updateUI();
        }
    }

    protected void setupDragAndDrop() {
        if (OWLUI.isDragAndDropSupported(this.owlModel)) {
            JTree jTree = (JTree)this.getSelectable();
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(jTree, 3, (DragGestureListener)((Object)new OWLClassesTreeDragSourceListener()));
            new DropTarget(jTree, 3, (DropTargetListener)new ClsesTreeTarget());
        }
    }

    public void setExpandedCls(Cls cls, boolean bl) {
        List list = ModelUtilities.getPathToRoot((Cls)cls);
        ComponentUtilities.setExpanded((JTree)this.getTree(), (Collection)list, (boolean)bl);
    }

    public void setFinderComponent(JComponent jComponent) {
        this.add(jComponent, "South");
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)defaultRenderer);
    }

    public void setDisplayParent(Cls cls) {
        ComponentUtilities.setDisplayParent((JTree)this.getTree(), (Object)cls, (Traverser)new SuperclassTraverser());
    }

    public String toString() {
        return "SubclassPane";
    }
}

