/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.server.metaproject.OwlMetaProjectConstants;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.AssertedClassesPanel;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchiesHost;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchiesPanel;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.clsdesc.DisjointClassesWidget;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsWidget;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryTabWidget;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassesPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.InferredSubsumptionTreePanel;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractTabWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTree;

public class OWLClassesTab
extends AbstractTabWidget
implements NavigationHistoryTabWidget,
HierarchiesHost {
    protected AssertedClassesPanel clsesPanel;
    protected HierarchiesPanel hierarchiesPanel;
    protected JSplitPane mainSplitPane;
    protected ResourcePanel resourcePanel;

    protected JComponent createAssertedClsesPane() {
        this.clsesPanel = this.createClsesPanel();
        return this.clsesPanel;
    }

    protected ResourcePanel createResourcePanel() {
        return ProtegeUI.getResourcePanelFactory().createResourcePanel(this.getOWLModel(), 0);
    }

    private AssertedClassesPanel createClsesPanel() {
        AssertedClassesPanel assertedClassesPanel = new AssertedClassesPanel(this.getOWLModel(), (HierarchyManager)this.hierarchiesPanel);
        assertedClassesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                OWLClassesTab.this.transmitSelection();
            }
        });
        return assertedClassesPanel;
    }

    protected JSplitPane createMainSplitPane() {
        this.mainSplitPane = this.createLeftRightSplitPane("ClsesTab.left_right", 250);
        this.resourcePanel = this.createResourcePanel();
        JComponent jComponent = (JComponent)((Object)this.resourcePanel);
        this.hierarchiesPanel = new HierarchiesPanel(this);
        this.clsesPanel = (AssertedClassesPanel)((Object)this.createAssertedClsesPane());
        HierarchyPanel hierarchyPanel = new HierarchyPanel(this.clsesPanel, this.hierarchiesPanel, false, this.getOWLModel());
        this.hierarchiesPanel.addHierarchyPanel(hierarchyPanel);
        this.mainSplitPane.setLeftComponent(this.hierarchiesPanel);
        this.mainSplitPane.setRightComponent(jComponent);
        this.mainSplitPane.setDividerLocation(250);
        return this.mainSplitPane;
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSNamedClass) {
            this.clsesPanel.setSelectedClass((RDFSNamedClass)rDFResource);
            return true;
        }
        if (rDFResource instanceof OWLAnonymousClass) {
            OWLAnonymousClass oWLAnonymousClass = (OWLAnonymousClass)rDFResource;
            OWLAnonymousClass oWLAnonymousClass2 = oWLAnonymousClass.getExpressionRoot();
            Collection collection = this.getOWLModel().getReferences(oWLAnonymousClass2, 100000);
            HashSet<Slot> hashSet = new HashSet<Slot>();
            OWLModel oWLModel = oWLAnonymousClass.getOWLModel();
            hashSet.add(oWLModel.getSlot(":DIRECT-TYPE"));
            hashSet.add(oWLModel.getRDFTypeProperty());
            hashSet.add(oWLModel.getSlot(":DIRECT-INSTANCES"));
            for (Reference reference : collection) {
                DisjointClassesWidget disjointClassesWidget;
                if (hashSet.contains(reference.getSlot()) || !(reference.getFrame() instanceof RDFSNamedClass) || !reference.getFrame().isVisible()) continue;
                this.clsesPanel.setSelectedClass((RDFSNamedClass)reference.getFrame());
                ConditionsWidget conditionsWidget = this.getConditionsWidget();
                if (conditionsWidget != null) {
                    conditionsWidget.getCurrentConditionsWidget().getTable().setSelectedRow(oWLAnonymousClass2);
                }
                if ((disjointClassesWidget = this.getDisjointClassesWidget()) != null) {
                    disjointClassesWidget.getTable().setSelectedRow(oWLAnonymousClass2);
                }
                return true;
            }
        }
        return false;
    }

    public void ensureClsSelected(Cls cls, int n) {
        this.ensureClassSelected((RDFSNamedClass)cls, n);
    }

    public void ensureClassSelected(RDFSNamedClass rDFSNamedClass, int n) {
        if (rDFSNamedClass != null && !this.clsesPanel.getSelection().contains(rDFSNamedClass)) {
            ConditionsWidget conditionsWidget;
            this.clsesPanel.setExpandedClass(rDFSNamedClass, true);
            this.clsesPanel.setSelectedClass(rDFSNamedClass);
            if (n >= 0 && rDFSNamedClass.equals(this.resourcePanel.getResource()) && (conditionsWidget = this.getConditionsWidget()) != null) {
                conditionsWidget.setSelectedRow(n);
            }
        }
    }

    public static OWLClassesTab getOWLClassesTab(Component component) {
        while (component != null) {
            if (component instanceof OWLClassesTab) {
                return (OWLClassesTab)((Object)component);
            }
            component = component.getParent();
        }
        return null;
    }

    public static OWLClassesTab getClsesTab(Component component) {
        return OWLClassesTab.getOWLClassesTab(component);
    }

    public ConditionsWidget getConditionsWidget() {
        return (ConditionsWidget)((Object)OWLUI.findComponent((Container)((Object)this.resourcePanel), ConditionsWidget.class));
    }

    public JTree getClsTree() {
        return this.clsesPanel.getClsesTree();
    }

    public DisjointClassesWidget getDisjointClassesWidget() {
        return (DisjointClassesWidget)((Object)OWLUI.findComponent((Container)((Object)this.resourcePanel), DisjointClassesWidget.class));
    }

    protected HierarchiesPanel getHierarchiesPanel() {
        return this.hierarchiesPanel;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierarchiesPanel;
    }

    protected JSplitPane getMainSplitPane() {
        return this.mainSplitPane;
    }

    public Selectable getNestedSelectable() {
        return this.clsesPanel;
    }

    public OWLModel getOWLModel() {
        return (OWLModel)this.getProject().getKnowledgeBase();
    }

    protected ResourceDisplay getResourceDisplay() {
        return (ResourceDisplay)this.resourcePanel;
    }

    public ResourcePanel getResourcePanel() {
        return this.resourcePanel;
    }

    public RDFSNamedClass getSelectedClass() {
        Collection collection = this.clsesPanel.getSelection();
        if (collection.size() == 1) {
            return (RDFSNamedClass)collection.iterator().next();
        }
        return null;
    }

    public void hierarchiesChanged(int n) {
        this.hierarchiesPanel.revalidate();
        this.mainSplitPane.setDividerLocation(n);
        this.mainSplitPane.revalidate();
    }

    public void initialize() {
        this.setIcon(OWLIcons.getClassesIcon());
        this.setLabel("OWLClasses");
        this.mainSplitPane = this.createMainSplitPane();
        this.add(this.mainSplitPane);
        this.setInitialSelection();
        this.setClsTree(this.clsesPanel.getClsesTree());
    }

    public static boolean isSuitable(Project project, Collection collection) {
        if (!(project.getKnowledgeBase() instanceof OWLModel)) {
            collection.add("This tab can only be used with OWL projects.");
            return false;
        }
        if (project.isMultiUserClient() && !RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)project.getKnowledgeBase(), (Operation)OwlMetaProjectConstants.USE_OWL_CLASSES_TAB)) {
            collection.add("Don't have permission to access the owl classes tab");
            return false;
        }
        return true;
    }

    public void refreshChangedClses() {
        ChangedClassesPanel changedClassesPanel = ChangedClassesPanel.get(this.getOWLModel());
        changedClassesPanel.refresh();
        if (changedClassesPanel.getChangeCount() > 0) {
            ResultsPanelManager.addResultsPanel(this.getOWLModel(), changedClassesPanel, true);
        }
        this.hierarchiesPanel.expandRootsOfInferredTrees();
    }

    protected void setMainSplitPane(JSplitPane jSplitPane) {
        this.mainSplitPane = jSplitPane;
    }

    protected void setHierarchiesPanel(HierarchiesPanel hierarchiesPanel) {
        this.hierarchiesPanel = hierarchiesPanel;
    }

    public void setInferredClsesVisible(boolean bl) {
        ProjectView projectView = ProtegeUI.getProjectView(this.getProject());
        projectView.setSelectedTab((TabWidget)this);
        if (bl) {
            this.hierarchiesPanel.showInferredHierarchy(this.getOWLModel());
        } else {
            this.hierarchiesPanel.closeInferredHierarchies();
        }
    }

    protected void setInitialSelection() {
        if (this.clsesPanel != null) {
            this.transmitSelection();
        }
    }

    public void setSelectedCls(OWLNamedClass oWLNamedClass) {
        this.clsesPanel.setSelectedClass(oWLNamedClass);
    }

    public void setSelectedCls(RDFSNamedClass rDFSNamedClass) {
        this.clsesPanel.setSelectedClass(rDFSNamedClass);
    }

    public void showCls(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            this.showClass((RDFSNamedClass)cls);
        }
    }

    public void showClass(RDFSNamedClass rDFSNamedClass) {
        this.clsesPanel.setSelectedClass(rDFSNamedClass);
    }

    public void showInferredHierarchy() {
        OWLModel oWLModel = this.getOWLModel();
        InferredSubsumptionTreePanel inferredSubsumptionTreePanel = new InferredSubsumptionTreePanel(oWLModel);
        this.hierarchiesPanel.addHierarchy(inferredSubsumptionTreePanel);
    }

    protected void transmitSelection() {
        OWLModel oWLModel;
        Collection collection = this.clsesPanel.getSelection();
        Instance instance = null;
        if (collection.size() == 1 && ((instance = (Instance)CollectionUtilities.getFirstItem((Collection)collection)).equals((oWLModel = this.getOWLModel()).getOWLNothing()) || instance.equals(oWLModel.getSystemFrames().getDirectedBinaryRelationCls()) || instance.equals(oWLModel.getRDFListClass()) || instance.equals(oWLModel.getRDFUntypedResourcesClass()))) {
            instance = null;
        }
        if (instance == null || instance instanceof RDFResource) {
            this.resourcePanel.setResource((RDFResource)instance);
        } else if (this.resourcePanel instanceof ResourceDisplay) {
            ((ResourceDisplay)this.resourcePanel).setInstance(instance);
        }
    }
}

