/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JFileChooser;

public class ExtractTaxonomyAction
extends ResourceAction {
    private JFileChooser fileChooser;
    public static final String GROUP = "Extract/";

    public ExtractTaxonomyAction() {
        super("Extract (sub) taxonomy to text file...", Icons.getBlankIcon(), GROUP);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if (this.fileChooser.showSaveDialog(null) == 0) {
            File file = this.fileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                ExtractTaxonomyAction.performAction((RDFSNamedClass)this.getResource(), printWriter);
                fileWriter.close();
                ProtegeUI.getModalDialogFactory().showMessageDialog(this.getOWLModel(), "Taxonomy has been exported to " + file);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.getOWLModel(), "File could not be exported:\n" + exception);
            }
        }
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return component instanceof OWLSubclassPane && rDFResource instanceof RDFSNamedClass;
    }

    public static void performAction(RDFSNamedClass rDFSNamedClass, PrintWriter printWriter) {
        HashSet hashSet = new HashSet();
        ExtractTaxonomyAction.performAction(rDFSNamedClass, hashSet, "", printWriter);
    }

    public static void performAction(Cls cls, Set set, String string, PrintWriter printWriter) {
        set.add(cls);
        printWriter.println(string + cls.getBrowserText());
        string = string + "\t";
        ArrayList arrayList = new ArrayList(cls.getDirectSubclasses());
        Collections.sort(arrayList, new FrameComparator());
        for (Cls cls2 : arrayList) {
            Cls cls3 = cls2;
            if (!(cls3 instanceof RDFSNamedClass) || !cls3.isVisible()) continue;
            if (set.contains(cls3)) {
                printWriter.println(string + "(" + cls3.getBrowserText() + ")...");
                continue;
            }
            ExtractTaxonomyAction.performAction(cls3, set, string, printWriter);
        }
    }
}

