/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;

public class CreateSubclassAction
extends ResourceAction {
    public static final String TEXT = "Create subclass";

    public CreateSubclassAction() {
        super(TEXT, OWLIcons.getCreateIcon("SubClass", 4));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ClassTreePanel classTreePanel = (ClassTreePanel)((Object)this.getComponent());
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getResource();
        CreateSubclassAction.performAction(Collections.singleton(rDFSNamedClass), classTreePanel);
    }

    public int getPriority() {
        return 1;
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return component instanceof ClassTreePanel && rDFResource instanceof RDFSNamedClass;
    }

    public static void performAction(Collection collection, ClassTreePanel classTreePanel) {
        RDFSNamedClass rDFSNamedClass = null;
        RDFSNamedClass rDFSNamedClass2 = (RDFSNamedClass)collection.iterator().next();
        OWLModel oWLModel = rDFSNamedClass2.getOWLModel();
        RDFSClass rDFSClass = rDFSNamedClass2.getProtegeType();
        if (collection.contains(oWLModel.getOWLThingClass()) && !ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Create_OWLClass) && ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.CreateRDFSClass)) {
            rDFSClass = oWLModel.getRDFSNamedClassClass();
        }
        String string = oWLModel.createNewResourceName("Class");
        try {
            oWLModel.beginTransaction("Create class " + NamespaceUtil.getLocalName(string) + " as subclass of " + (rDFSNamedClass2 == null ? "(unknown)" : rDFSNamedClass2.getBrowserText()), string);
            rDFSNamedClass = oWLModel.createRDFSNamedClass(string, collection, rDFSClass);
            if (rDFSNamedClass instanceof OWLNamedClass) {
                for (RDFSNamedClass rDFSNamedClass3 : collection) {
                    ((OWLNamedClass)rDFSNamedClass).addInferredSuperclass(rDFSNamedClass3);
                }
            }
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
        if (rDFSNamedClass != null) {
            classTreePanel.setSelectedClass(rDFSNamedClass);
        }
    }
}

