/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;

public class CreateSiblingClassAction
extends ResourceAction {
    public static final String TEXT = "Create sibling class";

    public CreateSiblingClassAction() {
        super(TEXT, OWLIcons.getCreateIcon("SiblingClass"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ClassTreePanel classTreePanel = (ClassTreePanel)((Object)this.getComponent());
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getResource();
        CreateSiblingClassAction.performAction(rDFSNamedClass, classTreePanel);
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return component instanceof OWLSubclassPane && rDFResource instanceof RDFSNamedClass && !rDFResource.equals(rDFResource.getOWLModel().getOWLThingClass());
    }

    public static void performAction(RDFSNamedClass rDFSNamedClass, ClassTreePanel classTreePanel) {
        RDFSNamedClass rDFSNamedClass2 = null;
        Collection collection = rDFSNamedClass.getNamedSuperclasses();
        if (!collection.isEmpty()) {
            OWLModel oWLModel = rDFSNamedClass.getOWLModel();
            String string = oWLModel.createNewResourceName("Class");
            oWLModel.beginTransaction("Create class " + NamespaceUtil.getLocalName(string) + " as sibling of class " + rDFSNamedClass.getBrowserText(), string);
            try {
                HashSet hashSet;
                RDFSClass rDFSClass = rDFSNamedClass.getRDFType();
                if (rDFSClass == null) {
                    rDFSClass = rDFSNamedClass.getProtegeType();
                }
                if ((rDFSNamedClass2 = oWLModel.createRDFSNamedClass(string, hashSet = new HashSet(collection), rDFSClass)) instanceof OWLNamedClass) {
                    for (RDFSNamedClass rDFSNamedClass3 : hashSet) {
                        ((OWLNamedClass)rDFSNamedClass2).addInferredSuperclass(rDFSNamedClass3);
                    }
                }
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
            if (rDFSNamedClass2 != null) {
                classTreePanel.setSelectedClass(rDFSNamedClass2);
            }
        }
    }
}

