/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTreeWithBrowserTextNode
extends LazyTreeNode {
    private static transient Logger log = Log.getLogger(ClassTreeWithBrowserTextNode.class);
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSubclassAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (clsEvent.getSubclass().isVisible()) {
                ClassTreeWithBrowserTextNode.this.childAdded(ClassTreeWithBrowserTextNode.this.createFrameWithBrowserText((Frame)clsEvent.getSubclass()));
            }
        }

        public void directSubclassRemoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (clsEvent.getSubclass().isVisible()) {
                ClassTreeWithBrowserTextNode.this.childRemoved(ClassTreeWithBrowserTextNode.this.createFrameWithBrowserText((Frame)clsEvent.getSubclass()));
            }
        }

        public void directSubclassMoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            Cls cls = clsEvent.getSubclass();
            FrameWithBrowserText frameWithBrowserText = ClassTreeWithBrowserTextNode.this.createFrameWithBrowserText((Frame)cls);
            int n = new ArrayList<FrameWithBrowserText>(ClassTreeWithBrowserTextNode.this.getChildObjects()).indexOf(frameWithBrowserText);
            if (n != -1) {
                ClassTreeWithBrowserTextNode.this.childRemoved(frameWithBrowserText);
                ClassTreeWithBrowserTextNode.this.childAdded(frameWithBrowserText, n);
            }
        }

        public void directInstanceAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeWithBrowserTextNode.this.notifyNodeChanged();
        }

        public void directInstanceRemoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeWithBrowserTextNode.this.notifyNodeChanged();
        }

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeWithBrowserTextNode.this.notifyNodeChanged();
        }

        public void directSuperclassAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeWithBrowserTextNode.this.notifyNodeChanged();
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void frameReplaced(FrameEvent frameEvent) {
            Frame frame = frameEvent.getFrame();
            Frame frame2 = frameEvent.getNewFrame();
            Cls cls = ClassTreeWithBrowserTextNode.this.getCls();
            if (cls != null && cls.equals(frame)) {
                ClassTreeWithBrowserTextNode.this.reload(ClassTreeWithBrowserTextNode.this.createFrameWithBrowserText(frame2));
            }
        }

        public void browserTextChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            FrameWithBrowserText frameWithBrowserText = (FrameWithBrowserText)ClassTreeWithBrowserTextNode.this.getUserObject();
            Frame frame = frameWithBrowserText.getFrame();
            if (frame != null) {
                frameWithBrowserText.setBrowserText(frame.getBrowserText());
            }
            ClassTreeWithBrowserTextNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            if (frameEvent.getSlot().getName().equals(":DIRECT-TYPE")) {
                Cls cls = ClassTreeWithBrowserTextNode.this.getCls().getKnowledgeBase().getCls(ClassTreeWithBrowserTextNode.this.getCls().getName());
                ClassTreeWithBrowserTextNode.this.reload(ClassTreeWithBrowserTextNode.this.createFrameWithBrowserText((Frame)cls));
            } else {
                ClassTreeWithBrowserTextNode.this.notifyNodeChanged();
            }
        }

        public void visibilityChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeWithBrowserTextNode.this.notifyNodeChanged();
        }
    };
    private InstanceListener instanceListener = new InstanceListener(){

        public void directTypeAdded(InstanceEvent instanceEvent) {
            if (instanceEvent.isReplacementEvent()) {
                return;
            }
            FrameWithBrowserText frameWithBrowserText = (FrameWithBrowserText)ClassTreeWithBrowserTextNode.this.getUserObject();
            if (frameWithBrowserText.getFrame() instanceof Instance) {
                frameWithBrowserText.setTypes(((Instance)frameWithBrowserText.getFrame()).getDirectTypes());
                if (log.isLoggable(Level.FINE)) {
                    log.fine(ClassTreeWithBrowserTextNode.this.logIntro() + "Types changed");
                    Collection collection = ((FrameWithBrowserText)ClassTreeWithBrowserTextNode.this.getUserObject()).getTypes();
                    if (collection != null) {
                        for (Cls cls : collection) {
                            log.fine("\thasType = " + cls);
                        }
                    }
                }
            }
            ClassTreeWithBrowserTextNode.this.notifyNodeChanged();
        }

        public void directTypeRemoved(InstanceEvent instanceEvent) {
            if (instanceEvent.isReplacementEvent()) {
                return;
            }
            FrameWithBrowserText frameWithBrowserText = (FrameWithBrowserText)ClassTreeWithBrowserTextNode.this.getUserObject();
            if (frameWithBrowserText.getFrame() instanceof Instance) {
                frameWithBrowserText.setTypes(((Instance)frameWithBrowserText.getFrame()).getDirectTypes());
                if (log.isLoggable(Level.FINE)) {
                    log.fine(ClassTreeWithBrowserTextNode.this.logIntro() + "Types changed");
                    Collection collection = ((FrameWithBrowserText)ClassTreeWithBrowserTextNode.this.getUserObject()).getTypes();
                    if (collection != null) {
                        for (Cls cls : collection) {
                            log.fine("\thasType = " + cls);
                        }
                    }
                }
            }
            ClassTreeWithBrowserTextNode.this.notifyNodeChanged();
        }
    };

    public ClassTreeWithBrowserTextNode(LazyTreeNode lazyTreeNode, FrameWithBrowserText frameWithBrowserText) {
        super(lazyTreeNode, (Object)frameWithBrowserText, lazyTreeNode.isSorted());
        Frame frame = frameWithBrowserText.getFrame();
        if (frame instanceof Cls) {
            this.attachListener((Cls)frame);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.logIntro() + "Constructed");
            if (frameWithBrowserText.getTypes() != null) {
                for (Cls cls : frameWithBrowserText.getTypes()) {
                    log.fine("\thasType = " + cls);
                }
            }
        }
    }

    protected void attachListener(Cls cls) {
        if (cls != null) {
            cls.addClsListener(this._clsListener);
            cls.addFrameListener(this._frameListener);
            cls.addInstanceListener(this.instanceListener);
        }
    }

    protected void detachListeners(Cls cls) {
        if (cls != null) {
            cls.removeClsListener(this._clsListener);
            cls.removeFrameListener(this._frameListener);
            cls.removeInstanceListener(this.instanceListener);
        }
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }

    protected FrameWithBrowserText createFrameWithBrowserText(Frame frame) {
        if (frame == null) {
            return null;
        }
        FrameWithBrowserText frameWithBrowserText = FrameWithBrowserText.getFrameWithBrowserText((Frame)frame);
        frameWithBrowserText.setIconName(ProtegeUI.getPotentialIconName(frame));
        return frameWithBrowserText;
    }

    protected Collection<FrameWithBrowserText> getChildObjects() {
        Collection collection;
        long l = System.currentTimeMillis();
        try {
            if (this.isCached(this.getCls())) {
                collection = this.getLocalChildren(this.getCls(), this.showHidden());
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Get children of " + this.getCls().getBrowserText() + " from client in " + (System.currentTimeMillis() - l) + " ms.");
                }
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Get children of " + this.getCls().getBrowserText() + " from server in " + (System.currentTimeMillis() - l) + " ms.");
                }
                collection = (Collection)new GetChildObjectsJob(this.getCls().getKnowledgeBase(), this.getCls(), this.showHidden()).execute();
            }
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.WARNING, "Could not get children of class " + this.getUserObject(), throwable);
            return new ArrayList<FrameWithBrowserText>();
        }
        return collection;
    }

    private boolean isCached(Cls cls) {
        boolean bl = RemoteClientFrameStore.isCached((Frame)cls, (Slot)cls.getKnowledgeBase().getSystemFrames().getDirectSubclassesSlot(), null, (boolean)false);
        if (!bl) {
            return false;
        }
        Collection collection = cls.getDirectSubclasses();
        for (Cls cls2 : collection) {
            if (!this.showHidden() && !cls2.isVisible() || RemoteClientFrameStore.isCacheComplete((Frame)cls2)) continue;
            return false;
        }
        return true;
    }

    protected LazyTreeNode createNode(Object object) {
        return new ClassTreeWithBrowserTextNode(this, (FrameWithBrowserText)object);
    }

    protected int getChildObjectCount() {
        if (this.showHidden()) {
            return this.getCls().getDirectSubclassCount();
        }
        Collection<FrameWithBrowserText> collection = this.getChildObjects();
        this.loadChildObjects(collection);
        this.setIsLoaded(true);
        return collection.size();
    }

    protected Collection<FrameWithBrowserText> getLocalChildren(Cls cls, boolean bl) {
        Object object2;
        LinkedHashSet linkedHashSet = null;
        if (bl) {
            linkedHashSet = new LinkedHashSet(cls.getDirectSubclasses());
        } else {
            linkedHashSet = new LinkedHashSet(cls.getVisibleDirectSubclasses());
            if (cls instanceof OWLNamedClass) {
                for (Object object2 : ((OWLNamedClass)cls).getEquivalentClasses()) {
                    if (!(object2 instanceof OWLNamedClass) || object2.getSuperclassCount() <= 1) continue;
                    linkedHashSet.remove(object2);
                }
            }
        }
        ArrayList arrayList = new ArrayList(linkedHashSet);
        Collections.sort(arrayList, new FrameComparator());
        object2 = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Cls cls2 = (Cls)iterator.next();
            object2.add(new FrameWithBrowserText((Frame)cls2, cls2.getBrowserText(), cls2.getDirectTypes(), ProtegeUI.getPotentialIconName((Frame)cls2)));
        }
        return object2;
    }

    protected Comparator getComparator() {
        return null;
    }

    public Cls getCls() {
        FrameWithBrowserText frameWithBrowserText = (FrameWithBrowserText)this.getUserObject();
        return (Cls)frameWithBrowserText.getFrame();
    }

    private boolean showHidden() {
        return this.getCls().getProject().getDisplayHiddenClasses();
    }

    protected void dispose() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.logIntro() + "Disposed!");
        }
        this.detachListeners(this.getCls());
        super.dispose();
    }

    private String logIntro() {
        return "FrameWBText Node (" + ((FrameWithBrowserText)this.getUserObject()).getFrame() + ", " + ((Object)((Object)this)).hashCode() + "): ";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetChildObjectsJob
    extends ProtegeJob {
        private static final long serialVersionUID = -3887527946271511007L;
        private Cls cls;
        private boolean showHidden;

        public GetChildObjectsJob(KnowledgeBase knowledgeBase, Cls cls, boolean bl) {
            super(knowledgeBase);
            this.cls = cls;
            this.showHidden = bl;
        }

        public Object run() throws ProtegeException {
            return this.getChildrenOnServer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Collection<FrameWithBrowserText> getChildrenOnServer() {
            Object object2;
            ArrayList arrayList = new ArrayList();
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            ServerFrameStore.setCurrentSession(null);
            HashSet hashSet = new HashSet();
            try {
                if (this.showHidden) {
                    hashSet = new LinkedHashSet(this.cls.getDirectSubclasses());
                } else {
                    hashSet = new LinkedHashSet(this.cls.getVisibleDirectSubclasses());
                    if (this.cls instanceof OWLNamedClass) {
                        for (Object object2 : ((OWLNamedClass)this.cls).getEquivalentClasses()) {
                            if (!(object2 instanceof OWLNamedClass) || object2.getSuperclassCount() <= 1) continue;
                            hashSet.remove(object2);
                        }
                    }
                }
            }
            finally {
                ServerFrameStore.setCurrentSession((RemoteSession)remoteSession);
            }
            ArrayList arrayList2 = new ArrayList(hashSet);
            Collections.sort(arrayList2, new FrameComparator());
            object2 = new ArrayList();
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Cls cls = (Cls)iterator.next();
                this.addRequestsToFrameCalculator((Frame)cls);
                object2.add(new FrameWithBrowserText((Frame)cls, cls.getBrowserText(), cls.getDirectTypes(), ProtegeUI.getPotentialIconName((Frame)cls)));
            }
            return object2;
        }

        private void addRequestsToFrameCalculator(Frame frame) {
            if (!this.getKnowledgeBase().getProject().isMultiUserServer()) {
                return;
            }
            Server server = Server.getInstance();
            RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
            ServerProject serverProject = server.getServerProject(this.getKnowledgeBase().getProject());
            ServerFrameStore serverFrameStore = (ServerFrameStore)serverProject.getDomainKbFrameStore(remoteSession);
            FrameCalculator frameCalculator = serverFrameStore.getFrameCalculator();
            frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
        }

        public void localize(KnowledgeBase knowledgeBase) {
            super.localize(knowledgeBase);
            LocalizeUtils.localize((Object)this.cls, (KnowledgeBase)knowledgeBase);
        }
    }
}

