/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.ParentChildNodeComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;

public class ClassTreeNode
extends LazyTreeNode {
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSubclassAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (clsEvent.getSubclass().isVisible()) {
                ClassTreeNode.this.childAdded(clsEvent.getSubclass());
            }
        }

        public void directSubclassRemoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (clsEvent.getSubclass().isVisible()) {
                ClassTreeNode.this.childRemoved(clsEvent.getSubclass());
            }
        }

        public void directSubclassMoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            Cls cls = clsEvent.getSubclass();
            int n = new ArrayList(ClassTreeNode.this.getChildObjects()).indexOf(cls);
            if (n != -1) {
                ClassTreeNode.this.childRemoved(cls);
                ClassTreeNode.this.childAdded(cls, n);
            }
        }

        public void directInstanceAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeNode.this.notifyNodeChanged();
        }

        public void directInstanceRemoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeNode.this.notifyNodeChanged();
        }

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeNode.this.notifyNodeChanged();
        }

        public void directSuperclassAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeNode.this.notifyNodeChanged();
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void frameReplaced(FrameEvent frameEvent) {
            Frame frame = frameEvent.getFrame();
            Frame frame2 = frameEvent.getNewFrame();
            Cls cls = ClassTreeNode.this.getCls();
            if (cls != null && cls.equals(frame)) {
                ClassTreeNode.this.reload(frame2);
            }
        }

        public void browserTextChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            if (frameEvent.getSlot().getName().equals(":DIRECT-TYPE")) {
                Cls cls = ClassTreeNode.this.getCls().getKnowledgeBase().getCls(ClassTreeNode.this.getCls().getName());
                ClassTreeNode.this.reload(cls);
            } else {
                ClassTreeNode.this.notifyNodeChanged();
            }
        }

        public void visibilityChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            ClassTreeNode.this.notifyNodeChanged();
        }
    };

    public ClassTreeNode(LazyTreeNode lazyTreeNode, Cls cls) {
        super(lazyTreeNode, (Object)cls, lazyTreeNode.isSorted());
        cls.addClsListener(this._clsListener);
        cls.addFrameListener(this._frameListener);
    }

    protected LazyTreeNode createNode(Object object) {
        return new ClassTreeNode(this, (Cls)object);
    }

    protected void dispose() {
        super.dispose();
        this.getCls().removeClsListener(this._clsListener);
        this.getCls().removeFrameListener(this._frameListener);
    }

    protected int getChildObjectCount() {
        if (this.showHidden()) {
            return this.getCls().getDirectSubclassCount();
        }
        return this.getChildObjects().size();
    }

    protected Collection getChildObjects() {
        if (this.showHidden()) {
            return new HashSet(this.getCls().getDirectSubclasses());
        }
        Cls cls = this.getCls();
        HashSet hashSet = new HashSet(cls.getVisibleDirectSubclasses());
        if (cls instanceof OWLNamedClass) {
            for (RDFSClass rDFSClass : ((OWLNamedClass)cls).getEquivalentClasses()) {
                if (!(rDFSClass instanceof OWLNamedClass) || rDFSClass.getSuperclassCount() <= 1) continue;
                hashSet.remove(rDFSClass);
            }
        }
        return hashSet;
    }

    protected Cls getCls() {
        return (Cls)this.getUserObject();
    }

    protected Comparator getComparator() {
        return new ParentChildNodeComparator();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }

    private boolean showHidden() {
        return this.getCls().getProject().getDisplayHiddenClasses();
    }

    public String toString() {
        return "ParentChildNode(" + this.getCls() + ")";
    }
}

