/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.action.ViewClsAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.cls.CreateSiblingClassAction;
import edu.stanford.smi.protegex.owl.ui.cls.CreateSubclassAction;
import edu.stanford.smi.protegex.owl.ui.cls.DeleteClassAction;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import edu.stanford.smi.protegex.owl.ui.cls.ToggleSuperclassExplorerAction;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ClassMatrixAction;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.subsumption.HiddenClassesPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.InferredSubsumptionTreePanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;

public class AssertedClassesPanel
extends SelectableContainer
implements Hierarchy,
ClassTreePanel {
    protected HeaderComponent classBrowserHeader;
    private Action createSiblingClassAction = new AbstractAction("Create sibling class", OWLIcons.getCreateIcon("SiblingClass")){

        public void actionPerformed(ActionEvent actionEvent) {
            AssertedClassesPanel.this.createSibling();
        }
    };
    private Action createSubClassAction = new AbstractAction("Create subclass", OWLIcons.getCreateIcon("SubClass", 4)){

        public void actionPerformed(ActionEvent actionEvent) {
            AssertedClassesPanel.this.createSubclass();
        }
    };
    protected AllowableAction deleteAction;
    private ExistentialAction existentialAction;
    private HeaderComponent headerComponent;
    private HierarchyManager hierarchyManager;
    protected LabeledComponent labeledComponent;
    private OWLModel owlModel;
    protected OWLSubclassPane subclassPane;
    protected Action viewAction;

    public AssertedClassesPanel(Project project, HierarchyManager hierarchyManager) {
        this((OWLModel)project.getKnowledgeBase(), hierarchyManager);
    }

    public AssertedClassesPanel(OWLModel oWLModel, HierarchyManager hierarchyManager) {
        this.owlModel = oWLModel;
        this.viewAction = this.getViewClassAction();
        this.deleteAction = this.getDeleteClsAction();
        this.createPanes();
        this.labeledComponent = new OWLLabeledComponent(this.getTitle(), (Component)((Object)this.subclassPane), true, false);
        this.labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)this.labeledComponent, "Center");
        this.add((Component)this.createClsBrowserHeader(), "North");
        this.setSelectable((Selectable)this.subclassPane);
        this.updateDeleteActionState();
        this.hierarchyManager = hierarchyManager;
        this.labeledComponent.addHeaderButton(this.createSubClassAction);
        this.labeledComponent.addHeaderButton(this.createSiblingClassAction);
        this.createSiblingClassAction.setEnabled(false);
        this.labeledComponent.addHeaderButton((Action)this.deleteAction);
        this.existentialAction = new ExistentialAction((Component)((Object)this), hierarchyManager, null);
        this.existentialAction.setEnabled(false);
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.OWL_DL)) {
            JButton jButton = this.subclassPane.getFinder().addButton(this.existentialAction);
            this.existentialAction.activateComboBox(jButton);
            AbstractAction abstractAction = new AbstractAction("Explore inferred hierarchy", OWLIcons.getImageIcon("ShowInferred")){

                public void actionPerformed(ActionEvent actionEvent) {
                    AssertedClassesPanel.this.showInferred();
                }
            };
            this.subclassPane.getFinder().addButton(abstractAction);
        }
    }

    protected OWLSubclassPane createSubclassPane(Action action, RDFSNamedClass rDFSNamedClass, Action action2, Action action3) {
        return this.createSubclassPane(action, rDFSNamedClass, action3);
    }

    protected OWLSubclassPane createSubclassPane(Action action, RDFSNamedClass rDFSNamedClass, Action action2) {
        this.subclassPane = new OWLSubclassPane(this.owlModel, action, rDFSNamedClass);
        this.subclassPane.setHierarchyManager(this.hierarchyManager);
        this.subclassPane.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                if (AssertedClassesPanel.this.subclassPane.getSelection().size() == 1) {
                    Cls cls = (Cls)AssertedClassesPanel.this.subclassPane.getSelection().iterator().next();
                    AssertedClassesPanel.this.createSiblingClassAction.setEnabled(!AssertedClassesPanel.this.owlModel.getOWLThingClass().equals(cls));
                    if (cls instanceof OWLNamedClass) {
                        AssertedClassesPanel.this.existentialAction.setEnabled(true);
                        AssertedClassesPanel.this.existentialAction.setCls((OWLNamedClass)cls);
                    } else {
                        AssertedClassesPanel.this.existentialAction.setEnabled(false);
                    }
                }
            }
        });
        this.subclassPane.getFinder().addButton(new ClassMatrixAction(this.owlModel));
        this.subclassPane.getFinder().addButton(new ToggleSuperclassExplorerAction(this, false));
        return this.subclassPane;
    }

    public Hierarchy createClone() {
        AssertedClassesPanel assertedClassesPanel = new AssertedClassesPanel(this.owlModel, this.hierarchyManager);
        assertedClassesPanel.getLabeledComponent().removeHeaderButton(this.getLabeledComponent().getHeaderButtons().size() - 1);
        assertedClassesPanel.getLabeledComponent().removeHeaderButton(this.getLabeledComponent().getHeaderButtons().size() - 1);
        return assertedClassesPanel;
    }

    protected HeaderComponent createClsBrowserHeader() {
        JLabel jLabel = ComponentFactory.createLabel((String)this.owlModel.getProject().getName(), (Icon)Icons.getProjectIcon(), (int)2);
        String string = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        String string2 = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_TITLE);
        this.headerComponent = new HeaderComponent(string2, string, (JComponent)jLabel);
        return this.headerComponent;
    }

    private void createSibling() {
        Collection collection = this.subclassPane.getSelection();
        if (collection.size() == 1) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)collection.iterator().next();
            CreateSiblingClassAction.performAction(rDFSNamedClass, this);
        }
    }

    private void createSubclass() {
        Collection collection = this.subclassPane.getSelection();
        if (!collection.isEmpty()) {
            CreateSubclassAction.performAction(collection, this);
        }
    }

    protected void createPanes() {
        this.subclassPane = this.createSubclassPane(this.viewAction, this.owlModel.getOWLThingClass(), (Action)this.deleteAction);
    }

    public JTree getClsesTree() {
        return (JTree)this.subclassPane.getDropComponent();
    }

    protected AllowableAction getDeleteClsAction() {
        return new AllowableDeleteAction(this);
    }

    protected JComponent getDisplayedComponent() {
        return (JComponent)this.labeledComponent.getCenterComponent();
    }

    public JComponent getDropComponent() {
        return this.subclassPane.getDropComponent();
    }

    public HeaderComponent getHeaderComponent() {
        return this.headerComponent;
    }

    public LabeledComponent getLabeledComponent() {
        return this.labeledComponent;
    }

    public Project getProject() {
        return this.owlModel.getProject();
    }

    public Collection getSelection() {
        return ((Selectable)this.getDisplayedComponent()).getSelection();
    }

    public RDFSClass getSelectedClass() {
        Collection collection = this.subclassPane.getSelection();
        if (collection.isEmpty()) {
            return null;
        }
        return (RDFSClass)collection.iterator().next();
    }

    public String getTitle() {
        return "Asserted Hierarchy";
    }

    public JTree getTree() {
        return this.getClsesTree();
    }

    public String getType() {
        return "Subclass Explorer";
    }

    private Action getViewClassAction() {
        return new ViewClsAction(this){

            public void onView(Object object) {
                AssertedClassesPanel.this.showInstance((Instance)((Cls)object));
            }
        };
    }

    public boolean isDefaultSynchronized() {
        return false;
    }

    public void navigateToResource(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSNamedClass) {
            this.setSelectedClass((RDFSNamedClass)rDFResource);
        }
    }

    public void setExpandedCls(Cls cls, boolean bl) {
        if (cls instanceof RDFSNamedClass) {
            this.setExpandedClass((RDFSNamedClass)cls, bl);
        }
    }

    public void setExpandedClass(RDFSNamedClass rDFSNamedClass, boolean bl) {
        this.subclassPane.setExpandedCls(rDFSNamedClass, bl);
    }

    public void setFinderComponent(JComponent jComponent) {
        this.subclassPane.setFinderComponent(jComponent);
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this.subclassPane.setRenderer(defaultRenderer);
    }

    public void setSelectedClass(RDFSClass rDFSClass) {
        this.subclassPane.setSelectedClass(rDFSClass);
    }

    public void setSelectedCls(Cls cls) {
        this.setSelectedClass((RDFSClass)cls);
    }

    public void showInferred() {
        InferredSubsumptionTreePanel inferredSubsumptionTreePanel = new InferredSubsumptionTreePanel(this.owlModel);
        this.hierarchyManager.addHierarchy(inferredSubsumptionTreePanel);
    }

    public void showHidden() {
        HiddenClassesPanel hiddenClassesPanel = new HiddenClassesPanel(this.owlModel);
        this.hierarchyManager.addHierarchy(hiddenClassesPanel);
    }

    protected void showInstance(Instance instance) {
        this.owlModel.getProject().show(instance);
    }

    protected void updateDeleteActionState() {
        if (this.deleteAction != null) {
            this.deleteAction.onSelectionChange();
        }
    }

    private class AllowableDeleteAction
    extends AllowableAction {
        public AllowableDeleteAction(Selectable selectable) {
            super("Delete selected class(es)", OWLIcons.getDeleteClsIcon(), selectable);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DeleteClassAction.performAction(this.getSelection(), (ClassTreePanel)AssertedClassesPanel.this);
        }

        public void onSelectionChange() {
            boolean bl = true;
            for (Frame frame : this.getSelection()) {
                if (frame.isEditable()) continue;
                bl = false;
                break;
            }
            this.setAllowed(bl);
        }
    }
}

