/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions.triple;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.ui.actions.triple.TripleAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleActionManager {
    private static Map<Class, TripleAction> map = new HashMap<Class, TripleAction>();

    public static void addTripleActionsToMenu(Triple triple, Adder adder) {
        List<TripleAction> list = TripleActionManager.getTripleActions();
        ArrayList<TripleAction> arrayList = new ArrayList<TripleAction>();
        for (TripleAction tripleAction : list) {
            if (!tripleAction.isSuitable(triple)) continue;
            arrayList.add(tripleAction);
        }
        Collections.sort(arrayList, new Comparator<TripleAction>(){

            @Override
            public int compare(TripleAction tripleAction, TripleAction tripleAction2) {
                String string = tripleAction.getName();
                String string2 = tripleAction2.getName();
                return string.compareTo(string2);
            }
        });
        for (TripleAction tripleAction : arrayList) {
            adder.addTripleAction(tripleAction);
        }
    }

    private static List<TripleAction> getTripleActions() {
        ArrayList<TripleAction> arrayList = new ArrayList<TripleAction>();
        Class[] classArray = TripleActionManager.getTripleActionClasses();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            TripleAction tripleAction = TripleActionManager.getTripleAction(clazz);
            arrayList.add(tripleAction);
        }
        return arrayList;
    }

    public static TripleAction getTripleAction(Class clazz) {
        TripleAction tripleAction = map.get(clazz);
        if (tripleAction == null) {
            try {
                tripleAction = (TripleAction)clazz.newInstance();
                map.put(clazz, tripleAction);
            }
            catch (Exception exception) {
                System.err.println("[TripleActionManager] Fatal Error: Could not create TripleAction for " + clazz);
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
        }
        return tripleAction;
    }

    public static Class[] getTripleActionClasses() {
        ArrayList arrayList = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"TripleAction", (String)"True"));
        return arrayList.toArray(new Class[0]);
    }

    public static interface Adder {
        public void addTripleAction(TripleAction var1);
    }
}

