/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.refactoring.RefactorResourceAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class SetSubclassesDisjointTrueAction
extends RefactorResourceAction {
    public SetSubclassesDisjointTrueAction() {
        super("Set all subclasses disjoint", OWLIcons.getImageIcon("PrimitiveClassSD"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLModel oWLModel = this.getResource().getOWLModel();
        RDFProperty rDFProperty = oWLModel.getProtegeSubclassesDisjointProperty();
        if (rDFProperty == null) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "Before you can use this feature, you need to import\nthe Protege metadata ontology.  Activate this using\nOWL/Preferences.../Import Protege metadata ontology.");
        } else {
            try {
                OWLNamedClass oWLNamedClass = (OWLNamedClass)this.getResource();
                oWLModel.beginTransaction("" + this.getValue("Name") + " at " + oWLNamedClass.getBrowserText(), oWLNamedClass == null ? null : oWLNamedClass.getName());
                oWLNamedClass.setSubclassesDisjoint(true);
                for (RDFSClass rDFSClass : oWLNamedClass.getSubclasses(true)) {
                    if (!(rDFSClass instanceof OWLNamedClass) || !rDFSClass.isEditable()) continue;
                    ((OWLNamedClass)rDFSClass).setSubclassesDisjoint(true);
                }
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
        }
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return rDFResource.isEditable() && rDFResource instanceof OWLNamedClass && !((OWLNamedClass)rDFResource).getSubclassesDisjoint();
    }
}

