/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;

public class ConvertIndividualToClassAction
extends ResourceAction {
    public ConvertIndividualToClassAction() {
        super("Convert individual to class", OWLIcons.getCreateIcon("PrimitiveClass"), null, true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RDFIndividual rDFIndividual = (RDFIndividual)this.getResource();
        String string = ConvertIndividualToClassAction.getClsName(rDFIndividual);
        if (ProtegeUI.getModalDialogFactory().showConfirmDialog(this.getComponent(), "This will create a new class " + string + " as a subclass of " + rDFIndividual.getProtegeType().getName() + "\n" + "with restrictions that represent the values of the individual\n" + "and then make this individual an instance of the new class.", "Confirm conversion")) {
            OWLModel oWLModel = rDFIndividual.getOWLModel();
            try {
                oWLModel.beginTransaction("Convert individual " + rDFIndividual.getBrowserText() + " to class", string);
                ConvertIndividualToClassAction.performAction(rDFIndividual);
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
        }
    }

    private static void createRestrictionsForValues(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, Collection collection) {
        OWLModel oWLModel = oWLNamedClass.getOWLModel();
        for (Object e : collection) {
            oWLNamedClass.addSuperclass(oWLModel.createOWLHasValue(rDFProperty, e));
        }
    }

    public static String getClsName(RDFIndividual rDFIndividual) {
        String string;
        String string2 = string = rDFIndividual.getName() + "Class";
        int n = 1;
        while (rDFIndividual.getOWLModel().getRDFResource(string2) != null) {
            string2 = string + n;
            ++n;
        }
        return string2;
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        if (rDFResource instanceof RDFIndividual && rDFResource.isEditable() && !(rDFResource instanceof SWRLIndividual) && !(rDFResource instanceof OWLOntology)) {
            return !rDFResource.isAnonymous();
        }
        return false;
    }

    public static OWLNamedClass performAction(RDFIndividual rDFIndividual) {
        OWLModel oWLModel = rDFIndividual.getOWLModel();
        String string = ConvertIndividualToClassAction.getClsName(rDFIndividual);
        OWLNamedClass oWLNamedClass = oWLModel.createOWLNamedSubclass(string, (OWLNamedClass)rDFIndividual.getProtegeType());
        for (RDFProperty rDFProperty : rDFIndividual.getRDFProperties()) {
            Collection collection;
            if (rDFProperty.equals(oWLModel.getRDFTypeProperty()) || (collection = rDFIndividual.getPropertyValues(rDFProperty)).isEmpty()) continue;
            if (rDFProperty.isAnnotationProperty()) {
                oWLNamedClass.setPropertyValues(rDFProperty, collection);
                continue;
            }
            ConvertIndividualToClassAction.createRestrictionsForValues(oWLNamedClass, rDFProperty, collection);
        }
        rDFIndividual.setProtegeType(oWLNamedClass);
        return oWLNamedClass;
    }
}

