/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.dialogs.DefaultModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.dialogs.DefaultSelectionDialogFactory;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.dialogs.SelectionDialogFactory;
import edu.stanford.smi.protegex.owl.ui.icons.DefaultIconFactory;
import edu.stanford.smi.protegex.owl.ui.icons.IconFactory;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryManager;
import edu.stanford.smi.protegex.owl.ui.navigation.TabNavigationHistorySelectable;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.DefaultResourcePanelFactory;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanelFactory;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class ProtegeUI {
    private static IconFactory iconFactory = new DefaultIconFactory();
    private static Map<Project, ProjectView> viewMap = new HashMap<Project, ProjectView>();
    private static Map<OWLModel, NavigationHistoryManager> navMap = new HashMap<OWLModel, NavigationHistoryManager>();
    private static ModalDialogFactory mdf = new DefaultModalDialogFactory();
    private static SelectionDialogFactory sdf = new DefaultSelectionDialogFactory();
    private static ResourcePanelFactory resourcePanelFactory = new DefaultResourcePanelFactory();

    public static Icon getIcon(RDFResource rDFResource) {
        return iconFactory.getIcon(rDFResource);
    }

    public static IconFactory getIconFactory() {
        return iconFactory;
    }

    public static ModalDialogFactory getModalDialogFactory() {
        return mdf;
    }

    public static ProjectView getProjectView(Component component) {
        while (!(component instanceof ProjectView) && component != null) {
            component = component.getParent();
        }
        return (ProjectView)component;
    }

    public static ProjectView getProjectView(OWLModel oWLModel) {
        return ProtegeUI.getProjectView(oWLModel.getProject());
    }

    public static ProjectView getProjectView(Project project) {
        if (project != null) {
            ProjectView projectView = viewMap.get(project);
            if (projectView != null) {
                return projectView;
            }
            Log.getLogger().warning("No ProjectView registered for project " + project.getName());
            return ProjectManager.getProjectManager().getCurrentProjectView();
        }
        Log.getLogger().warning("Unsafe access to ProjectView using null Project");
        return ProjectManager.getProjectManager().getCurrentProjectView();
    }

    public static NavigationHistoryManager getNavigationHistoryManager(OWLModel oWLModel) {
        NavigationHistoryManager navigationHistoryManager = navMap.get(oWLModel);
        if (navigationHistoryManager == null) {
            TabNavigationHistorySelectable tabNavigationHistorySelectable = new TabNavigationHistorySelectable(oWLModel);
            navigationHistoryManager = new NavigationHistoryManager(tabNavigationHistorySelectable, oWLModel);
            navMap.put(oWLModel, navigationHistoryManager);
        }
        return navigationHistoryManager;
    }

    public static ResourcePanelFactory getResourcePanelFactory() {
        return resourcePanelFactory;
    }

    public static SelectionDialogFactory getSelectionDialogFactory() {
        return sdf;
    }

    public static Component getTopLevelContainer(OWLModel oWLModel) {
        return ProtegeUI.getTopLevelContainer(oWLModel.getProject());
    }

    public static Component getTopLevelContainer(Project project) {
        Object object;
        for (object = ProtegeUI.getProjectView(project); object != null && object.getParent() != null; object = object.getParent()) {
        }
        return object;
    }

    public static void register(ProjectView projectView) {
        viewMap.put(projectView.getProject(), projectView);
    }

    public static void reloadUI(Project project) {
        ProjectView projectView = ProtegeUI.getProjectView(project);
        ProtegeUI.reloadUI(projectView);
    }

    public static void reloadUI(ProjectView projectView) {
        if (projectView == null) {
            return;
        }
        int n = projectView.getTabbedPane().getTabPlacement();
        projectView.reload(true);
        projectView.getTabbedPane().setTabPlacement(n);
        Container container = projectView.getTopLevelAncestor();
        ((Component)container).invalidate();
        ((Component)container).validate();
    }

    public static void reloadUI(OWLModel oWLModel) {
        ProtegeUI.reloadUI(oWLModel.getProject());
    }

    public static void setIconFactory(IconFactory iconFactory) {
        ProtegeUI.iconFactory = iconFactory;
    }

    public static void setModalDialogFactory(ModalDialogFactory modalDialogFactory) {
        mdf = modalDialogFactory;
    }

    public static void setResourcePanelFactory(ResourcePanelFactory resourcePanelFactory) {
        ProtegeUI.resourcePanelFactory = resourcePanelFactory;
    }

    public static void setSelectionDialogFactory(SelectionDialogFactory selectionDialogFactory) {
        sdf = selectionDialogFactory;
    }

    public static void show(RDFResource rDFResource) {
        if (rDFResource != null) {
            rDFResource.getProject().show((Instance)rDFResource);
        }
    }

    public static void unregister(ProjectView projectView) {
        Project project = projectView.getProject();
        NavigationHistoryManager navigationHistoryManager = navMap.get(project.getKnowledgeBase());
        if (navigationHistoryManager != null) {
            navigationHistoryManager.dispose();
            navMap.remove(project.getKnowledgeBase());
        }
        viewMap.remove(project);
    }

    public static String getPotentialIconName(Frame frame) {
        return frame instanceof RDFResource ? ((RDFResource)frame).getIconName() : null;
    }
}

