/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protegex.owl.model.Task;
import edu.stanford.smi.protegex.owl.model.TaskProgressDisplay;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class ProgressDisplayDialog
extends JDialog
implements TaskProgressDisplay {
    private static final long serialVersionUID = -3732900819838480521L;
    private static final int DISPLAY_DELAY = 3000;
    private Box box;
    private Map taskProgressPanelMap = new HashMap();
    private NullTaskDisplay nullTaskDisplay = new NullTaskDisplay();
    private Map subTaskTimers = new HashMap();

    public ProgressDisplayDialog() {
        super(ProgressDisplayDialog.getOwnerFrame(), true);
        this.setDefaultCloseOperation(0);
        this.createUI();
    }

    private static Frame getOwnerFrame() {
        Component component;
        Project project = ProjectManager.getProjectManager().getCurrentProject();
        if (project != null && (component = ProtegeUI.getTopLevelContainer(project)) instanceof Frame) {
            return (Frame)component;
        }
        return null;
    }

    private void createUI() {
        JPanel jPanel = new JPanel(new BorderLayout(7, 7));
        JLabel jLabel = new JLabel(UIManager.getDefaults().getIcon("OptionPane.informationIcon"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel.add((Component)jPanel2, "West");
        this.box = new Box(1);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.add((Component)this.box, "Center");
        this.setContentPane(jPanel);
        this.pack();
    }

    public void run(final Task task) throws Exception {
        final ProgressPanel progressPanel = new ProgressPanel(task);
        this.taskProgressPanelMap.put(task, progressPanel);
        Runnable runnable = new Runnable(){

            public void run() {
                if (ProgressDisplayDialog.this.taskProgressPanelMap.size() > 1) {
                    Timer timer = new Timer(3000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ProgressDisplayDialog.this.box.add(progressPanel);
                            ProgressDisplayDialog.this.pack();
                            ProgressDisplayDialog.this.subTaskTimers.remove(task);
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                    ProgressDisplayDialog.this.subTaskTimers.put(task, timer);
                } else {
                    ProgressDisplayDialog.this.box.add(progressPanel);
                    ProgressDisplayDialog.this.pack();
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
        this.runTask(task);
    }

    private void runTask(final Task task) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        task.runTask();
                        ProgressDisplayDialog.this.end(task);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            thread.start();
            this.displayProgressDialog();
        } else {
            task.runTask();
            this.end(task);
        }
    }

    private void displayProgressDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("[ProgressDisplayDialog] displayOrBlock should only be called from the event dispatch thread!");
        }
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 3000L) {
        }
        if (this.taskProgressPanelMap.size() > 0) {
            this.centreDialog();
            this.setVisible(true);
        }
    }

    private ProgressPanel getProgressPanel(Task task) {
        ProgressPanel progressPanel = (ProgressPanel)this.taskProgressPanelMap.get(task);
        return progressPanel;
    }

    private TaskDisplay getTaskDisplay(Task task) {
        TaskDisplay taskDisplay = this.getProgressPanel(task);
        if (taskDisplay == null) {
            taskDisplay = this.nullTaskDisplay;
        }
        return taskDisplay;
    }

    public void setProgress(final Task task, final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                ProgressDisplayDialog.this.getTaskDisplay(task).setProgress(n);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setProgressIndeterminate(final Task task, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ProgressDisplayDialog.this.getTaskDisplay(task).setProgressIndeterminate(bl);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setMessage(final Task task, final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                ProgressDisplayDialog.this.getTaskDisplay(task).setMessage(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void end(final Task task) {
        Timer timer = (Timer)this.subTaskTimers.get(task);
        if (timer != null) {
            timer.stop();
        }
        this.subTaskTimers.remove(task);
        Runnable runnable = new Runnable(){

            public void run() {
                ProgressPanel progressPanel = ProgressDisplayDialog.this.getProgressPanel(task);
                if (progressPanel != null) {
                    ProgressDisplayDialog.this.taskProgressPanelMap.remove(task);
                    ProgressDisplayDialog.this.box.remove(progressPanel);
                    ProgressDisplayDialog.this.pack();
                }
                if (ProgressDisplayDialog.this.taskProgressPanelMap.size() == 0) {
                    ProgressDisplayDialog.this.setVisible(false);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void centreDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
    }

    private static interface TaskDisplay {
        public void setProgress(int var1);

        public void setProgressIndeterminate(boolean var1);

        public void setMessage(String var1);
    }

    private class NullTaskDisplay
    implements TaskDisplay {
        private NullTaskDisplay() {
        }

        public void setProgress(int n) {
        }

        public void setProgressIndeterminate(boolean bl) {
        }

        public void setMessage(String string) {
        }
    }

    private class ProgressPanel
    extends JPanel
    implements TaskDisplay {
        private static final long serialVersionUID = -5710782039645228802L;
        private JLabel titleLabel;
        private JLabel msgLabel;
        private JProgressBar progressBar;
        public static final int INDENT = 20;

        public ProgressPanel(Task task) {
            this.setLayout(new BorderLayout(7, 7));
            this.setBorder(BorderFactory.createEmptyBorder(10, ProgressDisplayDialog.this.taskProgressPanelMap.size() == 0 ? 0 : 20, 5, 0));
            JPanel jPanel = new JPanel(new BorderLayout(3, 3));
            this.titleLabel = new JLabel(task.getTitle());
            jPanel.add((Component)this.titleLabel, "North");
            this.msgLabel = new JLabel("");
            this.msgLabel.setFont(this.msgLabel.getFont().deriveFont(this.msgLabel.getFont().getSize2D() * 0.8f));
            this.msgLabel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            jPanel.add((Component)this.msgLabel, "South");
            this.add((Component)jPanel, "North");
            this.progressBar = new JProgressBar(task.getProgressMin(), task.getProgressMax());
            this.progressBar.setIndeterminate(true);
            JPanel jPanel2 = new JPanel(new BorderLayout(7, 7));
            jPanel2.add((Component)this.progressBar, "North");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            this.add((Component)jPanel2, "South");
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = graphics.getColor();
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawLine(5, this.getHeight() - 2, this.getWidth() - 5, this.getHeight() - 2);
            graphics.setColor(color);
        }

        public void setMessage(String string) {
            this.msgLabel.setText(string);
        }

        public void setProgress(int n) {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            this.progressBar.setValue(n);
        }

        public void setProgressIndeterminate(boolean bl) {
            this.progressBar.setIndeterminate(bl);
        }
    }
}

