/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.style;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SubclassesRestrictionDuplicatesThatOfSuperTest
extends AbstractOWLTest
implements RDFSClassTest,
AutoRepairableOWLTest {
    private static String failedRest;

    public String getDocumentation() {
        return "Find classes that reimplement the same restriction as on a subclass";
    }

    public String getGroup() {
        return "Style";
    }

    public String getName() {
        return "Duplicate Restriction on Superclass";
    }

    public List test(RDFSClass rDFSClass) {
        if (SubclassesRestrictionDuplicatesThatOfSuperTest.fails(rDFSClass)) {
            return Collections.singletonList(new DefaultOWLTestResult("This class duplicates restrictions from parents (" + failedRest + ")", rDFSClass, 2, this));
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean fails(RDFSClass rDFSClass) {
        boolean bl = false;
        failedRest = null;
        if (rDFSClass instanceof OWLNamedClass) {
            Iterator iterator = SubclassesRestrictionDuplicatesThatOfSuperTest.getDuplicateRestrictions((OWLNamedClass)rDFSClass);
            while (iterator.hasNext()) {
                bl = true;
                if (failedRest == null) {
                    failedRest = ((OWLRestriction)iterator.next()).getBrowserText();
                    continue;
                }
                failedRest = failedRest + ", " + ((OWLRestriction)iterator.next()).getBrowserText();
            }
        }
        return bl;
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        boolean bl = false;
        if (oWLTestResult.getHost() instanceof OWLNamedClass) {
            bl = SubclassesRestrictionDuplicatesThatOfSuperTest.fix((OWLNamedClass)oWLTestResult.getHost());
        }
        return bl;
    }

    public static boolean fix(OWLNamedClass oWLNamedClass) {
        boolean bl = false;
        Iterator iterator = SubclassesRestrictionDuplicatesThatOfSuperTest.getDuplicateRestrictions(oWLNamedClass);
        while (iterator.hasNext()) {
            ((OWLRestriction)iterator.next()).delete();
            bl = true;
        }
        return bl;
    }

    private static Collection getAllInheritedRestrictions(OWLNamedClass oWLNamedClass) {
        Iterator iterator = oWLNamedClass.getNamedSuperclasses(true).iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            RDFSClass rDFSClass = (RDFSClass)iterator.next();
            if (!(rDFSClass instanceof OWLNamedClass) || rDFSClass.equals(oWLNamedClass)) continue;
            arrayList.addAll(((OWLNamedClass)rDFSClass).getRestrictions());
        }
        return arrayList;
    }

    private static Iterator getDuplicateRestrictions(OWLNamedClass oWLNamedClass) {
        Collection collection = oWLNamedClass.getRestrictions();
        Collection collection2 = SubclassesRestrictionDuplicatesThatOfSuperTest.getAllInheritedRestrictions(oWLNamedClass);
        ArrayList<OWLRestriction> arrayList = new ArrayList<OWLRestriction>();
        for (OWLRestriction oWLRestriction : collection) {
            for (OWLRestriction oWLRestriction2 : collection2) {
                if (!oWLRestriction.equalsStructurally(oWLRestriction2)) continue;
                arrayList.add(oWLRestriction);
            }
        }
        return arrayList.iterator();
    }
}

