/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.style;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PrimitiveSubclassesDisjointTest
extends AbstractOWLTest
implements RDFSClassTest,
AutoRepairableOWLTest {
    public String getDocumentation() {
        return "Checks that all primitive subclasses are disjoint";
    }

    public String getGroup() {
        return "Style";
    }

    public String getName() {
        return "Normalisation: Primitive Subclasses Disjoint";
    }

    public List test(RDFSClass rDFSClass) {
        Collection collection = this.getPrimitiveSubs(rDFSClass);
        if (collection.size() > 1) {
            ArrayList<Object> arrayList = new ArrayList<Object>(collection);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (Object object : collection) {
                arrayList.remove(object);
                if (!object.getDisjointClasses().containsAll(arrayList)) {
                    arrayList2.add(object);
                }
                arrayList.add(object);
            }
            if (!arrayList2.isEmpty()) {
                Object object;
                Object object2 = "Missing disjoints on primitive subclasses:";
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    object2 = (String)object2 + " " + ((OWLNamedClass)object.next()).getBrowserText();
                }
                return Collections.singletonList(new DefaultOWLTestResult((String)object2, rDFSClass, 2, this));
            }
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getPrimitiveSubs(RDFSClass rDFSClass) {
        Collection collection = rDFSClass.getNamedSubclasses();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDFSClass rDFSClass2 = (RDFSClass)iterator.next();
            if (rDFSClass2 instanceof OWLNamedClass && rDFSClass2.isVisible()) {
                if (!((OWLNamedClass)rDFSClass2).isDefinedClass()) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        return collection;
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)oWLTestResult.getHost());
        return true;
    }
}

