/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.Collections;
import java.util.List;

public class InverseOfTransitivePropertyMustBeTransitivePropertyTest
extends AbstractOWLTest
implements RDFPropertyTest,
RepairableOWLTest {
    public InverseOfTransitivePropertyMustBeTransitivePropertyTest() {
        super("Sanity Tests", null);
    }

    public static boolean fails(RDFProperty rDFProperty) {
        if (rDFProperty instanceof OWLObjectProperty && rDFProperty.getInverseProperty() instanceof OWLObjectProperty) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)rDFProperty.getInverseProperty();
            return ((OWLObjectProperty)rDFProperty).isTransitive() != oWLObjectProperty.isTransitive();
        }
        return false;
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        RDFProperty rDFProperty = (RDFProperty)oWLTestResult.getHost();
        if (InverseOfTransitivePropertyMustBeTransitivePropertyTest.fails(rDFProperty) && rDFProperty instanceof OWLObjectProperty && rDFProperty.getInverseProperty() instanceof OWLObjectProperty) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)rDFProperty.getInverseProperty();
            boolean bl = ((OWLObjectProperty)rDFProperty).isTransitive();
            oWLObjectProperty.setTransitive(bl);
            return true;
        }
        return false;
    }

    public List test(RDFProperty rDFProperty) {
        if (InverseOfTransitivePropertyMustBeTransitivePropertyTest.fails(rDFProperty)) {
            return Collections.singletonList(new DefaultOWLTestResult("The transitivity of a property should also hold for its inverse.", rDFProperty, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

