/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import javax.swing.Icon;

public class DefaultOWLTestResult
implements OWLTestResult {
    private Icon icon;
    private String message;
    private RDFResource source;
    private OWLTest test;
    private int type;
    private Object userObject;

    public DefaultOWLTestResult(String string, RDFResource rDFResource, int n, OWLTest oWLTest) {
        this(string, rDFResource, n, oWLTest, null);
    }

    public DefaultOWLTestResult(String string, RDFResource rDFResource, int n, OWLTest oWLTest, Icon icon) {
        this.message = string;
        this.source = rDFResource;
        this.type = n;
        this.test = oWLTest;
        this.icon = icon;
    }

    public RDFResource getHost() {
        return this.source;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            int n = this.getType();
            if (n == 1) {
                return OWLIcons.getOWLTestErrorIcon();
            }
            if (n == 2) {
                return OWLIcons.getOWLTestWarningIcon();
            }
            if (n == 3) {
                return OWLIcons.getOWLFullIcon();
            }
            return Icons.getBlankIcon();
        }
        return this.icon;
    }

    public String getMessage() {
        return this.message;
    }

    public OWLTest getOWLTest() {
        return this.test;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type == 1) {
            return "Error";
        }
        if (this.type == 2) {
            return "Warning";
        }
        if (this.type == 3) {
            return "OWL Full";
        }
        return "";
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public String toString() {
        String string = this.getHost() == null ? "" : " (at " + this.getHost().getBrowserText() + ")";
        return this.getTypeString() + string + ": " + this.getMessage();
    }
}

