/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.util;

import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.AmbiguousNameException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.ParserUtils;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLOWLUtilException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLOWLUtil {
    public static JenaOWLModel createJenaOWLModel(String string) throws SWRLOWLUtilException {
        JenaOWLModel jenaOWLModel = null;
        try {
            jenaOWLModel = ProtegeOWL.createJenaOWLModelFromURI(new File(string).toURI().toString());
        }
        catch (Exception exception) {
            SWRLOWLUtil.throwException("error opening OWL file " + string + ": " + exception.getMessage());
        }
        return jenaOWLModel;
    }

    public static JenaOWLModel createJenaOWLModel() throws SWRLOWLUtilException {
        JenaOWLModel jenaOWLModel = null;
        try {
            jenaOWLModel = ProtegeOWL.createJenaOWLModel();
        }
        catch (Exception exception) {
            throw new SWRLOWLUtilException("error creating Jena OWL model: " + exception.getMessage());
        }
        return jenaOWLModel;
    }

    public static void importOWLFile(JenaOWLModel jenaOWLModel, String string) throws SWRLOWLUtilException {
        try {
            ImportHelper importHelper = new ImportHelper(jenaOWLModel);
            URI uRI = URIUtilities.createURI((String)new File(string).toURI().toString());
            importHelper.addImport(uRI);
            importHelper.importOntologies(false);
        }
        catch (Exception exception) {
            SWRLOWLUtil.throwException("error importing OWL file " + string + ": " + exception.getMessage());
        }
    }

    public static void setPrefix(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        try {
            oWLModel.getNamespaceManager().setPrefix(new URI(string2), string);
        }
        catch (URISyntaxException uRISyntaxException) {
            SWRLOWLUtil.throwException("error setting prefix " + string + " for namespace " + string2 + ": " + uRISyntaxException.getMessage());
        }
    }

    public static void writeJenaOWLModel2File(JenaOWLModel jenaOWLModel, String string) throws SWRLOWLUtilException {
        ArrayList arrayList = new ArrayList();
        URI uRI = URIUtilities.createURI((String)new File(string).toURI().toString());
        jenaOWLModel.save(uRI, "RDF/XML-ABBREV", arrayList);
        if (arrayList.size() != 0) {
            SWRLOWLUtil.throwException("error creating output OWL file " + string + ": " + arrayList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OWLNamedClass createOWLNamedClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        SWRLOWLUtil.checkIfIsValidClassName(oWLModel, string);
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (rDFResource == null) return oWLModel.createOWLNamedClass(string);
        if (!(rDFResource instanceof OWLNamedClass)) throw new SWRLOWLUtilException("class " + string + " is not an OWL named class");
        return (OWLNamedClass)rDFResource;
    }

    public static OWLIndividual createOWLIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = oWLModel.getOWLIndividual(string);
        if (oWLIndividual == null) {
            oWLIndividual = SWRLOWLUtil.createIndividual(oWLModel, string);
        }
        return oWLIndividual;
    }

    public static RDFSNamedClass createRDFSNamedClass(OWLModel oWLModel, String string) {
        RDFSNamedClass rDFSNamedClass = oWLModel.getRDFSNamedClass(string);
        if (rDFSNamedClass == null) {
            rDFSNamedClass = oWLModel.createRDFSNamedClass(string);
        }
        return rDFSNamedClass;
    }

    public static OWLNamedClass createOWLNamedClass(OWLModel oWLModel) {
        return oWLModel.createOWLNamedClass(null);
    }

    public static OWLObjectProperty createOWLObjectProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLObjectProperty oWLObjectProperty = oWLModel.getOWLObjectProperty(string);
        if (oWLObjectProperty == null) {
            oWLObjectProperty = oWLModel.createOWLObjectProperty(string);
        }
        if (oWLObjectProperty == null) {
            throw new SWRLOWLUtilException("error creating OWL object property " + string);
        }
        return oWLObjectProperty;
    }

    public static OWLObjectProperty createOWLObjectProperty(OWLModel oWLModel) {
        return oWLModel.createOWLObjectProperty(null);
    }

    public static OWLDatatypeProperty createOWLDatatypeProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLDatatypeProperty oWLDatatypeProperty = oWLModel.getOWLDatatypeProperty(string);
        if (oWLDatatypeProperty == null) {
            oWLDatatypeProperty = oWLModel.createOWLDatatypeProperty(string);
        }
        if (oWLDatatypeProperty == null) {
            throw new SWRLOWLUtilException("error creating OWL data property " + string);
        }
        return oWLDatatypeProperty;
    }

    public static RDFProperty createOWLAnnotationProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        RDFProperty rDFProperty = oWLModel.getRDFProperty(string);
        if (rDFProperty == null) {
            rDFProperty = oWLModel.createAnnotationProperty(string);
        } else if (!rDFProperty.isAnnotationProperty()) {
            throw new SWRLOWLUtilException("property " + string + " is not an annotation property");
        }
        if (rDFProperty == null) {
            throw new SWRLOWLUtilException("error creating OWL annotation property " + string);
        }
        return rDFProperty;
    }

    public static RDFSNamedClass createRDFSNamedClassUsingLabelAnnotation(OWLModel oWLModel, String string, boolean bl) {
        RDFSNamedClass rDFSNamedClass = null;
        Collection collection = oWLModel.getMatchingResources(oWLModel.getRDFSLabelProperty(), "*" + string, -1);
        if (!bl && collection != null && !collection.isEmpty()) {
            for (Object e : collection) {
                if (!(e instanceof OWLNamedClass)) continue;
                OWLNamedClass oWLNamedClass = (OWLNamedClass)e;
                for (Object e2 : oWLNamedClass.getPropertyValues(oWLModel.getRDFSLabelProperty())) {
                    Object object;
                    if (!(e2 instanceof String ? ((String)(object = (String)e2)).equalsIgnoreCase(string) : e2 instanceof RDFSLiteral && (object = (RDFSLiteral)e2).getString().equalsIgnoreCase(string))) continue;
                    return oWLNamedClass;
                }
            }
        }
        if (rDFSNamedClass == null) {
            rDFSNamedClass = oWLModel.createRDFSNamedClass(null);
        }
        if (!rDFSNamedClass.hasPropertyValue(oWLModel.getRDFSLabelProperty(), string)) {
            rDFSNamedClass.addPropertyValue(oWLModel.getRDFSLabelProperty(), string);
        }
        return rDFSNamedClass;
    }

    public static OWLNamedClass createOWLNamedClassWithRDFSLabel(OWLModel oWLModel, String string, String string2, String string3, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = null;
        Collection collection = oWLModel.getMatchingResources(oWLModel.getRDFSLabelProperty(), "*" + string2, -1);
        if (!bl && collection != null && !collection.isEmpty()) {
            for (Object e : collection) {
                OWLNamedClass oWLNamedClass2;
                if (!(e instanceof OWLNamedClass) || !(oWLNamedClass2 = (OWLNamedClass)e).getNamespace().equals(string)) continue;
                for (Object e2 : oWLNamedClass2.getPropertyValues(oWLModel.getRDFSLabelProperty())) {
                    Object object;
                    if (e2 instanceof String) {
                        object = (String)e2;
                        if (string3 != null && !string3.equals("") || !((String)object).equalsIgnoreCase(string2)) continue;
                        return oWLNamedClass2;
                    }
                    if (!(e2 instanceof RDFSLiteral) || (object = (RDFSLiteral)e2).getLanguage() != string3 || !object.getString().equalsIgnoreCase(string2)) continue;
                    return oWLNamedClass2;
                }
            }
        }
        if (oWLNamedClass == null) {
            oWLNamedClass = oWLModel.createOWLNamedClass(null);
        }
        SWRLOWLUtil.addRDFSLabel(oWLNamedClass, string2, string3);
        return oWLNamedClass;
    }

    public static OWLObjectProperty createOWLObjectPropertyUsingLabelAnnotation(OWLModel oWLModel, String string, String string2, String string3, boolean bl) throws SWRLOWLUtilException {
        OWLObjectProperty oWLObjectProperty = null;
        Collection collection = oWLModel.getMatchingResources(oWLModel.getRDFSLabelProperty(), "*" + string2, -1);
        if (!bl && collection != null && !collection.isEmpty()) {
            for (Object e : collection) {
                OWLObjectProperty oWLObjectProperty2;
                if (!(e instanceof OWLNamedClass) || !(oWLObjectProperty2 = (OWLObjectProperty)e).getNamespace().equals(string)) continue;
                for (Object e2 : oWLObjectProperty2.getPropertyValues(oWLModel.getRDFSLabelProperty())) {
                    Object object;
                    if (e2 instanceof String) {
                        object = (String)e2;
                        if (string3 != null && !string3.equals("") || !((String)object).equalsIgnoreCase(string2)) continue;
                        return oWLObjectProperty2;
                    }
                    if (!(e2 instanceof RDFSLiteral) || (object = (RDFSLiteral)e2).getLanguage() != string3 || !object.getString().equalsIgnoreCase(string2)) continue;
                    return oWLObjectProperty2;
                }
            }
        }
        if (oWLObjectProperty == null) {
            oWLObjectProperty = oWLModel.createOWLObjectProperty(null);
        }
        SWRLOWLUtil.addRDFSLabel(oWLObjectProperty, string2, string3);
        return oWLObjectProperty;
    }

    public static OWLDatatypeProperty createOWLDataPropertyUsingLabelAnnotation(OWLModel oWLModel, String string, String string2, String string3, boolean bl) throws SWRLOWLUtilException {
        OWLDatatypeProperty oWLDatatypeProperty = null;
        Collection collection = oWLModel.getMatchingResources(oWLModel.getRDFSLabelProperty(), "*" + string2, -1);
        if (!bl && collection != null && !collection.isEmpty()) {
            for (Object e : collection) {
                OWLDatatypeProperty oWLDatatypeProperty2;
                if (!(e instanceof OWLNamedClass) || !(oWLDatatypeProperty2 = (OWLDatatypeProperty)e).getNamespace().equals(string)) continue;
                for (Object e2 : oWLDatatypeProperty2.getPropertyValues(oWLModel.getRDFSLabelProperty())) {
                    Object object;
                    if (!(e2 instanceof String ? (string3 == null || string3.equals("")) & ((String)(object = (String)e2)).equalsIgnoreCase(string2) : e2 instanceof RDFSLiteral && (object = (RDFSLiteral)e2).getLanguage() == string3 && object.getString().equalsIgnoreCase(string2))) continue;
                    return oWLDatatypeProperty2;
                }
            }
        }
        if (oWLDatatypeProperty == null) {
            oWLDatatypeProperty = oWLModel.createOWLDatatypeProperty(null);
        }
        SWRLOWLUtil.addRDFSLabel(oWLDatatypeProperty, string2, string3);
        return oWLDatatypeProperty;
    }

    public static OWLIndividual createOWLIndividualWithRDFSLabel(OWLModel oWLModel, String string, String string2, String string3, boolean bl) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = null;
        Collection collection = oWLModel.getMatchingResources(oWLModel.getRDFSLabelProperty(), "*" + string2, -1);
        if (!bl && collection != null && !collection.isEmpty()) {
            for (Object e : collection) {
                OWLIndividual oWLIndividual2;
                if (!(e instanceof OWLNamedClass) || !(oWLIndividual2 = (OWLIndividual)e).getNamespace().equals(string)) continue;
                for (Object e2 : oWLIndividual2.getPropertyValues(oWLModel.getRDFSLabelProperty())) {
                    Object object;
                    if (e2 instanceof String) {
                        object = (String)e2;
                        if (string3 != null && !string3.equals("") || !((String)object).equalsIgnoreCase(string2)) continue;
                        return oWLIndividual2;
                    }
                    if (!(e2 instanceof RDFSLiteral) || (object = (RDFSLiteral)e2).getLanguage() != string3 || !object.getString().equalsIgnoreCase(string2)) continue;
                    return oWLIndividual2;
                }
            }
        }
        if (oWLIndividual == null) {
            oWLIndividual = SWRLOWLUtil.createOWLIndividual(oWLModel);
        }
        SWRLOWLUtil.addRDFSLabel(oWLIndividual, string2, string3);
        return oWLIndividual;
    }

    public static Set<OWLIndividual> getMatchingIndividuals(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, true);
        Collection collection = oWLModel.getMatchingResources(oWLProperty, string2, -1);
        HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
        for (Object e : collection) {
            if (!(e instanceof OWLIndividual)) continue;
            hashSet.add((OWLIndividual)e);
        }
        return hashSet;
    }

    public static Set<OWLIndividual> getMatchingIndividualsOfClass(OWLModel oWLModel, String string, String string2, String string3) throws SWRLOWLUtilException {
        HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
        for (OWLIndividual oWLIndividual : SWRLOWLUtil.getMatchingIndividuals(oWLModel, string2, string3)) {
            if (!SWRLOWLUtil.isOWLIndividualOfClass(oWLModel, oWLIndividual, string)) continue;
            hashSet.add(oWLIndividual);
        }
        return hashSet;
    }

    public static boolean isOWLNamedClass(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource instanceof OWLNamedClass;
    }

    public static boolean isOWLClass(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource != null && rDFResource instanceof OWLClass;
    }

    public static OWLNamedClass getOWLNamedClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = oWLModel.getOWLNamedClass(string);
        if (oWLNamedClass == null) {
            throw new SWRLOWLUtilException("unknown OWL named class " + string);
        }
        return oWLNamedClass;
    }

    public static OWLClass getOWLClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (rDFResource == null || !(rDFResource instanceof OWLClass)) {
            throw new SWRLOWLUtilException("invalid or unknown OWL class " + string);
        }
        return (OWLClass)rDFResource;
    }

    public static boolean isRDFResource(OWLModel oWLModel, String string) {
        return oWLModel.getRDFResource(string) != null;
    }

    public static RDFResource getRDFResource(OWLModel oWLModel, String string) {
        return oWLModel.getRDFResource(string);
    }

    public static RDFSClass getRDFSClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (rDFResource == null || !(rDFResource instanceof RDFSClass)) {
            throw new SWRLOWLUtilException("invalid or unknown RDFS class " + string);
        }
        return (RDFSClass)rDFResource;
    }

    public static OWLClass getOWLClassDescription(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (rDFResource == null || !(rDFResource instanceof OWLClass)) {
            throw new SWRLOWLUtilException("unknown OWL class description name " + string);
        }
        return (OWLClass)rDFResource;
    }

    public static OWLIndividual createIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.createIndividualOfClass(oWLModel, SWRLOWLUtil.getOWLThingClass(oWLModel), string);
    }

    public static OWLIndividual createOWLIndividual(OWLModel oWLModel) throws SWRLOWLUtilException {
        return (OWLIndividual)SWRLOWLUtil.getOWLThingClass(oWLModel).createInstance(null);
    }

    public static OWLIndividual createIndividualOfClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.createIndividualOfClass(oWLModel, string, null);
    }

    public static OWLIndividual createIndividualOfClass(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getNamedClass(oWLModel, string);
        return SWRLOWLUtil.createIndividualOfClass(oWLModel, oWLNamedClass, string2);
    }

    public static OWLIndividual createIndividualOfClass(OWLModel oWLModel, OWLClass oWLClass) throws SWRLOWLUtilException {
        return SWRLOWLUtil.createIndividualOfClass(oWLModel, oWLClass, null);
    }

    public static OWLIndividual createIndividualOfClass(OWLModel oWLModel, OWLClass oWLClass, String string) throws SWRLOWLUtilException {
        RDFResource rDFResource = null;
        OWLIndividual oWLIndividual = null;
        if (string != null) {
            rDFResource = oWLModel.getRDFResource(string);
        }
        if (rDFResource == null) {
            oWLIndividual = (OWLIndividual)oWLClass.createInstance(string);
            if (!oWLIndividual.hasRDFType(oWLClass, true)) {
                oWLIndividual.setRDFType(oWLClass);
            }
        } else if (rDFResource instanceof OWLIndividual) {
            oWLIndividual = (OWLIndividual)rDFResource;
            if (!oWLIndividual.hasRDFType(oWLClass, true)) {
                oWLIndividual.addRDFType(oWLClass);
            }
        } else {
            SWRLOWLUtil.throwException("could not create individual " + string + " because another resource of that name already exists");
        }
        return oWLIndividual;
    }

    public static OWLNamedClass getNamedClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLNamedClass(oWLModel, string, true);
    }

    public static OWLClass getClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLClass(oWLModel, string, true);
    }

    public static boolean isOWLIndividualOfClass(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource instanceof OWLNamedClass && oWLIndividual.hasRDFType((OWLNamedClass)rDFResource, true);
    }

    public static boolean isOWLIndividualOfType(OWLModel oWLModel, String string, String string2) {
        RDFResource rDFResource = oWLModel.getRDFResource(string2);
        RDFResource rDFResource2 = oWLModel.getRDFResource(string);
        return rDFResource instanceof OWLNamedClass && rDFResource2 instanceof OWLIndividual && rDFResource2.hasRDFType((OWLNamedClass)rDFResource, true);
    }

    public static boolean isOWLIndividualOfType(OWLModel oWLModel, String string, OWLNamedClass oWLNamedClass) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource instanceof OWLIndividual && rDFResource.hasRDFType(oWLNamedClass, true);
    }

    public static boolean isOWLIndividualOfDirectTypeOWLThing(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource instanceof OWLIndividual && rDFResource.hasRDFType(SWRLOWLUtil.getOWLThingClass(rDFResource.getOWLModel()), false);
    }

    public static void setType(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        OWLClass oWLClass = SWRLOWLUtil.getOWLClass(oWLModel, string2);
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string);
        if (!oWLIndividual.hasRDFType(oWLClass, true)) {
            oWLIndividual.setRDFType(oWLClass);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addObjectPropertyValue(OWLModel oWLModel, String string, String string2, String string3) throws SWRLOWLUtilException {
        RDFResource rDFResource = null;
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string2);
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else {
            if (!SWRLOWLUtil.isOWLClass(oWLModel, string)) throw new SWRLOWLUtilException("invalid or unknown subject name " + string + "; must be OWLClass or OWLIndividual");
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        }
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown subject name " + string);
        }
        if (oWLProperty == null) {
            SWRLOWLUtil.throwException("invalid or unknown property name " + string2);
        }
        if (string3 == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for subject " + string3);
        }
        if (!oWLProperty.isObjectProperty()) throw new SWRLOWLUtilException("invalid property value " + string3 + " for object property " + string2 + " for subject " + string + "; value must be a data property value");
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string3)) {
            OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string3);
            if (rDFResource.hasPropertyValue((RDFProperty)oWLProperty, oWLIndividual)) return;
            rDFResource.addPropertyValue(oWLProperty, oWLIndividual);
            return;
        } else {
            if (!SWRLOWLUtil.isOWLNamedClass(oWLModel, string3)) throw new SWRLOWLUtilException("invalid property value " + string3 + " for object property " + string2 + " for subject " + string + "; value must be class or individual");
            OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string3);
            if (rDFResource.hasPropertyValue((RDFProperty)oWLProperty, oWLNamedClass)) return;
            rDFResource.addPropertyValue(oWLProperty, oWLNamedClass);
        }
    }

    public static void addStringDataPropertyValue(OWLModel oWLModel, String string, String string2, String string3) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string2);
        RDFResource rDFResource = null;
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else if (SWRLOWLUtil.isOWLClass(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        }
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown subject name " + string);
        }
        if (oWLProperty == null) {
            SWRLOWLUtil.throwException("invalid or unknown property name " + string2);
        }
        if (string3 == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for subject " + string);
        }
        if (!rDFResource.hasPropertyValue((RDFProperty)oWLProperty, string3)) {
            rDFResource.addPropertyValue(oWLProperty, string3);
        }
    }

    public static void addDataPropertyValueWithLanguage(OWLModel oWLModel, String string, String string2, String string3, String string4) throws SWRLOWLUtilException {
        RDFResource rDFResource = null;
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string2);
        RDFSLiteral rDFSLiteral = oWLModel.createRDFSLiteral(string3, string4);
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else if (SWRLOWLUtil.isOWLClass(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        } else {
            throw new SWRLOWLUtilException("invalid or unknown subject name " + string + "; must be OWLClass or OWLIndividual");
        }
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown subject name " + string);
        }
        if (oWLProperty == null) {
            SWRLOWLUtil.throwException("invalid or unknown property name " + string2);
        }
        if (string3 == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for subject " + string);
        }
        if (!rDFResource.hasPropertyValue((RDFProperty)oWLProperty, rDFSLiteral)) {
            rDFResource.addPropertyValue(oWLProperty, rDFSLiteral);
        }
    }

    public static void addAnnotationObjectPropertyValue(OWLModel oWLModel, String string, String string2, String string3) throws SWRLOWLUtilException {
        RDFResource rDFResource = null;
        RDFProperty rDFProperty = SWRLOWLUtil.getRDFProperty(oWLModel, string2);
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else if (SWRLOWLUtil.isOWLClass(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        } else {
            throw new SWRLOWLUtilException("invalid or unknown subject name " + string + "; must be OWLClass or OWLIndividual");
        }
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown subject name " + string);
        }
        if (rDFProperty == null) {
            SWRLOWLUtil.throwException("invalid or unknown property name " + string2);
        }
        if (string3 == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for subject " + string);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string3)) {
            OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string3);
            if (!rDFResource.hasPropertyValue(rDFProperty, oWLIndividual)) {
                rDFResource.addPropertyValue(rDFProperty, oWLIndividual);
            }
        } else if (SWRLOWLUtil.isOWLNamedClass(oWLModel, string3)) {
            OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string3);
            if (!rDFResource.hasPropertyValue(rDFProperty, oWLNamedClass)) {
                rDFResource.addPropertyValue(rDFProperty, oWLNamedClass);
            }
        } else {
            throw new SWRLOWLUtilException("invalid object property value " + string3 + " for annotation property " + string2 + " for subject " + string + "; value must be class or individual");
        }
    }

    public static void addAnnotationPropertyValue(OWLModel oWLModel, String string, String string2, String string3) throws SWRLOWLUtilException {
        RDFResource rDFResource = null;
        RDFProperty rDFProperty = oWLModel.getRDFProperty(string2);
        if (rDFProperty == null) {
            throw new SWRLOWLUtilException("unknown annotation property " + string2);
        }
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else if (SWRLOWLUtil.isOWLClass(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        }
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown subject name " + string);
        }
        if (string3 == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for subject " + string);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string3)) {
            OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string3);
            if (!rDFResource.hasPropertyValue(rDFProperty, oWLIndividual)) {
                rDFResource.addPropertyValue(rDFProperty, oWLIndividual);
            }
        } else if (SWRLOWLUtil.isOWLNamedClass(oWLModel, string3)) {
            OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string3);
            if (!rDFResource.hasPropertyValue(rDFProperty, oWLNamedClass)) {
                rDFResource.addPropertyValue(rDFProperty, oWLNamedClass);
            }
        } else if (!rDFResource.hasPropertyValue(rDFProperty, string3)) {
            rDFResource.addPropertyValue(rDFProperty, string3);
        }
    }

    public static void addAnnotationStringDataPropertyValue(OWLModel oWLModel, String string, String string2, String string3) throws SWRLOWLUtilException {
        RDFResource rDFResource = null;
        RDFProperty rDFProperty = SWRLOWLUtil.getRDFProperty(oWLModel, string2);
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else if (SWRLOWLUtil.isOWLClass(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        }
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown subject name " + string);
        }
        if (rDFProperty == null) {
            SWRLOWLUtil.throwException("invalid or unknown property name " + string2);
        }
        if (string3 == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for subject " + string);
        }
        if (!rDFResource.hasPropertyValue(rDFProperty, string3)) {
            rDFResource.addPropertyValue(rDFProperty, string3);
        }
    }

    public static void addRDFSLabelPropertyValueWithLanguage(OWLModel oWLModel, String string, String string2, String string3) throws SWRLOWLUtilException {
        SWRLOWLUtil.addAnnotationDataPropertyValueWithLanguage(oWLModel, string, oWLModel.getRDFSLabelProperty().getURI(), string2, string3);
    }

    public static void addAnnotationDataPropertyValueWithLanguage(OWLModel oWLModel, String string, String string2, String string3, String string4) throws SWRLOWLUtilException {
        RDFResource rDFResource = null;
        RDFProperty rDFProperty = SWRLOWLUtil.getRDFProperty(oWLModel, string2);
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else if (SWRLOWLUtil.isOWLClass(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        } else {
            throw new SWRLOWLUtilException("invalid or unknown subject name " + string + "; must be OWLClass or OWLIndividual");
        }
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown subject name " + string);
        }
        if (rDFProperty == null) {
            SWRLOWLUtil.throwException("invalid or unknown property name " + string2);
        }
        if (string3 == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for subject " + string);
        }
        if (string4 == null || string4.equals("")) {
            String string5 = string3;
            if (!rDFResource.hasPropertyValue(rDFProperty, string5)) {
                rDFResource.addPropertyValue(rDFProperty, string5);
            }
        } else {
            RDFSLiteral rDFSLiteral = oWLModel.createRDFSLiteral(string3, string4);
            if (!rDFResource.hasPropertyValue(rDFProperty, rDFSLiteral)) {
                rDFResource.addPropertyValue(rDFProperty, rDFSLiteral);
            }
        }
    }

    public static void addDataPropertyValue(OWLModel oWLModel, String string, String string2, String string3, String string4) throws SWRLOWLUtilException {
        RDFResource rDFResource = null;
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string2);
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else if (SWRLOWLUtil.isOWLClass(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        } else {
            throw new SWRLOWLUtilException("invalid or unknown subject name " + string + "; must be OWLClass or OWLIndividual");
        }
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown subject name " + string);
        }
        if (oWLProperty == null) {
            SWRLOWLUtil.throwException("invalid or unknown property name " + string2);
        }
        if (string3 == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for subject " + string);
        }
        if (oWLProperty.isObjectProperty()) {
            throw new SWRLOWLUtilException("attempt to assign data property with value " + string3 + " and type " + string4 + " to annotation property " + string2 + " on individual " + string);
        }
        RDFSDatatype rDFSDatatype = SWRLOWLUtil.getRDFSDatatype(oWLModel, string4);
        if (rDFSDatatype == null) {
            throw new SWRLOWLUtilException("invalid datatype name " + string4);
        }
        RDFSLiteral rDFSLiteral = oWLModel.createRDFSLiteral(string3, rDFSDatatype);
        if (rDFSLiteral.getPlainValue() == null) {
            if (!rDFResource.hasPropertyValue((RDFProperty)oWLProperty, rDFSLiteral)) {
                rDFResource.addPropertyValue(oWLProperty, rDFSLiteral);
            }
        } else if (!rDFResource.hasPropertyValue((RDFProperty)oWLProperty, rDFSLiteral.getPlainValue())) {
            rDFResource.addPropertyValue(oWLProperty, rDFSLiteral.getPlainValue());
        }
    }

    public static void addAnnotationDataPropertyValue(OWLModel oWLModel, String string, String string2, String string3, String string4) throws SWRLOWLUtilException {
        RDFSDatatype rDFSDatatype;
        RDFResource rDFResource = null;
        RDFProperty rDFProperty = SWRLOWLUtil.getRDFProperty(oWLModel, string2);
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else if (SWRLOWLUtil.isOWLClass(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        } else {
            throw new SWRLOWLUtilException("invalid or unknown subject name " + string + "; must be OWLClass or OWLIndividual");
        }
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown subject name " + string);
        }
        if (rDFProperty == null) {
            SWRLOWLUtil.throwException("invalid or unknown property name " + string2);
        }
        if (string3 == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for subject " + string);
        }
        if ((rDFSDatatype = SWRLOWLUtil.getRDFSDatatype(oWLModel, string4)) == null) {
            throw new SWRLOWLUtilException("invalid datatype name " + string4);
        }
        RDFSLiteral rDFSLiteral = oWLModel.createRDFSLiteral(string3, rDFSDatatype);
        if (rDFSLiteral.getPlainValue() == null) {
            if (!rDFResource.hasPropertyValue(rDFProperty, rDFSLiteral)) {
                rDFResource.addPropertyValue(rDFProperty, rDFSLiteral);
            }
        } else if (!rDFResource.hasPropertyValue(rDFProperty, rDFSLiteral.getPlainValue())) {
            rDFResource.addPropertyValue(rDFProperty, rDFSLiteral.getPlainValue());
        }
    }

    public static void addType(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        OWLClass oWLClass = SWRLOWLUtil.getOWLClass(oWLModel, string2);
        RDFResource rDFResource = null;
        if (oWLClass == null) {
            throw new SWRLOWLUtilException("could not find class: " + string2);
        }
        if (SWRLOWLUtil.isOWLIndividual(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        } else if (SWRLOWLUtil.isOWLClass(oWLModel, string)) {
            rDFResource = SWRLOWLUtil.getOWLClass(oWLModel, string);
        } else {
            throw new SWRLOWLUtilException("invalid or unknown resource name " + string + "; must be name ow OWL class or individual");
        }
        if (!rDFResource.hasProtegeType(oWLClass, true)) {
            rDFResource.addProtegeType(oWLClass);
        }
    }

    public static void addType(OWLIndividual oWLIndividual, OWLClass oWLClass) throws SWRLOWLUtilException {
        if (!oWLIndividual.hasRDFType(oWLClass, true)) {
            oWLIndividual.addRDFType(oWLClass);
        }
    }

    public static void removeType(OWLIndividual oWLIndividual, OWLClass oWLClass) throws SWRLOWLUtilException {
        if (oWLIndividual.hasRDFType(oWLClass, true)) {
            oWLIndividual.removeRDFType(oWLClass);
        }
    }

    public static String getFullName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        String string2 = OWLUtil.getInternalFullName(oWLModel, string, true);
        if (string2 == null) {
            throw new SWRLOWLUtilException("cannot get full name for resource " + string);
        }
        return string2;
    }

    public static Set<String> getRDFSLabels(OWLModel oWLModel, String string) {
        return SWRLOWLUtil.getRDFSLabels(oWLModel, string, "");
    }

    public static Set<String> getRDFSLabels(OWLModel oWLModel, String string, String string2) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        HashSet<String> hashSet = new HashSet<String>();
        if (rDFResource != null) {
            for (Object e : rDFResource.getPropertyValues(oWLModel.getRDFSLabelProperty())) {
                if (e instanceof String) {
                    hashSet.add((String)e);
                    continue;
                }
                if (!(e instanceof RDFSLiteral)) continue;
                RDFSLiteral rDFSLiteral = (RDFSLiteral)e;
                if (!string2.equals("") && !string2.equals(rDFSLiteral.getLanguage())) continue;
                hashSet.add(rDFSLiteral.getString());
            }
        }
        return hashSet;
    }

    public static Set<String> getRDFSLabelLanguages(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        HashSet<String> hashSet = new HashSet<String>();
        if (rDFResource != null) {
            for (Object e : rDFResource.getPropertyValues(oWLModel.getRDFSLabelProperty())) {
                if (!(e instanceof RDFSLiteral)) continue;
                RDFSLiteral rDFSLiteral = (RDFSLiteral)e;
                hashSet.add(rDFSLiteral.getLanguage());
            }
        }
        return hashSet;
    }

    public static void addRDFSLabel(RDFResource rDFResource, String string, String string2) {
        if (!SWRLOWLUtil.hasRDFSLabel(rDFResource, string, string2)) {
            rDFResource.addLabel(string, string2);
        }
    }

    public static boolean hasRDFSLabel(RDFResource rDFResource, String string, String string2) {
        for (Object e : rDFResource.getLabels()) {
            Object object;
            if (e instanceof String) {
                object = (String)e;
                if (string2 != null && !string2.equals("") || !((String)object).equals(string)) continue;
                return true;
            }
            if (!(e instanceof RDFSLiteral) || !(object = (RDFSLiteral)e).getString().equals(string) || !object.getLanguage().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRDFSLabelIgnoringLanguage(OWLModel oWLModel, RDFResource rDFResource, String string) {
        for (Object e : rDFResource.getLabels()) {
            Object object;
            if (!(e instanceof String ? ((String)(object = (String)e)).equals(string) : e instanceof RDFSLiteral && (object = (RDFSLiteral)e).getString().equals(string))) continue;
            return true;
        }
        return false;
    }

    public static OWLSomeValuesFrom getOWLSomeValuesFrom(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return (OWLSomeValuesFrom)oWLModel.getOWLSomeValuesFromRestrictionClass().createInstance(string);
    }

    public static OWLIndividual getOWLIndividual(OWLModel oWLModel, OWLNamedClass oWLNamedClass, boolean bl, int n) throws SWRLOWLUtilException {
        if (bl && oWLNamedClass.getInstanceCount(true) == 0) {
            SWRLOWLUtil.throwException("no individuals of class " + oWLNamedClass.getPrefixedName() + " in ontology");
        } else if (oWLNamedClass.getInstanceCount(true) != n) {
            SWRLOWLUtil.throwException("expecting exactly " + n + " individuals of class " + oWLNamedClass.getPrefixedName() + " in ontology - got " + oWLNamedClass.getInstanceCount(true) + "");
        }
        Collection collection = oWLNamedClass.getInstances(true);
        if (!collection.isEmpty()) {
            Object e = oWLNamedClass.getInstances(true).iterator().next();
            if (e instanceof OWLIndividual) {
                return (OWLIndividual)e;
            }
            throw new SWRLOWLUtilException("instance of class " + oWLNamedClass.getPrefixedName() + " is not an OWL individual");
        }
        return null;
    }

    public static Set<OWLIndividual> getAllOWLIndividuals(OWLModel oWLModel) throws SWRLOWLUtilException {
        HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
        for (Object e : oWLModel.getOWLIndividuals()) {
            if (!(e instanceof OWLIndividual)) continue;
            hashSet.add((OWLIndividual)e);
        }
        return hashSet;
    }

    public static Set<OWLIndividual> getOWLIndividualsOfClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getNamedClass(oWLModel, string);
        return new HashSet<OWLIndividual>(SWRLOWLUtil.getOWLIndividualsOfClass(oWLNamedClass));
    }

    public static Set<OWLIndividual> getOWLIndividualsOfClass(OWLNamedClass oWLNamedClass) throws SWRLOWLUtilException {
        HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
        for (Object e : oWLNamedClass.getInstances(true)) {
            if (!(e instanceof OWLIndividual)) continue;
            hashSet.add((OWLIndividual)e);
        }
        return hashSet;
    }

    public static OWLProperty getProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLProperty(oWLModel, string, true);
    }

    public static OWLDatatypeProperty getOWLDataProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDataProperty(oWLModel, string, true);
    }

    public static OWLDatatypeProperty getOWLDataProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLDatatypeProperty oWLDatatypeProperty = oWLModel.getOWLDatatypeProperty(string);
        if (bl && oWLDatatypeProperty == null) {
            SWRLOWLUtil.throwException("no " + string + " datatype property in ontology");
        }
        return oWLDatatypeProperty;
    }

    public static OWLObjectProperty getOWLObjectProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLObjectProperty oWLObjectProperty = oWLModel.getOWLObjectProperty(string);
        if (bl && oWLObjectProperty == null) {
            SWRLOWLUtil.throwException("no " + string + " object property in ontology");
        }
        return oWLObjectProperty;
    }

    public static boolean isOWLEquivalentProperty(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getOWLProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty.getEquivalentProperties().contains(oWLProperty2);
    }

    public static boolean isOWLEquivalentClass(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass.hasEquivalentClass(oWLNamedClass2);
    }

    public static boolean isOWLDisjointClass(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass.getDisjointClasses().contains(oWLNamedClass2);
    }

    public static boolean isOWLSubPropertyOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getOWLProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty.isSubpropertyOf(oWLProperty2, true);
    }

    public static boolean isOWLSuperPropertyOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getOWLProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty2.isSubpropertyOf(oWLProperty, true);
    }

    public static boolean isOWLDirectSuperPropertyOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getOWLProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty2.isSubpropertyOf(oWLProperty, false);
    }

    public static boolean isOWLDirectSubPropertyOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getOWLProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty.isSubpropertyOf(oWLProperty2, false);
    }

    public static boolean isOWLDirectSubClassOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass.isSubclassOf(oWLNamedClass2);
    }

    public static boolean isOWLSubClassOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass2.getSubclasses(true).contains(oWLNamedClass);
    }

    public static void addOWLSuperClass(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        OWLClass oWLClass = SWRLOWLUtil.getOWLClass(oWLModel, string);
        OWLClass oWLClass2 = SWRLOWLUtil.getOWLClass(oWLModel, string2);
        oWLClass.addSuperclass(oWLClass2);
    }

    public static void addOWLSuperClass(OWLClass oWLClass, OWLClass oWLClass2) {
        oWLClass.addSuperclass(oWLClass2);
    }

    public static void addRDFSSuperClass(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
        rDFSClass.addSuperclass(rDFSClass2);
    }

    public static boolean isOWLDirectSuperClassOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass2.isSubclassOf(oWLNamedClass);
    }

    public static boolean isOWLSuperClassOf(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.isOWLSuperClassOf(oWLModel, string, string2, true);
    }

    public static boolean isOWLSuperClassOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass2.getSuperclasses(true).contains(oWLNamedClass);
    }

    public static int getNumberOfOWLIndividualsOfClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getNumberOfOWLIndividualsOfClass(oWLModel, string, true);
    }

    public static int getNumberOfOWLIndividualsOfClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl);
        int n = 0;
        if (oWLNamedClass != null) {
            n = oWLNamedClass.getInstances(true).size();
        }
        return n;
    }

    public static int getNumberOfDirectOWLInstancesOfClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl);
        int n = 0;
        if (oWLNamedClass != null) {
            n = oWLNamedClass.getInstances(false).size();
        }
        return n;
    }

    public static boolean isConsistentOWLClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl);
        return oWLNamedClass != null && oWLNamedClass.isConsistent();
    }

    public static Set<OWLNamedClass> getOWLDomainClasses(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDomainClasses(oWLModel, string, true, true);
    }

    public static Set<OWLNamedClass> getOWLDomainClasses(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDomainClasses(oWLModel, string, bl, true);
    }

    public static Set<OWLNamedClass> getDirectOWLDomainClasses(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDomainClasses(oWLModel, string, true, false);
    }

    public static Set<OWLNamedClass> getDirectOWLDomainClasses(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDomainClasses(oWLModel, string, bl, false);
    }

    private static Set<OWLNamedClass> getOWLDomainClasses(OWLModel oWLModel, String string, boolean bl, boolean bl2) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
        Collection collection = oWLProperty.getUnionDomain(bl2);
        if (collection == null) {
            return hashSet;
        }
        for (Object e : collection) {
            if (!(e instanceof OWLNamedClass)) continue;
            hashSet.add((OWLNamedClass)e);
        }
        return hashSet;
    }

    public static void removeOWLThingSuperclass(OWLModel oWLModel, OWLClass oWLClass) {
        if (oWLClass.getSuperclasses(false).contains(SWRLOWLUtil.getOWLThingClass(oWLModel))) {
            oWLClass.removeSuperclass(SWRLOWLUtil.getOWLThingClass(oWLModel));
        }
    }

    public static Set<OWLNamedClass> getOWLRangeClasses(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLRangeClasses(oWLModel, string, bl, true);
    }

    public static Set<OWLNamedClass> getOWLRangeClasses(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLRangeClasses(oWLModel, string, true, true);
    }

    public static Set<OWLNamedClass> getOWLDirectRangeClasses(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLRangeClasses(oWLModel, string, bl, false);
    }

    public static Set<OWLNamedClass> getOWLDirectRangeClasses(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLRangeClasses(oWLModel, string, true, false);
    }

    private static Set<OWLNamedClass> getOWLRangeClasses(OWLModel oWLModel, String string, boolean bl, boolean bl2) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
        Collection collection = oWLProperty.getUnionRangeClasses();
        if (collection == null) {
            return hashSet;
        }
        for (RDFResource rDFResource : collection) {
            if (!(rDFResource instanceof OWLNamedClass)) continue;
            hashSet.add((OWLNamedClass)rDFResource);
        }
        return hashSet;
    }

    public static boolean isInOWLPropertyDomain(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLProperty != null && oWLNamedClass != null && oWLProperty.getDomains(true).contains(oWLNamedClass);
    }

    public static boolean isInDirectOWLPropertyDomain(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLProperty != null && oWLNamedClass != null && oWLProperty.getDomains(false).contains(oWLNamedClass);
    }

    public static boolean isInPropertyRange(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLProperty != null && oWLNamedClass != null && oWLProperty.getRanges(true).contains(oWLNamedClass);
    }

    public static boolean isInDirectPropertyRange(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2, bl);
        return oWLProperty != null && oWLNamedClass != null && oWLProperty.getRanges(false).contains(oWLNamedClass);
    }

    public static boolean isOWLObjectProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty.isObjectProperty();
    }

    public static boolean isOWLIndividual(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource != null && rDFResource instanceof OWLIndividual;
    }

    public static boolean isOWLObjectProperty(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource instanceof OWLObjectProperty;
    }

    public static boolean isOWLDataProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        return oWLProperty != null && !oWLProperty.isObjectProperty();
    }

    public static boolean hasXSDStringRange(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        if (SWRLOWLUtil.isOWLDataProperty(oWLModel, string)) {
            OWLDatatypeProperty oWLDatatypeProperty = SWRLOWLUtil.getOWLDataProperty(oWLModel, string);
            return oWLDatatypeProperty.getRange() == oWLModel.getXSDstring();
        }
        return false;
    }

    public static boolean isOWLDataProperty(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource instanceof OWLDatatypeProperty;
    }

    public static boolean isOWLTransitiveProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty instanceof OWLObjectProperty && ((OWLObjectProperty)oWLProperty).isTransitive();
    }

    public static boolean isOWLTransitiveProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.isOWLTransitiveProperty(oWLModel, string, true);
    }

    public static boolean isOWLSymmetricProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty instanceof OWLObjectProperty && ((OWLObjectProperty)oWLProperty).isSymmetric();
    }

    public static boolean isOWLFunctionalProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty.isFunctional();
    }

    public static boolean isAnnotationProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty.isAnnotationProperty();
    }

    public static boolean isAnnotationProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, true);
        return oWLProperty != null && oWLProperty.isAnnotationProperty();
    }

    public static boolean isInverseFunctionalProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty.isInverseFunctional();
    }

    public static boolean isAnonymousResourceName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return oWLModel.isAnonymousResourceName(string);
    }

    public static OWLIndividual getIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLIndividual(oWLModel, string, true);
    }

    public static OWLIndividual getOWLIndividual(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (bl && (rDFResource == null || !(rDFResource instanceof OWLIndividual))) {
            SWRLOWLUtil.throwException("no individual named " + string + " in ontology");
        }
        if (rDFResource != null) {
            if (rDFResource instanceof OWLIndividual) {
                return (OWLIndividual)rDFResource;
            }
            return null;
        }
        return null;
    }

    public static OWLNamedClass getOWLNamedClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (bl && (rDFResource == null || !(rDFResource instanceof OWLNamedClass))) {
            SWRLOWLUtil.throwException("no class named " + string + " in ontology");
        }
        if (rDFResource != null) {
            if (rDFResource instanceof OWLNamedClass) {
                return (OWLNamedClass)rDFResource;
            }
            return null;
        }
        return null;
    }

    public static OWLClass getOWLClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (bl && (rDFResource == null || !(rDFResource instanceof OWLClass))) {
            SWRLOWLUtil.throwException("no class named " + string + " in ontology");
        }
        if (rDFResource != null) {
            if (rDFResource instanceof OWLClass) {
                return (OWLClass)rDFResource;
            }
            return null;
        }
        return null;
    }

    public static Set<OWLNamedClass> getOWLClassesOfIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLClassesOfIndividual(oWLModel, string, true);
    }

    public static Set<OWLNamedClass> getOWLClassesOfIndividual(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string, bl);
        return oWLIndividual == null ? new HashSet() : SWRLOWLUtil.getClassesOfIndividual(oWLModel, oWLIndividual);
    }

    public static Set<OWLNamedClass> getClassesOfIndividual(OWLModel oWLModel, OWLIndividual oWLIndividual) throws SWRLOWLUtilException {
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
        Collection collection = oWLIndividual.getRDFTypes();
        for (RDFResource rDFResource : collection) {
            if (!(rDFResource instanceof OWLNamedClass)) continue;
            hashSet.add((OWLNamedClass)rDFResource);
        }
        return hashSet;
    }

    public static String getNextAnonymousResourceName(OWLModel oWLModel) {
        return oWLModel.getNextAnonymousResourceName();
    }

    public static boolean isOWLNamedEntity(OWLModel oWLModel, String string) {
        return SWRLOWLUtil.isOWLNamedClass(oWLModel, string) || SWRLOWLUtil.isOWLProperty(oWLModel, string) || SWRLOWLUtil.isOWLIndividual(oWLModel, string);
    }

    public static boolean isOWLNamedClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLNamedClass(oWLModel, string, bl) != null;
    }

    public static boolean isOWLProperty(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource instanceof OWLProperty;
    }

    public static boolean isOWLProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLProperty(oWLModel, string, bl) != null;
    }

    public static Collection<OWLNamedClass> getUserDefinedOWLNamedClasses(OWLModel oWLModel) {
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
        for (Object e : oWLModel.getUserDefinedOWLNamedClasses()) {
            if (!(e instanceof OWLNamedClass)) continue;
            hashSet.add((OWLNamedClass)e);
        }
        return hashSet;
    }

    public static Collection<OWLProperty> getUserDefinedOWLProperties(OWLModel oWLModel) {
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        for (Object e : oWLModel.getUserDefinedOWLProperties()) {
            if (!(e instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)e);
        }
        return hashSet;
    }

    public static Collection<OWLProperty> getUserDefinedOWLObjectProperties(OWLModel oWLModel) {
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        for (Object e : oWLModel.getUserDefinedOWLObjectProperties()) {
            if (!(e instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)e);
        }
        return hashSet;
    }

    public static Collection<OWLProperty> getUserDefinedOWLDatatypeProperties(OWLModel oWLModel) {
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        for (Object e : oWLModel.getUserDefinedOWLDatatypeProperties()) {
            if (!(e instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)e);
        }
        return hashSet;
    }

    public static boolean isIndividual(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLIndividual(oWLModel, string, bl) != null;
    }

    public static boolean isSWRLVariable(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLIndividual(oWLModel, string, bl) != null && SWRLOWLUtil.getOWLIndividual(oWLModel, string, bl) instanceof SWRLVariable;
    }

    public static boolean isIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLIndividual(oWLModel, string, false) != null;
    }

    public static int getNumberOfPropertyValues(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string2, bl);
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string, bl);
        return oWLIndividual.getPropertyValues(oWLProperty).size();
    }

    public static Set<OWLProperty> getOWLPropertiesOfIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string, true);
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        Collection collection = oWLIndividual.getRDFProperties();
        for (RDFProperty rDFProperty : collection) {
            if (!(rDFProperty instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)rDFProperty);
        }
        return hashSet;
    }

    public static Set<OWLProperty> getPossibleOWLPropertiesOfIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string, true);
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        Collection collection = oWLIndividual.getPossibleRDFProperties();
        for (RDFProperty rDFProperty : collection) {
            if (!(rDFProperty instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)rDFProperty);
        }
        return hashSet;
    }

    public static String getURI(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown resource " + string);
        }
        return rDFResource.getURI();
    }

    public static int getNumberOfOWLPropertyValues(OWLModel oWLModel, String string, String string2, Object object, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string2, bl);
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string, bl);
        int n = 0;
        if (object == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for OWL individual " + string);
        }
        for (Object e : oWLIndividual.getPropertyValues(oWLProperty)) {
            if (e instanceof RDFResource) {
                RDFResource rDFResource = (RDFResource)e;
                String string3 = rDFResource.getName();
                if (!string3.equals(object)) continue;
                ++n;
                continue;
            }
            if (!e.equals(object)) continue;
            ++n;
        }
        return n;
    }

    public static void addOWLPropertyValue(OWLModel oWLModel, String string, String string2, Object object) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = oWLModel.getOWLProperty(string2);
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid or unknown resource name " + string);
        }
        if (oWLProperty == null) {
            SWRLOWLUtil.throwException("no " + string2 + " property in ontology");
        }
        if (object == null) {
            SWRLOWLUtil.throwException("null value for property " + string2 + " for RDF resource " + rDFResource.getPrefixedName());
        }
        if (!rDFResource.hasPropertyValue((RDFProperty)oWLProperty, object)) {
            rDFResource.addPropertyValue(oWLProperty, object);
        }
    }

    public static void addOWLPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, Object object) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = oWLModel.getOWLProperty(string);
        if (oWLIndividual == null) {
            SWRLOWLUtil.throwException("null individual name");
        }
        if (oWLProperty == null) {
            SWRLOWLUtil.throwException("no " + string + " property in ontology");
        }
        if (object == null) {
            SWRLOWLUtil.throwException("null value for property " + string + " for OWL individual " + oWLIndividual.getPrefixedName());
        }
        if (!oWLIndividual.hasPropertyValue((RDFProperty)oWLProperty, object)) {
            oWLIndividual.addPropertyValue(oWLProperty, object);
        }
    }

    public static void addPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, OWLProperty oWLProperty, Object object) throws SWRLOWLUtilException {
        if (oWLIndividual == null) {
            SWRLOWLUtil.throwException("null individual name");
        }
        if (oWLProperty == null) {
            SWRLOWLUtil.throwException("null property for individual " + oWLIndividual.getPrefixedName());
        }
        if (object == null) {
            SWRLOWLUtil.throwException("null value for property " + oWLProperty.getPrefixedName() + " for OWL individual " + oWLIndividual.getPrefixedName());
        }
        if (!oWLIndividual.hasPropertyValue((RDFProperty)oWLProperty, object)) {
            oWLIndividual.addPropertyValue(oWLProperty, object);
        }
    }

    public static RDFResource getObjectPropertyValue(OWLIndividual oWLIndividual, OWLProperty oWLProperty) throws SWRLOWLUtilException {
        Object object = oWLIndividual.getPropertyValue(oWLProperty);
        if (!(object instanceof RDFResource)) {
            throw new SWRLOWLUtilException("value " + object + " of object property " + oWLProperty.getPrefixedName() + " associated with individual " + oWLIndividual.getPrefixedName() + " is not a valid object value");
        }
        return (RDFResource)object;
    }

    public static Set<RDFResource> getObjectPropertyValues(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValues(oWLModel, string, string2, true);
    }

    public static Set<RDFResource> getObjectPropertyValues(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValues(oWLModel, oWLIndividual.getName(), string, true);
    }

    public static Set<OWLIndividual> getOWLObjectPropertyIndividualValues(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, String string2) throws SWRLOWLUtilException {
        HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
        for (RDFResource rDFResource : SWRLOWLUtil.getObjectPropertyValues(oWLModel, oWLIndividual, string)) {
            if (!(rDFResource instanceof OWLIndividual)) {
                throw new SWRLOWLUtilException("value " + rDFResource + " for property " + string + " associated with individual " + oWLIndividual.getPrefixedName() + " is not an OWL individual");
            }
            OWLIndividual oWLIndividual2 = (OWLIndividual)rDFResource;
            if (!SWRLOWLUtil.isOWLIndividualOfClass(oWLModel, oWLIndividual2, string2)) {
                throw new SWRLOWLUtilException("object " + oWLIndividual.getPrefixedName() + " value for property " + string + " associated with individual " + oWLIndividual.getPrefixedName() + " is not of type " + string2);
            }
            hashSet.add(oWLIndividual2);
        }
        return hashSet;
    }

    public static OWLIndividual getOWLObjectPropertyIndividualValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, String string2) throws SWRLOWLUtilException {
        RDFResource rDFResource = SWRLOWLUtil.getObjectPropertyValue(oWLModel, oWLIndividual, string);
        if (!(rDFResource instanceof OWLIndividual)) {
            throw new SWRLOWLUtilException("invalid value for " + string + " property associated with individual " + oWLIndividual.getPrefixedName() + "; found " + rDFResource + ", expecting individual");
        }
        OWLIndividual oWLIndividual2 = (OWLIndividual)rDFResource;
        if (!SWRLOWLUtil.isOWLIndividualOfClass(oWLModel, oWLIndividual2, string2)) {
            throw new SWRLOWLUtilException("object " + oWLIndividual2.getPrefixedName() + " value for property " + string + " associated with individual " + oWLIndividual.getPrefixedName() + " is not of type " + string2);
        }
        return oWLIndividual2;
    }

    public static OWLProperty getOWLObjectPropertyPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        RDFResource rDFResource = SWRLOWLUtil.getObjectPropertyValue(oWLModel, oWLIndividual, string);
        if (!(rDFResource instanceof OWLProperty)) {
            throw new SWRLOWLUtilException("invalid type for " + string + " property associated with individual " + oWLIndividual.getPrefixedName() + "; found " + rDFResource + ", expecting property");
        }
        return (OWLProperty)rDFResource;
    }

    public static Set<RDFResource> getObjectPropertyValues(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValues(oWLModel, oWLIndividual.getName(), string, bl);
    }

    public static Set<RDFResource> getObjectPropertyValues(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string, bl);
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string2, bl);
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        if (oWLIndividual != null && oWLProperty != null) {
            for (Object e : oWLIndividual.getPropertyValues(oWLProperty)) {
                if (!(e instanceof RDFResource)) continue;
                hashSet.add((RDFResource)e);
            }
        }
        return hashSet;
    }

    public static RDFResource getObjectPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValue(oWLModel, oWLIndividual, string, true);
    }

    public static RDFResource getObjectPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValue(oWLModel, oWLIndividual.getName(), string, bl);
    }

    public static RDFResource getObjectPropertyValue(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValue(oWLModel, string, string2, true);
    }

    public static RDFResource getObjectPropertyValue(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        Object object;
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string, bl);
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string2, true);
        Object object2 = object = oWLProperty == null && oWLIndividual == null ? null : oWLIndividual.getPropertyValue(oWLProperty);
        if (bl && oWLProperty == null) {
            SWRLOWLUtil.throwException("no property " + string2 + " associated with individual " + oWLIndividual.getPrefixedName());
        }
        if (!(object instanceof RDFResource)) {
            throw new SWRLOWLUtilException("value " + object + " of object property " + string2 + " associated with individual " + oWLIndividual.getPrefixedName() + " is not a valid object value");
        }
        return (RDFResource)object;
    }

    public static Object getDatavaluedPropertyValue(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, string, string2, true);
    }

    public static Object getDatavaluedPropertyValue(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        Object object;
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string, bl);
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string2, bl);
        Object object2 = object = oWLIndividual == null || oWLProperty == null ? null : oWLIndividual.getPropertyValue(oWLProperty);
        if (bl && object == null) {
            SWRLOWLUtil.throwException("no property " + string2 + " associated with individual '" + string + "'");
        }
        return object;
    }

    public static Object getDatavaluedPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual.getName(), string, bl);
    }

    public static Object getDatavaluedPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, OWLProperty oWLProperty, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual.getName(), oWLProperty.getName(), bl);
    }

    public static Set<Object> getDatavaluedPropertyValues(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, true);
        Collection collection = oWLProperty == null ? null : oWLIndividual.getPropertyValues(oWLProperty);
        HashSet<Object> hashSet = new HashSet<Object>();
        if (oWLProperty.isObjectProperty()) {
            SWRLOWLUtil.throwException("expecting datatype property " + string + " for " + oWLIndividual.getPrefixedName());
        }
        if (bl && collection == null) {
            SWRLOWLUtil.throwException("no property '" + string + "' associated with individual '" + oWLIndividual.getPrefixedName() + "'");
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        return hashSet;
    }

    public static Set<Object> getDatavaluedPropertyValues(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string);
        return SWRLOWLUtil.getDatavaluedPropertyValues(oWLModel, oWLIndividual, string2, bl);
    }

    public static Set<Object> getDatavaluedPropertyValues(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValues(oWLModel, string, string2, true);
    }

    public static int getOWLDatavaluedPropertyValueAsInteger(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, string, bl);
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SWRLOWLUtil.throwException("cannot convert property value '" + string2 + "' of property '" + string + "' associated with individual '" + oWLIndividual.getPrefixedName() + "' to integer");
        }
        return n;
    }

    public static int getDatavaluedPropertyValueAsInteger(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDatavaluedPropertyValueAsInteger(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl);
    }

    public static int getOWLDatavaluedPropertyValueAsInteger(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDatavaluedPropertyValueAsInteger(oWLModel, oWLIndividual, string, true);
    }

    public static int getDatavaluedPropertyValueAsInteger(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDatavaluedPropertyValueAsInteger(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static long getOWLDatavaluedPropertyValueAsLong(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, string, bl);
        long l = -1L;
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SWRLOWLUtilException("cannot convert property value '" + string2 + "' of property '" + string + "' associated with individual '" + oWLIndividual.getPrefixedName() + "' to long");
        }
        return l;
    }

    public static long getDatavaluedPropertyValueAsLong(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDatavaluedPropertyValueAsLong(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl);
    }

    public static long getDatavaluedPropertyValueAsLong(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDatavaluedPropertyValueAsLong(oWLModel, oWLIndividual, string, true);
    }

    public static long getDatavaluedPropertyValueAsLong(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getOWLDatavaluedPropertyValueAsLong(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, string, true);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        if (oWLProperty == null) {
            return null;
        }
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, oWLProperty, bl);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, String string, String string2, boolean bl, String string3) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl, string3);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl, String string2) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string, bl);
        if (oWLProperty == null) {
            return string2;
        }
        String string3 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, oWLProperty, bl);
        return string3 == null ? string2 : string3;
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, OWLIndividual oWLIndividual, OWLProperty oWLProperty, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, oWLProperty, bl);
        String string = null;
        if (object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            string = bl2 != false ? "true" : "false";
        }
        string = object == null ? null : object.toString();
        return string;
    }

    public static Boolean getDatavaluedPropertyValueAsBoolean(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsBoolean(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl);
    }

    public static Boolean getDatavaluedPropertyValueAsBoolean(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsBoolean(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static Boolean getDatavaluedPropertyValueAsBoolean(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, string, bl);
        if (object == null) {
            return null;
        }
        if (!(object instanceof Boolean)) {
            SWRLOWLUtil.throwException("property value for '" + string + "' associated with individual '" + oWLIndividual.getPrefixedName() + "' is not a Boolean");
        }
        return (Boolean)object;
    }

    public static Boolean getDatavaluedPropertyValueAsBoolean(OWLModel oWLModel, OWLIndividual oWLIndividual, OWLProperty oWLProperty, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, oWLProperty, bl);
        if (object == null) {
            return null;
        }
        if (!(object instanceof Boolean)) {
            SWRLOWLUtil.throwException("property value for " + oWLProperty.getPrefixedName() + " in individual " + oWLIndividual.getPrefixedName() + " is not a Boolean");
        }
        return (Boolean)object;
    }

    public static Collection<?> getDatavaluedPropertyValueAsCollection(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsCollection(oWLModel, oWLIndividual, string, true);
    }

    public static Collection<?> getDatavaluedPropertyValueAsCollection(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsCollection(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static Collection<?> getDatavaluedPropertyValueAsCollection(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, string, bl);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object == null) {
            return arrayList;
        }
        if (object instanceof RDFSLiteral) {
            arrayList.add(object);
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                arrayList.add(e);
            }
        } else {
            SWRLOWLUtil.throwException("property value for " + string + " associated with individual " + oWLIndividual.getPrefixedName() + " is not a Collection or a literal");
        }
        return arrayList;
    }

    public static Collection<?> getDatavaluedPropertyValueAsCollection(OWLModel oWLModel, OWLIndividual oWLIndividual, OWLProperty oWLProperty, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, oWLProperty, bl);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object == null) {
            return arrayList;
        }
        if (object instanceof RDFSLiteral) {
            arrayList.add(object);
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                arrayList.add(e);
            }
        } else {
            SWRLOWLUtil.throwException("value for property " + oWLProperty.getPrefixedName() + " associated with individual " + oWLIndividual.getPrefixedName() + " is not a Collection or a literal");
        }
        return arrayList;
    }

    public static List<OWLNamedClass> getDirectSubClassesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getNamedClass(oWLModel, string);
        return SWRLOWLUtil.getDirectSubClassesOf(oWLModel, oWLNamedClass);
    }

    public static List<OWLNamedClass> getSubClassesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getNamedClass(oWLModel, string);
        return SWRLOWLUtil.getSubClassesOf(oWLModel, oWLNamedClass);
    }

    public static List<OWLNamedClass> getDirectSuperClassesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getNamedClass(oWLModel, string);
        return SWRLOWLUtil.getDirectSuperClassesOf(oWLModel, oWLNamedClass);
    }

    public static List<OWLNamedClass> getSuperClassesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getNamedClass(oWLModel, string);
        return SWRLOWLUtil.getSuperClassesOf(oWLModel, oWLNamedClass);
    }

    public static List<OWLNamedClass> getSubClassesOf(OWLModel oWLModel, OWLNamedClass oWLNamedClass) {
        ArrayList<OWLNamedClass> arrayList = new ArrayList<OWLNamedClass>();
        for (Object e : oWLNamedClass.getSubclasses(true)) {
            if (!(e instanceof OWLNamedClass)) continue;
            arrayList.add((OWLNamedClass)e);
        }
        return arrayList;
    }

    public static List<OWLNamedClass> getDirectSubClassesOf(OWLModel oWLModel, OWLNamedClass oWLNamedClass) {
        ArrayList<OWLNamedClass> arrayList = new ArrayList<OWLNamedClass>();
        for (Object e : oWLNamedClass.getSubclasses(false)) {
            if (!(e instanceof OWLNamedClass)) continue;
            arrayList.add((OWLNamedClass)e);
        }
        return arrayList;
    }

    public static List<OWLNamedClass> getSuperClassesOf(OWLModel oWLModel, OWLNamedClass oWLNamedClass) {
        ArrayList<OWLNamedClass> arrayList = new ArrayList<OWLNamedClass>();
        for (Object e : oWLNamedClass.getSuperclasses(true)) {
            if (!(e instanceof OWLNamedClass)) continue;
            arrayList.add((OWLNamedClass)e);
        }
        return arrayList;
    }

    public static List<OWLNamedClass> getDirectSuperClassesOf(OWLModel oWLModel, OWLNamedClass oWLNamedClass) {
        ArrayList<OWLNamedClass> arrayList = new ArrayList<OWLNamedClass>();
        for (Object e : oWLNamedClass.getSuperclasses(false)) {
            if (!(e instanceof OWLNamedClass)) continue;
            arrayList.add((OWLNamedClass)e);
        }
        return arrayList;
    }

    public static Set<OWLProperty> getDirectSubPropertiesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string);
        return SWRLOWLUtil.getDirectSubPropertiesOf(oWLModel, oWLProperty);
    }

    public static Set<OWLProperty> getSubPropertiesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string);
        return SWRLOWLUtil.getSubPropertiesOf(oWLModel, oWLProperty);
    }

    public static Set<OWLProperty> getDirectSuperPropertiesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string);
        return SWRLOWLUtil.getDirectSuperPropertiesOf(oWLModel, oWLProperty);
    }

    public static Set<OWLProperty> getSuperPropertiesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string);
        return SWRLOWLUtil.getSuperPropertiesOf(oWLModel, oWLProperty);
    }

    public static Set<OWLProperty> getSubPropertiesOf(OWLModel oWLModel, OWLProperty oWLProperty) {
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        for (Object e : oWLProperty.getSubproperties(true)) {
            if (!(e instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)e);
        }
        return hashSet;
    }

    public static Set<OWLProperty> getEquivalentPropertiesOf(OWLModel oWLModel, OWLProperty oWLProperty) {
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        for (Object e : oWLProperty.getEquivalentProperties()) {
            if (!(e instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)e);
        }
        return hashSet;
    }

    public static Set<OWLProperty> getDirectSubPropertiesOf(OWLModel oWLModel, OWLProperty oWLProperty) throws SWRLOWLUtilException {
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        for (Object e : oWLProperty.getSubproperties(false)) {
            if (!(e instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)e);
        }
        return hashSet;
    }

    public static Set<OWLProperty> getSuperPropertiesOf(OWLModel oWLModel, OWLProperty oWLProperty) throws SWRLOWLUtilException {
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        for (Object e : oWLProperty.getSuperproperties(true)) {
            if (!(e instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)e);
        }
        return hashSet;
    }

    public static Set<OWLProperty> getDirectSuperPropertiesOf(OWLModel oWLModel, OWLProperty oWLProperty) throws SWRLOWLUtilException {
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        for (Object e : oWLProperty.getSuperproperties(false)) {
            if (!(e instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)e);
        }
        return hashSet;
    }

    public static Set<OWLProperty> getDomainProperties(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLClass oWLClass = SWRLOWLUtil.getClass(oWLModel, string);
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        Collection collection = oWLClass.getUnionDomainProperties(bl);
        if (collection != null) {
            for (Object e : oWLClass.getUnionDomainProperties()) {
                if (!(e instanceof OWLProperty)) continue;
                hashSet.add((OWLProperty)e);
            }
        }
        return hashSet;
    }

    public static Set<String> rdfResources2OWLNamedClassNames(Collection<?> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object obj : collection) {
            if (!(obj instanceof OWLNamedClass)) continue;
            hashSet.add(((OWLNamedClass)obj).getName());
        }
        return hashSet;
    }

    public static Set<String> rdfResources2URIs(Collection<?> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object obj : collection) {
            if (!(obj instanceof RDFResource)) continue;
            hashSet.add(((RDFResource)obj).getURI());
        }
        return hashSet;
    }

    public static Set<String> rdfResources2OWLNamedClassURIs(Collection<?> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object obj : collection) {
            if (!(obj instanceof OWLNamedClass)) continue;
            hashSet.add(((OWLNamedClass)obj).getURI());
        }
        return hashSet;
    }

    public static Set<String> rdfResources2OWLPropertyURIs(Collection<?> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object obj : collection) {
            if (!(obj instanceof OWLProperty)) continue;
            hashSet.add(((OWLProperty)obj).getURI());
        }
        return hashSet;
    }

    public static boolean hasInconsistentClasses(OWLModel oWLModel) {
        return !oWLModel.getInconsistentClasses().isEmpty();
    }

    public static String createNewResourceName(OWLModel oWLModel, String string) {
        return oWLModel.createNewResourceName(string);
    }

    public static RDFSDatatype getRDFSDatatype(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        RDFSDatatype rDFSDatatype = oWLModel.getRDFSDatatypeByName(string);
        if (rDFSDatatype == null) {
            throw new SWRLOWLUtilException("error getting RDFSDatatype " + string);
        }
        return rDFSDatatype;
    }

    public static RDFSLiteral createRDFSLiteral(OWLModel oWLModel, String string, RDFSDatatype rDFSDatatype) throws SWRLOWLUtilException {
        RDFSLiteral rDFSLiteral = oWLModel.createRDFSLiteral(string, rDFSDatatype);
        if (rDFSLiteral == null) {
            throw new SWRLOWLUtilException("error creating RDFSLiteral '" + string + "' of type '" + rDFSDatatype + "'");
        }
        return rDFSLiteral;
    }

    public static OWLClass createOWLClassDescription(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLClassParser oWLClassParser = oWLModel.getOWLClassParser();
        OWLClass oWLClass = null;
        try {
            oWLClass = (OWLClass)oWLClassParser.parseClass(oWLModel, string);
        }
        catch (OWLClassParseException oWLClassParseException) {
            throw new SWRLOWLUtilException("OWL class expression " + string + " not valid: " + oWLClassParseException.getMessage());
        }
        return oWLClass;
    }

    public static OWLNamedClass getOWLThingClass(OWLModel oWLModel) {
        return oWLModel.getOWLThingClass();
    }

    public static RDFProperty getOWLSameAsProperty(OWLModel oWLModel) {
        return oWLModel.getOWLSameAsProperty();
    }

    public static void makeSameAs(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        OWLIndividual oWLIndividual2 = SWRLOWLUtil.getOWLIndividual(oWLModel, string2);
        oWLIndividual.addPropertyValue(SWRLOWLUtil.getOWLSameAsProperty(oWLModel), oWLIndividual2);
        oWLIndividual2.addPropertyValue(SWRLOWLUtil.getOWLSameAsProperty(oWLModel), oWLIndividual);
    }

    public static void makeDifferentFrom(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getOWLIndividual(oWLModel, string);
        OWLIndividual oWLIndividual2 = SWRLOWLUtil.getOWLIndividual(oWLModel, string2);
        oWLIndividual.addPropertyValue(SWRLOWLUtil.getOWLDifferentFromProperty(oWLModel), oWLIndividual2);
        oWLIndividual2.addPropertyValue(SWRLOWLUtil.getOWLDifferentFromProperty(oWLModel), oWLIndividual);
    }

    public static Collection<?> getOWLAllDifferents(OWLModel oWLModel) {
        return oWLModel.getOWLAllDifferents();
    }

    public static RDFProperty getOWLDifferentFromProperty(OWLModel oWLModel) {
        return oWLModel.getOWLDifferentFromProperty();
    }

    public static OWLProperty getOWLProperty(OWLModel oWLModel, String string) {
        return oWLModel.getOWLProperty(string);
    }

    public static RDFProperty getRDFProperty(OWLModel oWLModel, String string) {
        return oWLModel.getRDFProperty(string);
    }

    public static OWLProperty getOWLProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = oWLModel.getOWLProperty(string);
        if (bl && oWLProperty == null) {
            throw new SWRLOWLUtilException("no property named '" + string + "' in ontology");
        }
        return oWLProperty;
    }

    public static OWLIndividual getOWLIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return oWLModel.getOWLIndividual(string);
    }

    public static RDFSNamedClass getRDFSNamedClass(OWLModel oWLModel, String string) {
        return oWLModel.getRDFSNamedClass(string);
    }

    public static boolean isSWRLBuiltIn(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource != null && rDFResource.getProtegeType().getName().equals(SWRLNames.Cls.BUILTIN);
    }

    public static boolean isValidClassName(OWLModel oWLModel, String string) {
        return oWLModel.isValidResourceName(string, oWLModel.getRDFSNamedClassClass());
    }

    public static void checkIfIsValidClassName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        if (!SWRLOWLUtil.isValidClassName(oWLModel, string)) {
            throw new SWRLOWLUtilException("invalid named class name " + string);
        }
    }

    public static boolean isValidURI(String string) {
        return URIUtilities.isValidURI((String)string);
    }

    public static String getPrefixForResourceName(OWLModel oWLModel, String string) {
        return oWLModel.getPrefixForResourceName(string);
    }

    public static String getLocalNameForURI(OWLModel oWLModel, String string) {
        return oWLModel.getLocalNameForURI(string);
    }

    public static OWLNamedClass getOWLClassFromName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        String string2 = ParserUtils.dequoteIdentifier(string);
        OWLNamedClass oWLNamedClass = null;
        try {
            oWLNamedClass = ParserUtils.getOWLClassFromName(oWLModel, string2);
            if (oWLNamedClass == null) {
                throw new SWRLOWLUtilException("unknown OWL named class " + string);
            }
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new SWRLOWLUtilException("ambiguous class name " + string);
        }
        return oWLNamedClass;
    }

    public static OWLDatatypeProperty getOWLDataPropertyFromName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        String string2 = ParserUtils.dequoteIdentifier(string);
        OWLDatatypeProperty oWLDatatypeProperty = null;
        try {
            oWLDatatypeProperty = ParserUtils.getOWLDatatypePropertyFromName(oWLModel, string2);
            if (oWLDatatypeProperty == null) {
                throw new SWRLOWLUtilException("unknown OWL data property " + string);
            }
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new SWRLOWLUtilException("ambiguous OWL data property name " + string);
        }
        return oWLDatatypeProperty;
    }

    public static OWLObjectProperty getOWLObjectPropertyFromName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        String string2 = ParserUtils.dequoteIdentifier(string);
        OWLObjectProperty oWLObjectProperty = null;
        try {
            oWLObjectProperty = ParserUtils.getOWLObjectPropertyFromName(oWLModel, string2);
            if (oWLObjectProperty == null) {
                throw new SWRLOWLUtilException("unknown OWL object property " + string);
            }
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new SWRLOWLUtilException("ambiguous OWL object property name " + string);
        }
        return oWLObjectProperty;
    }

    public static OWLIndividual getOWLIndividualFromName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        String string2 = ParserUtils.dequoteIdentifier(string);
        OWLIndividual oWLIndividual = null;
        try {
            oWLIndividual = ParserUtils.getOWLIndividualFromName(oWLModel, string2);
            if (oWLIndividual == null) {
                throw new SWRLOWLUtilException("unknown OWL individual " + string);
            }
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new SWRLOWLUtilException("ambiguous OWL individual name " + string);
        }
        return oWLIndividual;
    }

    public static RDFProperty getRDFPropertyFromName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        String string2 = ParserUtils.dequoteIdentifier(string);
        RDFProperty rDFProperty = null;
        try {
            rDFProperty = ParserUtils.getRDFPropertyFromName(oWLModel, string2);
            if (rDFProperty == null) {
                throw new SWRLOWLUtilException("unknown RDF property " + string);
            }
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new SWRLOWLUtilException("ambiguous RDF property name " + string);
        }
        return rDFProperty;
    }

    public static RDFResource getRDFResourceFromName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        String string2 = ParserUtils.dequoteIdentifier(string);
        RDFResource rDFResource = null;
        try {
            rDFResource = ParserUtils.getRDFResourceFromName(oWLModel, string2);
            if (rDFResource == null) {
                throw new SWRLOWLUtilException("unknown RDF resource " + string);
            }
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new SWRLOWLUtilException("ambiguous RDF resource name " + string);
        }
        return rDFResource;
    }

    public static boolean isExistingRDFResourceWithRDFSLabel(OWLModel oWLModel, String string) {
        String string2 = ParserUtils.dequoteIdentifier(string);
        try {
            if (SWRLOWLUtil.getRDFResourceFromRDFSLabel(oWLModel, string2) != null) {
                return true;
            }
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            return false;
        }
        catch (AmbiguousNameException ambiguousNameException) {
            return true;
        }
        return false;
    }

    public static RDFResource getRDFResourceFromRDFSLabel(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        String string2 = ParserUtils.dequoteIdentifier(string);
        RDFResource rDFResource = null;
        try {
            rDFResource = ParserUtils.getRDFResourceFromRDFSLabel(oWLModel, string2);
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new SWRLOWLUtilException("ambiguous RDF resource name " + string);
        }
        return rDFResource;
    }

    public static RDFSClass getRDFSClassFromName(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        String string2 = ParserUtils.dequoteIdentifier(string);
        RDFSClass rDFSClass = null;
        try {
            RDFSClass rDFSClass2 = ParserUtils.getRDFSClassFromName(oWLModel, string2);
            if (rDFSClass2 == null) {
                throw new SWRLOWLUtilException("unknown RDF resource " + string);
            }
            if (!(rDFSClass2 instanceof RDFSClass)) {
                throw new SWRLOWLUtilException("name " + string + " is not an RDFSClass");
            }
            rDFSClass = rDFSClass2;
        }
        catch (AmbiguousNameException ambiguousNameException) {
            throw new SWRLOWLUtilException("ambiguous RDFS class name " + string);
        }
        return rDFSClass;
    }

    private static void throwException(String string) throws SWRLOWLUtilException {
        throw new SWRLOWLUtilException(string);
    }
}

