/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSymbolPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SWRLRuleSlotWidget
extends AbstractSlotWidget {
    private static final String SWRL_RULE_LABEL = "SWRL Rule";
    private static final String SWRL_RULE_INVALID_LABEL = "SWRL Rule: invalid rule - not savable!";
    private static final String SWRL_RULE_INCOMPLETE_LABEL = "SWRL Rule: incomplete rule - not yet savable";
    private SWRLTextArea swrlTextArea;
    private LabeledComponent swrlTextAreaLabeledComponent;
    private String ruleExpressionInKb = new String();
    private SWRLParser parser;
    private FocusListener _focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            SWRLRuleSlotWidget.this.commitChanges();
        }
    };

    public void initialize() {
        this.buildGUI();
        this.setPreferredColumns(2);
        this.setPreferredRows(5);
        this.parser = new SWRLParser((OWLModel)this.getKnowledgeBase());
    }

    protected void buildGUI() {
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        SWRLSymbolPanel sWRLSymbolPanel = new SWRLSymbolPanel(oWLModel, false, false){

            public void setErrorFlag(boolean bl) {
                if (bl) {
                    SWRLRuleSlotWidget.this.setInvalidValueBorder();
                }
                super.setErrorFlag(bl);
            }
        };
        this.swrlTextArea = new SWRLTextArea(oWLModel, sWRLSymbolPanel){

            protected void updateErrorDisplay() {
                String string = this.getText();
                try {
                    this.checkUniCodeExpression(string);
                    this.getErrorSymbolDisplay().displayError((Throwable)null);
                    SWRLRuleSlotWidget.this.swrlTextAreaLabeledComponent.setHeaderLabel(SWRLRuleSlotWidget.this.getWidgetIncompleteOrOKTitle());
                    this.setBackground(Color.white);
                    SWRLRuleSlotWidget.this.setNormalBorder();
                }
                catch (Throwable throwable) {
                    this.getErrorSymbolDisplay().setErrorFlag(true);
                    this.getErrorSymbolDisplay().displayError(throwable.getMessage());
                    SWRLRuleSlotWidget.this.swrlTextAreaLabeledComponent.setHeaderLabel(SWRLRuleSlotWidget.SWRL_RULE_INVALID_LABEL);
                    this.setBackground(new Color(240, 240, 240));
                    SWRLRuleSlotWidget.this.setInvalidValueBorder();
                }
            }
        };
        this.swrlTextArea.addFocusListener(this._focusListener);
        sWRLSymbolPanel.setSymbolEditor(this.swrlTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.swrlTextArea), "Center");
        jPanel.add((Component)sWRLSymbolPanel, "South");
        this.swrlTextAreaLabeledComponent = new LabeledComponent(SWRL_RULE_LABEL, (Component)jPanel, true);
        this.add((Component)this.swrlTextAreaLabeledComponent);
    }

    protected String getWidgetIncompleteOrOKTitle() {
        String string;
        String string2 = this.swrlTextArea.getText().trim();
        if (string2.equals(string = this.ruleExpressionInKb.trim())) {
            return SWRL_RULE_LABEL;
        }
        return this.parser.isCorrectAndIncomplete(string2) ? SWRL_RULE_INCOMPLETE_LABEL : SWRL_RULE_LABEL;
    }

    public void setInstance(Instance instance) {
        this.commitChanges();
        this.updateGUI((SWRLImp)instance);
        super.setInstance(instance);
    }

    protected void updateGUI(SWRLImp sWRLImp) {
        this.swrlTextAreaLabeledComponent.setHeaderLabel(SWRL_RULE_LABEL);
        this.ruleExpressionInKb = sWRLImp == null ? "" : sWRLImp.getBrowserText();
        this.ruleExpressionInKb = SWRLTextArea.reformatText(this.ruleExpressionInKb);
        if (this.ruleExpressionInKb.equals("<EMPTY_RULE>")) {
            this.swrlTextArea.setText("");
        } else {
            this.swrlTextArea.setText(this.ruleExpressionInKb);
        }
        this.swrlTextArea.getErrorSymbolDisplay().displayError((Throwable)null);
        this.swrlTextArea.setBackground(Color.white);
        this.setNormalBorder();
    }

    public boolean commitChanges() {
        SWRLImp sWRLImp = (SWRLImp)this.getInstance();
        if (sWRLImp == null) {
            return true;
        }
        if (sWRLImp.isDeleted()) {
            return true;
        }
        try {
            sWRLImp.setExpression(this.swrlTextArea.getText());
            this.ruleExpressionInKb = this.swrlTextArea.getText();
            this.swrlTextAreaLabeledComponent.setHeaderLabel(SWRL_RULE_LABEL);
        }
        catch (SWRLParseException sWRLParseException) {
            this.setInvalidValueBorder();
            this.swrlTextArea.getErrorSymbolDisplay().displayError(sWRLParseException);
            this.swrlTextAreaLabeledComponent.setHeaderLabel(SWRL_RULE_INVALID_LABEL);
            return false;
        }
        return true;
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        KnowledgeBase knowledgeBase = cls.getKnowledgeBase();
        if (!(knowledgeBase instanceof OWLModel)) {
            return false;
        }
        return slot.getName().equals(SWRLNames.Slot.BODY);
    }

    public String getSwrlTextAreaText() {
        return this.swrlTextArea.getText();
    }

    public SWRLTextArea getSWRLTextArea() {
        return this.swrlTextArea;
    }

    public void dispose() {
        try {
            this.swrlTextArea.removeFocusListener(this._focusListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.parser = null;
        super.dispose();
    }
}

