/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.BridgePluginManager;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSymbolPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLSymbolEditor;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTableModel;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLTable
extends SymbolTable
implements Disposable {
    public SWRLTable(SWRLTableModel sWRLTableModel, OWLModel oWLModel) {
        super(sWRLTableModel, oWLModel, true, new SWRLSymbolPanel(oWLModel, true, true));
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.getColumnModel().getColumn(2);
        tableColumn.setMaxWidth(60);
        tableColumn2.setPreferredWidth(100);
        tableColumn3.setPreferredWidth(700);
    }

    @Override
    protected SymbolEditorComponent createSymbolEditorComponent(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay) {
        return new SWRLSymbolEditor(oWLModel, symbolErrorDisplay);
    }

    public void dispose() {
        SWRLTableModel sWRLTableModel = (SWRLTableModel)this.getSymbolTableModel();
        sWRLTableModel.dispose();
    }

    @Override
    protected String editMultiLine(RDFResource rDFResource) {
        return null;
    }

    @Override
    protected Icon getDefaultCellEditorIcon(RDFResource rDFResource) {
        return SWRLIcons.getImpIcon();
    }

    @Override
    protected Collection<RDFResource> getNavigationMenuItems(RDFResource rDFResource) {
        SWRLImp sWRLImp = (SWRLImp)rDFResource;
        Set<RDFResource> set = sWRLImp.getReferencedInstances();
        ArrayList<RDFResource> arrayList = new ArrayList<RDFResource>();
        for (RDFResource rDFResource2 : set) {
            if (rDFResource2 instanceof SWRLIndividual) continue;
            arrayList.add(rDFResource2);
        }
        return arrayList;
    }

    public SWRLImp getSelectedImp() {
        int n = this.getSelectedRow();
        if (n >= 0 && n < this.getModel().getRowCount()) {
            return (SWRLImp)this.getSymbolTableModel().getRDFResource(n);
        }
        return null;
    }

    @Override
    protected String getToolTipText(RDFResource rDFResource) {
        if (rDFResource instanceof SWRLImp) {
            OWLDatatypeProperty oWLDatatypeProperty = this.getOWLModel().getRDFSCommentProperty();
            Object object = rDFResource.getPropertyValue(oWLDatatypeProperty);
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof RDFSLiteral) {
                return ((RDFSLiteral)object).toString();
            }
            return null;
        }
        return null;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.getSelectedRow();
        SWRLTableModel sWRLTableModel = (SWRLTableModel)this.getSymbolTableModel();
        super.valueChanged(listSelectionEvent);
        if (n != -1) {
            String string = (String)sWRLTableModel.getValueAt(n, 1);
            BridgePluginManager.setSelectedRuleName(string);
        }
    }

    public void replaceImp(SWRLImp sWRLImp, SWRLImp sWRLImp2) {
        SWRLTableModel sWRLTableModel = (SWRLTableModel)this.getSymbolTableModel();
        int n = sWRLTableModel.indexOf(sWRLImp);
        if (sWRLTableModel.indexOf(sWRLImp2) >= 0) {
            sWRLTableModel.setRowOf(sWRLImp2, n);
            this.setSelectedRow(n);
        }
        sWRLImp.deleteImp();
    }

    @Override
    public void setSelectedRow(RDFResource rDFResource) {
        SWRLTableModel sWRLTableModel = (SWRLTableModel)this.getSymbolTableModel();
        int n = sWRLTableModel.indexOf((SWRLImp)rDFResource);
        this.setSelectedRow(n);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = super.createPopupMenu();
        if (jPopupMenu == null) {
            jPopupMenu = new JPopupMenu();
        }
        jPopupMenu.add(new EnableAllRulesAction());
        jPopupMenu.add(new DisableAllRulesAction());
        return jPopupMenu;
    }

    private class DisableAllRulesAction
    extends AbstractAction {
        public DisableAllRulesAction() {
            super("Disable all rules");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((SWRLTableModel)SWRLTable.this.getSymbolTableModel()).disableAll();
        }
    }

    private class EnableAllRulesAction
    extends AbstractAction {
        public EnableAllRulesAction() {
            super("Enable all rules");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((SWRLTableModel)SWRLTable.this.getSymbolTableModel()).enableAll();
        }
    }
}

