/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataFactory;
import edu.stanford.smi.protegex.owl.swrl.portability.SWRLRuleReference;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLRuleGroup;
import java.util.Set;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLRuleGroupTreeTableModel
extends DefaultTreeTableModel {
    public static final int RuleGroupColumn = 0;
    public static final int IsEnabledColumn = 1;
    public static final int RuleTextColumn = 2;
    private static final int NumberOfColumns = 3;
    private DefaultMutableTreeTableNode rootNode = new DefaultMutableTreeTableNode((Object)new SWRLRuleGroup());
    private Set<SWRLRuleReference> rules;

    public SWRLRuleGroupTreeTableModel(OWLDataFactory oWLDataFactory) throws OWLFactoryException {
        this.setRoot((TreeTableNode)this.rootNode);
        this.rules = oWLDataFactory.getSWRLRules();
        this.addRules(this.rules);
    }

    public void addRule(SWRLRuleReference sWRLRuleReference) {
        boolean bl = false;
        for (int i = 0; i < this.rootNode.getChildCount() && !bl; ++i) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode;
            if (!(this.getChild(this.rootNode, i) instanceof DefaultMutableTreeTableNode) || !((defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)this.getChild(this.rootNode, i)).getUserObject() instanceof SWRLRuleGroup)) continue;
            SWRLRuleGroup sWRLRuleGroup = (SWRLRuleGroup)defaultMutableTreeTableNode.getUserObject();
            if (!sWRLRuleReference.getRuleGroupName().equals(sWRLRuleGroup.getGroupName())) continue;
            defaultMutableTreeTableNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)sWRLRuleReference));
            bl = true;
        }
        if (!bl) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = new DefaultMutableTreeTableNode((Object)new SWRLRuleGroup(sWRLRuleReference.getRuleGroupName(), true));
            defaultMutableTreeTableNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)sWRLRuleReference));
            this.rootNode.add((MutableTreeTableNode)defaultMutableTreeTableNode);
        }
    }

    public void addRules(Set<SWRLRuleReference> set) {
        for (SWRLRuleReference sWRLRuleReference : set) {
            this.addRule(sWRLRuleReference);
        }
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "Group";
                break;
            }
            case 1: {
                string = "Enabled";
                break;
            }
            case 2: {
                string = "Expression";
            }
        }
        return string;
    }

    public Object getValueAt(Object object, int n) {
        Object object2 = null;
        if (object instanceof DefaultMutableTreeTableNode) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)object;
            if (defaultMutableTreeTableNode.getUserObject() instanceof SWRLRuleReference) {
                SWRLRuleReference sWRLRuleReference = (SWRLRuleReference)defaultMutableTreeTableNode.getUserObject();
                switch (n) {
                    case 1: {
                        object2 = sWRLRuleReference.isEnabled();
                        break;
                    }
                    case 2: {
                        object2 = sWRLRuleReference.getRuleText();
                    }
                }
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof SWRLRuleGroup) {
                SWRLRuleGroup sWRLRuleGroup = (SWRLRuleGroup)defaultMutableTreeTableNode.getUserObject();
                switch (n) {
                    case 0: {
                        object2 = sWRLRuleGroup.getGroupName();
                        break;
                    }
                    case 1: {
                        object2 = sWRLRuleGroup.getIsEnabled();
                    }
                }
            }
        }
        return object2;
    }

    public boolean isCellEditable(Object object, int n) {
        boolean bl = false;
        if (object instanceof DefaultMutableTreeTableNode) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)object;
            if (defaultMutableTreeTableNode.getUserObject() instanceof SWRLRuleReference) {
                switch (n) {
                    case 1: 
                    case 2: {
                        bl = true;
                    }
                }
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof SWRLRuleGroup) {
                switch (n) {
                    case 0: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public void setValueAt(Object object, Object object2, int n) {
        if (object2 instanceof DefaultMutableTreeTableNode) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)object2;
            if (defaultMutableTreeTableNode.getUserObject() instanceof SWRLRuleReference) {
                SWRLRuleReference sWRLRuleReference = (SWRLRuleReference)defaultMutableTreeTableNode.getUserObject();
                switch (n) {
                    case 1: {
                        System.err.println("rule enable toggled");
                        sWRLRuleReference.setEnabled((Boolean)object);
                        defaultMutableTreeTableNode.setUserObject((Object)sWRLRuleReference);
                        break;
                    }
                    case 2: {
                        System.err.println("rule text changed: " + object);
                        sWRLRuleReference.setRuleText(object.toString());
                        defaultMutableTreeTableNode.setUserObject((Object)sWRLRuleReference);
                    }
                }
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof SWRLRuleGroup) {
                SWRLRuleGroup sWRLRuleGroup = (SWRLRuleGroup)defaultMutableTreeTableNode.getUserObject();
                switch (n) {
                    case 0: {
                        System.err.println("rule group name changed: " + object);
                        sWRLRuleGroup.setGroupName(object.toString());
                        defaultMutableTreeTableNode.setUserObject((Object)sWRLRuleGroup);
                        break;
                    }
                    case 1: {
                        System.err.println("rule group enable toggled");
                        sWRLRuleGroup.setIsEnabled((Boolean)object);
                        defaultMutableTreeTableNode.setUserObject((Object)sWRLRuleGroup);
                    }
                }
            }
        }
    }
}

