/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protegex.owl.swrl.portability.SWRLRuleReference;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLRuleGroup;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLRuleGroupTreeCellRenderer;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLRuleGroupTreeTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class SWRLRuleGroupTreeTable
extends JXTreeTable {
    SWRLRuleGroupTreeTableModel model;

    public SWRLRuleGroupTreeTable(SWRLRuleGroupTreeTableModel sWRLRuleGroupTreeTableModel) {
        super((TreeTableModel)sWRLRuleGroupTreeTableModel);
        this.model = sWRLRuleGroupTreeTableModel;
        this.setTreeCellRenderer(new SWRLRuleGroupTreeCellRenderer());
        this.setEditable(true);
        this.createPopupMenu();
        this.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.getColumnModel().getColumn(1).setMaxWidth(60);
        this.getColumnModel().getColumn(2).setPreferredWidth(700);
    }

    private void createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new EnableAllRulesAction());
        this.addMouseListener(new PopupListener(jPopupMenu));
    }

    private class EnableAllRulesAction
    extends AbstractAction {
        public EnableAllRulesAction() {
            super("Enable all rules");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.err.println("Selected row?");
            System.err.println("selected: " + SWRLRuleGroupTreeTable.this.getSelectedRow());
            TreePath treePath = SWRLRuleGroupTreeTable.this.getPathForRow(SWRLRuleGroupTreeTable.this.getSelectedRow());
            Object object = treePath.getLastPathComponent();
            System.err.println("path: " + treePath);
            if (object instanceof DefaultMutableTreeTableNode) {
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)object;
                if (defaultMutableTreeTableNode.getUserObject() instanceof SWRLRuleGroup) {
                    SWRLRuleGroup sWRLRuleGroup = (SWRLRuleGroup)defaultMutableTreeTableNode.getUserObject();
                    System.err.println("RuleGroup.name: " + sWRLRuleGroup.getGroupName());
                } else if (defaultMutableTreeTableNode.getUserObject() instanceof SWRLRuleReference) {
                    SWRLRuleReference sWRLRuleReference = (SWRLRuleReference)defaultMutableTreeTableNode.getUserObject();
                    System.err.println("Rule.name: " + sWRLRuleReference.getURI());
                }
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu jPopupMenu) {
            this.popup = jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

