/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.tab;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.swrl.ui.SWRLProjectPlugin;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTablePanel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.BorderLayout;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLTab
extends AbstractTabWidget {
    private SWRLTablePanel panel = null;

    public void initialize() {
        this.setLabel("SWRL Rules");
        this.setIcon(SWRLIcons.getImpsIcon());
        this.activateSWRL();
        this.panel = new SWRLTablePanel((OWLModel)this.getKnowledgeBase(), null, this);
        this.add(this.panel);
    }

    private void activateSWRL() {
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        try {
            ProjectView projectView;
            if (oWLModel.getProject().isMultiUserClient()) {
                return;
            }
            oWLModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/3.3/swrla.owl#"), "swrla");
            oWLModel.getNamespaceManager().setPrefix(new URI("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#"), "sqwrl");
            ImportHelper importHelper = new ImportHelper(oWLModel);
            boolean bl = false;
            if (!ApplicationProperties.getBooleanProperty((String)"protege.owl.swrl.exclude_standard_imports", (boolean)false)) {
                bl |= this.addImport(oWLModel, "http://swrl.stanford.edu/ontologies/3.3/swrla.owl", importHelper);
                bl |= this.addImport(oWLModel, "http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl", importHelper);
                importHelper.importOntologies(false);
            }
            oWLModel.getSystemFrames().getToSlot().setVisible(true);
            oWLModel.getSystemFrames().getFromSlot().setVisible(true);
            SWRLProjectPlugin.setSWRLClassesAndPropertiesVisible(this.getProject(), false);
            SWRLProjectPlugin.adjustWidgets(this.getProject());
            if (bl && (projectView = ProjectManager.getProjectManager().getCurrentProjectView()) != null) {
                projectView.reloadAllTabsExcept((TabWidget)this);
            }
        }
        catch (Exception exception) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Could not activate SWRLTab: " + exception + "\n. Your project might be in an inconsistent state now.");
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }

    private boolean addImport(OWLModel oWLModel, String string, ImportHelper importHelper) throws URISyntaxException {
        if (oWLModel.getTripleStoreModel().getTripleStore(string) == null) {
            importHelper.addImport(new URI(string));
            return true;
        }
        return false;
    }

    public void reconfigure() {
        if (this.panel != null) {
            this.remove(this.panel);
            this.setLayout(new BorderLayout());
            this.add(this.panel);
        }
    }

    public static boolean isSuitable(Project project, Collection<Object> collection) {
        if (project.getKnowledgeBase() instanceof OWLModel) {
            return true;
        }
        collection.add("This tab can only be used with OWL projects.");
        return false;
    }
}

