/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.subtab;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.SWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.ui.SWRLPluginGUIAdapter;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLRuleEngineException;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.subtab.ControlPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.subtab.ImportedAxiomsPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.subtab.ImportedClassDeclarationsPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.subtab.ImportedIndividualDeclarationsPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.subtab.InferredAxiomsPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.subtab.RulesPanel;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public abstract class TargetRuleEngineSubTab
extends JTabbedPane
implements SWRLPluginGUIAdapter {
    private SWRLRuleEngine ruleEngine;

    public Container getPluginContainer() {
        return this;
    }

    public Container createPluginContainer(OWLModel oWLModel, String string, String string2) {
        try {
            this.ruleEngine = this.createRuleEngine(oWLModel, string);
        }
        catch (SWRLRuleEngineException sWRLRuleEngineException) {
            System.err.println(sWRLRuleEngineException.toString());
            return this.makeErrorWindow(sWRLRuleEngineException.toString());
        }
        this.removeAll();
        ControlPanel controlPanel = new ControlPanel(this.ruleEngine, string, string2);
        this.addTab(string, this.getImpsIcon(), controlPanel, "Control Tab");
        RulesPanel rulesPanel = new RulesPanel(this.ruleEngine);
        this.addTab("Rules", this.getImpsIcon(), rulesPanel, "Rules Tab");
        ImportedClassDeclarationsPanel importedClassDeclarationsPanel = new ImportedClassDeclarationsPanel(this.ruleEngine);
        this.addTab("Classes", this.getImpsIcon(), importedClassDeclarationsPanel, "Imported OWL Class Declarations Tab");
        ImportedIndividualDeclarationsPanel importedIndividualDeclarationsPanel = new ImportedIndividualDeclarationsPanel(this.ruleEngine);
        this.addTab("Individuals", this.getImpsIcon(), importedIndividualDeclarationsPanel, "Imported OWL Individual Declarations Tab");
        ImportedAxiomsPanel importedAxiomsPanel = new ImportedAxiomsPanel(this.ruleEngine);
        this.addTab("Axioms", this.getImpsIcon(), importedAxiomsPanel, "Imported OWL Axioms Tab");
        InferredAxiomsPanel inferredAxiomsPanel = new InferredAxiomsPanel(this.ruleEngine);
        this.addTab("Inferred Axioms", this.getImpsIcon(), inferredAxiomsPanel, "Inferred OWL Axioms Tab");
        return this;
    }

    private SWRLRuleEngine createRuleEngine(OWLModel oWLModel, String string) throws SWRLRuleEngineException {
        return SWRLRuleEngineFactory.create(string, oWLModel);
    }

    private Container makeErrorWindow(String string) {
        this.removeAll();
        JPanel jPanel = new JPanel(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jLabel);
        this.add(jPanel);
        return this;
    }

    private Icon getImpsIcon() {
        return SWRLIcons.getImpsIcon();
    }
}

