/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.subtab;

import edu.stanford.smi.protegex.owl.swrl.SWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDataValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLPropertyPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLDataPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLObjectPropertyAssertionAxiomReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLPropertyAssertionAxiomReference;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;

public class InferredAxiomsPanel
extends JPanel {
    private SWRLRuleEngine ruleEngine;
    private InferredAxiomsModel inferredAxiomsModel;
    private JTable table;

    public InferredAxiomsPanel(SWRLRuleEngine sWRLRuleEngine) {
        this.ruleEngine = sWRLRuleEngine;
        this.inferredAxiomsModel = new InferredAxiomsModel();
        this.table = new JTable(this.inferredAxiomsModel);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        this.add("Center", jScrollPane);
    }

    public void validate() {
        this.inferredAxiomsModel.fireTableDataChanged();
        super.validate();
    }

    private class InferredAxiomsModel
    extends AbstractTableModel {
        private InferredAxiomsModel() {
        }

        public int getRowCount() {
            return InferredAxiomsPanel.this.ruleEngine.getNumberOfInferredOWLAxioms();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "Inferred Axioms";
        }

        public Object getValueAt(int n, int n2) {
            String string = "";
            if (n < 0 || n >= this.getRowCount()) {
                string = new String("OUT OF BOUNDS");
            } else {
                OWLAxiomReference oWLAxiomReference = (OWLAxiomReference)InferredAxiomsPanel.this.ruleEngine.getInferredOWLAxioms().toArray()[n];
                if (oWLAxiomReference instanceof OWLPropertyAssertionAxiomReference) {
                    OWLPropertyAssertionAxiomReference oWLPropertyAssertionAxiomReference = (OWLPropertyAssertionAxiomReference)oWLAxiomReference;
                    string = oWLPropertyAssertionAxiomReference.getProperty().getURI() + "(" + oWLPropertyAssertionAxiomReference.getSubject().getURI() + ", ";
                    if (oWLAxiomReference instanceof OWLObjectPropertyAssertionAxiomReference) {
                        OWLObjectPropertyAssertionAxiomReference oWLObjectPropertyAssertionAxiomReference = (OWLObjectPropertyAssertionAxiomReference)oWLAxiomReference;
                        string = string + InferredAxiomsPanel.this.ruleEngine.uri2PrefixedName(oWLObjectPropertyAssertionAxiomReference.getObject().getURI());
                    } else if (oWLAxiomReference instanceof OWLDataPropertyAssertionAxiomReference) {
                        OWLDataPropertyAssertionAxiomReference oWLDataPropertyAssertionAxiomReference = (OWLDataPropertyAssertionAxiomReference)oWLAxiomReference;
                        OWLDataValue oWLDataValue = InferredAxiomsPanel.this.ruleEngine.getOWLDataValueFactory().getOWLDataValue(oWLDataPropertyAssertionAxiomReference.getObject());
                        string = oWLDataValue.isString() || oWLDataValue.isXSDType() ? string + "\"" + oWLDataPropertyAssertionAxiomReference.getObject() + "\"" : string + oWLDataPropertyAssertionAxiomReference.getObject();
                    } else if (oWLAxiomReference instanceof OWLClassPropertyAssertionAxiomReference) {
                        OWLClassPropertyAssertionAxiomReference oWLClassPropertyAssertionAxiomReference = (OWLClassPropertyAssertionAxiomReference)oWLAxiomReference;
                        string = string + InferredAxiomsPanel.this.ruleEngine.uri2PrefixedName(oWLClassPropertyAssertionAxiomReference.getObject().getURI());
                    } else if (oWLAxiomReference instanceof OWLPropertyPropertyAssertionAxiomReference) {
                        OWLPropertyPropertyAssertionAxiomReference oWLPropertyPropertyAssertionAxiomReference = (OWLPropertyPropertyAssertionAxiomReference)oWLAxiomReference;
                        string = string + InferredAxiomsPanel.this.ruleEngine.uri2PrefixedName(oWLPropertyPropertyAssertionAxiomReference.getObject().getURI());
                    }
                    string = string + ")";
                } else {
                    string = oWLAxiomReference.toString();
                }
            }
            return string;
        }
    }
}

