/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.subtab;

import edu.stanford.smi.protegex.owl.swrl.SWRLRuleEngine;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLClassReference;
import edu.stanford.smi.protegex.owl.swrl.portability.OWLNamedIndividualReference;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;

public class ImportedIndividualDeclarationsPanel
extends JPanel {
    private SWRLRuleEngine ruleEngine;
    private ImportedIndividualDeclarationsModel importedIndividualsModel;
    private JTable table;

    public ImportedIndividualDeclarationsPanel(SWRLRuleEngine sWRLRuleEngine) {
        this.ruleEngine = sWRLRuleEngine;
        this.importedIndividualsModel = new ImportedIndividualDeclarationsModel();
        this.table = new JTable(this.importedIndividualsModel);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        this.add("Center", jScrollPane);
    }

    public void validate() {
        this.importedIndividualsModel.fireTableDataChanged();
        super.validate();
    }

    private class ImportedIndividualDeclarationsModel
    extends AbstractTableModel {
        private ImportedIndividualDeclarationsModel() {
        }

        public int getRowCount() {
            return ImportedIndividualDeclarationsPanel.this.ruleEngine.getNumberOfImportedOWLIndividuals();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "Imported Individuals";
        }

        public Object getValueAt(int n, int n2) {
            String string = "";
            if (n < 0 || n >= this.getRowCount()) {
                string = new String("OUT OF BOUNDS");
            } else {
                OWLNamedIndividualReference oWLNamedIndividualReference = (OWLNamedIndividualReference)ImportedIndividualDeclarationsPanel.this.ruleEngine.getImportedOWLIndividuals().toArray()[n];
                for (OWLClassReference oWLClassReference : oWLNamedIndividualReference.getTypes()) {
                    string = string + ImportedIndividualDeclarationsPanel.this.ruleEngine.uri2PrefixedName(oWLClassReference.getURI()) + "(" + ImportedIndividualDeclarationsPanel.this.ruleEngine.uri2PrefixedName(oWLNamedIndividualReference.getURI()) + ") ";
                }
            }
            return string;
        }
    }
}

